/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.api;

import dev.khloeleclair.create.additionallogistics.api.ICurrencyBuilder;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public interface ICurrency {
    public ResourceLocation getId();

    public Iterable<Item> getItems();

    public int getValue(@Nullable Player var1, ItemStack var2, int var3);

    public List<ItemStack> getStacksWithValue(int var1);

    public ExtractionResult extractValue(@Nullable Player var1, ItemStack var2, int var3, boolean var4);

    @Nullable
    public Component formatValue(int var1, TooltipFlag var2);

    public static interface ICurrencyBackend {
        public void registerFormatter(ResourceLocation var1, IValueFormatter var2);

        public void registerCurrency(ResourceLocation var1, ICurrency var2);

        public ICurrencyBuilder newBuilder(ResourceLocation var1);

        @Nullable
        public ICurrency get(ResourceLocation var1);

        @Nullable
        public ICurrency getForItem(Item var1);
    }

    public static interface IValueFormatter {
        @Nullable
        public Component get(int var1, TooltipFlag var2);
    }

    public static interface IAdvancedValueExtractor {
        public ExtractionResult apply(@Nullable Player var1, ItemStack var2, int var3, boolean var4);
    }

    public static interface IAdvancedValueGetter {
        public int get(@Nullable Player var1, ItemStack var2, int var3);
    }

    public record ExtractionResult(List<ItemStack> remaining, int remainingValue) {
    }
}

