/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.client.content.kinetics.lazy;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntityRenderer;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.cog.LazyCogWheelBlockEntity;
import java.util.function.Consumer;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class LazyCogVisual
extends KineticBlockEntityVisual<LazyCogWheelBlockEntity> {
    private final boolean large;
    protected final RotatingInstance rotatingModel;
    @Nullable
    protected final RotatingInstance rotatingTopShaft;
    @Nullable
    protected final RotatingInstance rotatingBottomShaft;

    public static LazyCogVisual small(VisualizationContext modelManager, LazyCogWheelBlockEntity blockEntity, float partialTick) {
        return new LazyCogVisual(modelManager, blockEntity, false, partialTick, Models.partial((PartialModel)AllPartialModels.SHAFTLESS_COGWHEEL));
    }

    public static LazyCogVisual large(VisualizationContext modelManager, LazyCogWheelBlockEntity blockEntity, float partialTick) {
        return new LazyCogVisual(modelManager, blockEntity, true, partialTick, Models.partial((PartialModel)AllPartialModels.SHAFTLESS_LARGE_COGWHEEL));
    }

    public LazyCogVisual(VisualizationContext modelManager, LazyCogWheelBlockEntity blockEntity, boolean large, float partialTick, Model model) {
        super(modelManager, (KineticBlockEntity)blockEntity, partialTick);
        this.large = large;
        this.rotatingModel = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, model).createInstance();
        this.rotatingModel.setup((KineticBlockEntity)blockEntity).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(this.rotationAxis()).setChanged();
        RotatingInstance rotatingTopShaft = null;
        RotatingInstance rotatingBottomShaft = null;
        Block block = this.blockState.getBlock();
        if (block instanceof IRotate) {
            IRotate def = (IRotate)block;
            for (Direction d : Iterate.directionsInAxis((Direction.Axis)this.rotationAxis())) {
                if (!def.hasShaftTowards((LevelReader)blockEntity.getLevel(), blockEntity.getBlockPos(), this.blockState, d)) continue;
                RotatingInstance instance = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.SHAFT_HALF)).createInstance();
                instance.setup((KineticBlockEntity)blockEntity).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(Direction.SOUTH, d).setChanged();
                if (large) {
                    instance.setRotationOffset(BracketedKineticBlockEntityRenderer.getShaftAngleOffset((Direction.Axis)this.rotationAxis(), (BlockPos)this.pos));
                }
                if (d.getAxisDirection() == Direction.AxisDirection.POSITIVE) {
                    rotatingTopShaft = instance;
                    continue;
                }
                rotatingBottomShaft = instance;
            }
        }
        this.rotatingTopShaft = rotatingTopShaft;
        this.rotatingBottomShaft = rotatingBottomShaft;
    }

    public void update(float pt) {
        this.rotatingModel.setup((KineticBlockEntity)this.blockEntity).setChanged();
        if (this.rotatingTopShaft != null) {
            this.rotatingTopShaft.setup((KineticBlockEntity)this.blockEntity).setChanged();
        }
        if (this.rotatingBottomShaft != null) {
            this.rotatingBottomShaft.setup((KineticBlockEntity)this.blockEntity).setChanged();
        }
    }

    public void updateLight(float partialTick) {
        this.relight(new FlatLit[]{this.rotatingModel, this.rotatingTopShaft, this.rotatingBottomShaft});
    }

    protected void _delete() {
        this.rotatingModel.delete();
        if (this.rotatingTopShaft != null) {
            this.rotatingTopShaft.delete();
        }
        if (this.rotatingBottomShaft != null) {
            this.rotatingBottomShaft.delete();
        }
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept((Instance)this.rotatingModel);
        consumer.accept((Instance)this.rotatingTopShaft);
        consumer.accept((Instance)this.rotatingBottomShaft);
    }
}

