/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.content.logistics.cashRegister;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.compat.Mods;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.content.logistics.tableCloth.ShoppingListItem;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.utility.CreateLang;
import dan200.computercraft.api.peripheral.PeripheralCapability;
import dev.khloeleclair.create.additionallogistics.CreateAdditionalLogistics;
import dev.khloeleclair.create.additionallogistics.api.ICurrency;
import dev.khloeleclair.create.additionallogistics.common.CALLang;
import dev.khloeleclair.create.additionallogistics.common.content.logistics.cashRegister.CashRegisterBlock;
import dev.khloeleclair.create.additionallogistics.common.content.logistics.cashRegister.CashRegisterMenu;
import dev.khloeleclair.create.additionallogistics.common.content.logistics.cashRegister.SalesHistoryData;
import dev.khloeleclair.create.additionallogistics.common.registries.CALBlockEntityTypes;
import dev.khloeleclair.create.additionallogistics.common.registries.CALDataComponents;
import dev.khloeleclair.create.additionallogistics.common.registries.CALItems;
import dev.khloeleclair.create.additionallogistics.common.utilities.CurrencyUtilities;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.AbstractEventfulComputerBehavior;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.CALComputerCraftProxy;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.ClientTooltipFlag;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.Nullable;

public class CashRegisterBlockEntity
extends StockTickerBlockEntity {
    public AbstractEventfulComputerBehavior computerBehavior;
    private ItemStack ledger = ItemStack.EMPTY;
    private final IItemHandlerModifiable ledgerHandler;
    public final CombinedInvWrapper invWrapper;
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level level, BlockPos blockPos, BlockState blockState) {
            CashRegisterBlockEntity.this.playSound(blockState, AllSoundEvents.STOCK_TICKER_TRADE.getMainEvent());
            CashRegisterBlockEntity.this.updateBlockState(blockState, true);
        }

        protected void onClose(Level level, BlockPos blockPos, BlockState blockState) {
            CashRegisterBlockEntity.this.updateBlockState(blockState, false);
        }

        protected void openerCountChanged(Level level, BlockPos blockPos, BlockState blockState, int i, int i1) {
        }

        protected boolean isOwnContainer(Player player) {
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof CashRegisterMenu) {
                CashRegisterMenu menu = (CashRegisterMenu)abstractContainerMenu;
                return menu.contentHolder == CashRegisterBlockEntity.this;
            }
            return false;
        }
    };
    private int saleTicks = 0;

    public CashRegisterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.ledgerHandler = new IItemHandlerModifiable(){

            public void setStackInSlot(int slot, ItemStack stack) {
                if (this.isItemValid(slot, stack)) {
                    CashRegisterBlockEntity.this.ledger = stack;
                }
            }

            public int getSlots() {
                return 1;
            }

            public ItemStack getStackInSlot(int slot) {
                return CashRegisterBlockEntity.this.ledger;
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                return stack;
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (slot != 1 && amount < 1) {
                    return ItemStack.EMPTY;
                }
                ItemStack result = CashRegisterBlockEntity.this.ledger;
                if (!simulate) {
                    CashRegisterBlockEntity.this.ledger = ItemStack.EMPTY;
                }
                CashRegisterBlockEntity.this.notifyUpdate();
                return result;
            }

            public int getSlotLimit(int slot) {
                return slot == 0 ? 1 : 0;
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                if (slot != 0 || stack.isEmpty() || !stack.is(CALItems.SALES_LEDGER) || stack.getCount() != 1) {
                    return false;
                }
                SalesHistoryData history = (SalesHistoryData)stack.get(CALDataComponents.SALES_HISTORY);
                return history == null || history.saleCount() < 1000;
            }
        };
        this.invWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.receivedPayments, this.ledgerHandler});
    }

    public void invalidate() {
        super.invalidate();
        this.computerBehavior.removePeripheral();
    }

    public boolean hadRecentSale() {
        return this.saleTicks > 0;
    }

    void updateBlockState(BlockState state, boolean open) {
        if (this.level != null) {
            this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)CashRegisterBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    void playSound(BlockState state, SoundEvent sound) {
        if (this.level == null) {
            return;
        }
        Vec3i face = ((Direction)state.getValue((Property)CashRegisterBlock.FACING)).getNormal();
        double x = (double)this.worldPosition.getX() + 0.5 + (double)face.getX() / 2.0;
        double y = (double)this.worldPosition.getY() + 0.5 + (double)face.getY() / 2.0;
        double z = (double)this.worldPosition.getZ() + 0.5 + (double)face.getZ() / 2.0;
        this.level.playSound(null, x, y, z, sound, SoundSource.BLOCKS, 0.5f, 1.0f);
    }

    public void startOpen(Player player) {
        if (!this.remove && !player.isSpectator() && this.level != null) {
            this.openersCounter.incrementOpeners(player, this.level, this.worldPosition, this.getBlockState());
        }
    }

    public void stopOpen(Player player) {
        if (!this.remove && !player.isSpectator() && this.ledger != null) {
            this.openersCounter.decrementOpeners(player, this.level, this.worldPosition, this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (!this.remove && this.level != null) {
            this.openersCounter.recheckOpeners(this.level, this.worldPosition, this.getBlockState());
        }
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)CALBlockEntityTypes.CASH_REGISTER.get(), (be, context) -> context == Direction.DOWN ? be.receivedPayments : (context == Direction.UP ? be.ledgerHandler : be.invWrapper));
        if (Mods.COMPUTERCRAFT.isLoaded()) {
            event.registerBlockEntity(PeripheralCapability.get(), (BlockEntityType)CALBlockEntityTypes.CASH_REGISTER.get(), (be, context) -> be.computerBehavior.getPeripheralCapability());
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        behaviours.removeIf(x -> x instanceof AbstractComputerBehaviour);
        this.computerBehavior = CALComputerCraftProxy.behavior((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.computerBehavior);
    }

    public void tick() {
        super.tick();
        if (this.saleTicks > 0) {
            --this.saleTicks;
        }
    }

    public void destroy() {
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.ledgerHandler);
        super.destroy();
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        if (this.ledger != null && !this.ledger.isEmpty()) {
            tag.put("Ledger", this.ledger.save(registries));
        }
        tag.putInt("SaleTicks", this.saleTicks);
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.ledger = ItemStack.EMPTY;
        if (tag.contains("Ledger", 10)) {
            this.ledger = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("Ledger"));
        }
        this.saleTicks = tag.getInt("SaleTicks");
    }

    public static void recordSale(Level level, BlockPos pos, Player player, ItemStack mainHandItem) {
        BlockEntity blockEntity;
        if (level.isClientSide || mainHandItem.isEmpty() || !((blockEntity = level.getBlockEntity(pos)) instanceof CashRegisterBlockEntity)) {
            return;
        }
        CashRegisterBlockEntity be = (CashRegisterBlockEntity)blockEntity;
        if (player.getMainHandItem().equals(mainHandItem)) {
            return;
        }
        ShoppingListItem.ShoppingList list = ShoppingListItem.getList((ItemStack)mainHandItem);
        if (list == null) {
            return;
        }
        be.recordSale(player, list);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Object object;
        if (this.receivedPayments.isEmpty() && this.ledger.isEmpty()) {
            return false;
        }
        if (!this.behaviour.mayAdministrate((Player)Minecraft.getInstance().player)) {
            return false;
        }
        if (!this.ledger.isEmpty() && (object = this.ledger.get(CALDataComponents.SALES_HISTORY)) instanceof SalesHistoryData) {
            SalesHistoryData history = (SalesHistoryData)object;
            CALLang.translate("sales.sales", CALLang.number(history.saleCount()).style(ChatFormatting.GOLD)).style(ChatFormatting.WHITE).forGoggles(tooltip);
            MutableComponent cmp = history.getTimeRange(ChatFormatting.AQUA);
            if (cmp != null) {
                CALLang.builder().add(cmp.withStyle(ChatFormatting.WHITE)).forGoggles(tooltip);
            }
            if (!this.receivedPayments.isEmpty()) {
                tooltip.add((Component)Component.literal((String)""));
            }
        }
        if (!this.receivedPayments.isEmpty()) {
            CreateLang.translate((String)"stock_ticker.contains_payments", (Object[])new Object[0]).style(ChatFormatting.WHITE).forGoggles(tooltip);
            InventorySummary summary = new InventorySummary();
            for (int i = 0; i < this.receivedPayments.getSlots(); ++i) {
                summary.add(this.receivedPayments.getStackInSlot(i));
            }
            Pair<Map<ICurrency, Integer>, List<BigItemStack>> costs = CurrencyUtilities.splitCost(null, summary.getStacks());
            Map currency_costs = (Map)costs.getFirst();
            List other_costs = (List)costs.getSecond();
            Options options = Minecraft.getInstance().options;
            TooltipFlag tooltipFlags = ClientTooltipFlag.of((TooltipFlag)(options.advancedItemTooltips ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL));
            for (Map.Entry entry : currency_costs.entrySet()) {
                Component cmp;
                ICurrency currency = (ICurrency)entry.getKey();
                try {
                    cmp = currency.formatValue((Integer)entry.getValue(), tooltipFlags);
                }
                catch (Exception ex) {
                    CreateAdditionalLogistics.LOGGER.error("Error running currency formatter for {}", (Object)currency.getId(), (Object)ex);
                    cmp = null;
                }
                if (cmp != null) {
                    CreateLang.builder().add(cmp).style(ChatFormatting.GREEN).forGoggles(tooltip);
                    continue;
                }
                for (ItemStack stack : currency.getStacksWithValue((Integer)entry.getValue())) {
                    CreateLang.builder().text(Component.translatable((String)stack.getDescriptionId()).getString() + " x" + stack.getCount()).style(ChatFormatting.GREEN).forGoggles(tooltip);
                }
            }
            for (BigItemStack bigItemStack : other_costs) {
                CreateLang.builder().text(Component.translatable((String)bigItemStack.stack.getDescriptionId()).getString() + " x" + bigItemStack.count).style(ChatFormatting.GREEN).forGoggles(tooltip);
            }
        }
        return true;
    }

    public void recordSale(Player player, ShoppingListItem.ShoppingList list) {
        SalesHistoryData history;
        Couple baked = list.bakeEntries((LevelAccessor)this.level, null);
        InventorySummary payment = (InventorySummary)baked.getSecond();
        InventorySummary order = (InventorySummary)baked.getFirst();
        SalesHistoryData salesHistoryData = history = this.ledger.isEmpty() ? null : (SalesHistoryData)this.ledger.get(CALDataComponents.SALES_HISTORY);
        if (history == null) {
            history = SalesHistoryData.EMPTY;
        }
        if (history.saleCount() >= 1000) {
            this.ledger = ItemHandlerHelper.insertItem((IItemHandler)this.receivedPayments, (ItemStack)this.ledger, (boolean)false);
            if (this.ledger.isEmpty()) {
                history = SalesHistoryData.EMPTY;
            } else {
                return;
            }
        }
        SalesHistoryData result = history.withBigSale(player.getUUID(), payment.getStacks(), order.getStacks());
        this.computerBehavior.queuePositionedEvent("sale", Pair.of((Object)history, (Object)history.lastSale()));
        if (this.ledger.isEmpty()) {
            this.ledger = CALItems.SALES_LEDGER.asStack();
        }
        this.ledger.set(CALDataComponents.SALES_HISTORY, (Object)result);
        this.reconcileCurrency();
        this.saleTicks = 20;
        this.notifyUpdate();
    }

    public void reconcileCurrency() {
        if (this.level.isClientSide) {
            return;
        }
        Object2IntArrayMap currencies = new Object2IntArrayMap();
        IntArrayList slots = new IntArrayList();
        int empty_slots = 0;
        for (int slot = 0; slot < this.receivedPayments.getSlots(); ++slot) {
            ItemStack stack = this.receivedPayments.getStackInSlot(slot);
            if (stack.isEmpty()) {
                ++empty_slots;
                continue;
            }
            ICurrency iCurrency = CurrencyUtilities.getForItem(stack.getItem());
            if (!(iCurrency instanceof ICurrency)) continue;
            ICurrency iterator = iCurrency;
            currencies.put(iterator, currencies.getOrDefault(iterator, 0) + iterator.getValue(null, stack, stack.getCount()));
            slots.add(slot);
        }
        if (currencies.isEmpty()) {
            return;
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Map.Entry entry : currencies.entrySet()) {
            stacks.addAll(((ICurrency)entry.getKey()).getStacksWithValue((Integer)entry.getValue()));
        }
        int available_slots = empty_slots + slots.size();
        if (available_slots < stacks.size()) {
            return;
        }
        Iterator iterator = slots.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            this.receivedPayments.setStackInSlot(slot, ItemStack.EMPTY);
        }
        for (ItemStack stack : stacks) {
            ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)this.receivedPayments, (ItemStack)stack, (boolean)false);
            if (remainder.isEmpty()) continue;
            ItemEntity entity = new ItemEntity(this.level, (double)this.worldPosition.getX(), (double)((float)this.worldPosition.getY() + 0.5f), (double)this.worldPosition.getZ(), remainder);
            entity.setPickUpDelay(40);
            this.level.addFreshEntity((Entity)entity);
        }
    }

    public SmartInventory getReceivedPaymentsHandler() {
        return this.receivedPayments;
    }

    public ItemStack getLedger() {
        return this.ledger;
    }

    public class CashRegisterMenuProvider
    implements MenuProvider {
        @Nullable
        public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
            return CashRegisterMenu.create(id, inventory, CashRegisterBlockEntity.this);
        }

        public Component getDisplayName() {
            return CashRegisterBlockEntity.this.getBlockState().getBlock().getName();
        }
    }
}

