/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.datagen;

import dev.khloeleclair.create.additionallogistics.CreateAdditionalLogistics;
import dev.khloeleclair.create.additionallogistics.common.registries.CALDataMaps;
import it.unimi.dsi.fastutil.Pair;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.data.DataMapProvider;

public class CALDataMapProvider
extends DataMapProvider {
    private static final String NUMISMATICS = "numismatics";

    public CALDataMapProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    public static CALDataMaps.CurrencyData get(String id, int value) {
        return new CALDataMaps.CurrencyData(CreateAdditionalLogistics.asResource(id), value);
    }

    public static CALDataMaps.CurrencyData get(String namespace, String id, int value) {
        return new CALDataMaps.CurrencyData(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)id), value);
    }

    protected void gather(HolderLookup.Provider provider) {
        super.gather(provider);
        this.addNumismaticsCoins(provider);
    }

    private void addNumismaticsCoins(HolderLookup.Provider provider) {
        Pair[] coins;
        DataMapProvider.Builder builder = this.builder(CALDataMaps.CURRENCY_DATA).conditions(new ICondition[]{new ModLoadedCondition(NUMISMATICS)});
        for (Pair entry : coins = new Pair[]{Pair.of((Object)"spur", (Object)1), Pair.of((Object)"bevel", (Object)8), Pair.of((Object)"sprocket", (Object)16), Pair.of((Object)"cog", (Object)64), Pair.of((Object)"crown", (Object)512), Pair.of((Object)"sun", (Object)4096)}) {
            String key = (String)entry.first();
            int value = (Integer)entry.second();
            builder.add(ResourceLocation.fromNamespaceAndPath((String)NUMISMATICS, (String)key), (Object)CALDataMapProvider.get(NUMISMATICS, "coins", value), false, new ICondition[0]);
        }
        builder.build();
    }
}

