/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.utilities;

import dev.khloeleclair.create.additionallogistics.CreateAdditionalLogistics;
import dev.khloeleclair.create.additionallogistics.common.utilities.SidedCache;
import dev.khloeleclair.create.additionallogistics.common.utilities.SimpleCurrency;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;
import org.jetbrains.annotations.Nullable;

public class RecipeHelper {
    public static RecipeCache getCache() {
        return SidedCache.getCache(RecipeCache.class);
    }

    public static void onRecipesUpdated(RecipesUpdatedEvent ignoredEvent) {
        SidedCache.runOnEachCache(RecipeCache.class, RecipeCache::clearCache);
    }

    @Nullable
    public static SimpleCurrency getCompactingCurrency(Item input) {
        return RecipeHelper.getCache().getCompactingCurrency(input);
    }

    public static <I extends CraftingInput, T extends Recipe<I>> List<RecipeHolder<T>> safeGetRecipesFor(RecipeType<T> recipeType, I inventory, Level level) {
        try {
            return level.getRecipeManager().getRecipesFor(recipeType, inventory, level);
        }
        catch (Exception e) {
            CreateAdditionalLogistics.LOGGER.error("Error while getting recipe: ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static class RecipeCache
    extends SidedCache {
        private final Map<Item, @Nullable SimpleCurrency> compactingCurrencies = new Object2ObjectOpenHashMap();

        public RecipeCache(boolean isServer) {
            super(isServer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearCache() {
            Map<Item, SimpleCurrency> map = this.compactingCurrencies;
            synchronized (map) {
                this.compactingCurrencies.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public SimpleCurrency getCompactingCurrency(Item item) {
            ResourceLocation id;
            int count;
            ItemStack result;
            SimpleCurrency cached;
            Level level = this.getLevel();
            if (level == null) {
                return null;
            }
            Map<Item, SimpleCurrency> map = this.compactingCurrencies;
            synchronized (map) {
                cached = this.compactingCurrencies.get(item);
            }
            if (cached != null) {
                return cached;
            }
            ArrayList<Pair> decompression = new ArrayList<Pair>();
            ArrayList<Pair> compression = new ArrayList<Pair>();
            HashSet<Item> visited = new HashSet<Item>();
            visited.add(item);
            Item current = item;
            while (!(result = RecipeCache.getUncompressResult(level, current.getDefaultInstance())).isEmpty() && ((count = result.getCount()) == 4 || count == 9) && visited.add(result.getItem())) {
                List<ItemStack> compressionResult = RecipeCache.getCompressionResult(level, result, count == 4 ? 2 : 3);
                Item finalCurrent = current;
                if (compressionResult.stream().noneMatch(x -> x.is(finalCurrent) && x.getCount() == 1)) break;
                current = result.getItem();
                decompression.add(Pair.of((Object)current, (Object)count));
            }
            LinkedList<Item> frontier = new LinkedList<Item>();
            frontier.add(item);
            while (!frontier.isEmpty()) {
                current = (Item)frontier.removeFirst();
                for (int size = 2; size <= 3; ++size) {
                    for (ItemStack result2 : RecipeCache.getCompressionResult(level, current.getDefaultInstance(), size)) {
                        ItemStack uncompressResult;
                        if (result2.isEmpty() || result2.getCount() != 1 || !visited.add(result2.getItem()) || (uncompressResult = RecipeCache.getUncompressResult(level, result2)).isEmpty() || uncompressResult.getCount() != (size == 2 ? 4 : 9) || !uncompressResult.is(current)) continue;
                        frontier.add(result2.getItem());
                        compression.add(Pair.of((Object)result2.getItem(), (Object)(size == 2 ? 4 : 9)));
                    }
                }
            }
            if (decompression.isEmpty() && compression.isEmpty()) {
                return null;
            }
            @Nullable ResourceKey key = decompression.isEmpty() ? item.builtInRegistryHolder().getKey() : ((Item)((Pair)decompression.getLast()).getFirst()).builtInRegistryHolder().getKey();
            ResourceLocation resourceLocation = id = key == null ? null : key.location();
            if (id == null) {
                return null;
            }
            SimpleCurrency currency = new SimpleCurrency(ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("generated/" + id.getPath())));
            int value = 1;
            for (int i = decompression.size() - 1; i >= 0; --i) {
                Pair entry = (Pair)decompression.get(i);
                currency.addItem((Item)entry.getFirst(), value);
                value *= ((Integer)entry.getSecond()).intValue();
            }
            currency.addItem(item, value);
            for (Pair entry : compression) {
                currency.addItem((Item)entry.getFirst(), value *= ((Integer)entry.getSecond()).intValue());
            }
            Map<Item, SimpleCurrency> map2 = this.compactingCurrencies;
            synchronized (map2) {
                for (Item i : currency.getItems()) {
                    this.compactingCurrencies.put(i, currency);
                }
            }
            return currency;
        }

        private static List<ItemStack> getCompressionResult(Level level, ItemStack input, int size) {
            List<ItemStack> inputGrid;
            if (size == 1) {
                inputGrid = List.of(input.copyWithCount(1));
            } else if (size == 2) {
                inputGrid = List.of(input.copyWithCount(1), input.copyWithCount(1), input.copyWithCount(1), input.copyWithCount(1));
            } else if (size == 3) {
                inputGrid = List.of(input.copyWithCount(1), input.copyWithCount(1), input.copyWithCount(1), input.copyWithCount(1), input.copyWithCount(1), input.copyWithCount(1), input.copyWithCount(1), input.copyWithCount(1), input.copyWithCount(1));
            } else {
                return List.of();
            }
            List recipes = RecipeHelper.safeGetRecipesFor(RecipeType.CRAFTING, CraftingInput.of((int)size, (int)size, inputGrid), level);
            if (recipes.isEmpty()) {
                return List.of();
            }
            return recipes.stream().map(x -> ((CraftingRecipe)x.value()).getResultItem((HolderLookup.Provider)level.registryAccess())).toList();
        }

        private static ItemStack getUncompressResult(Level level, ItemStack input) {
            CraftingInput inputGrid = CraftingInput.of((int)1, (int)1, List.of(input.copyWithCount(1)));
            List recipes = RecipeHelper.safeGetRecipesFor(RecipeType.CRAFTING, inputGrid, level);
            if (recipes.size() != 1) {
                return ItemStack.EMPTY;
            }
            return ((CraftingRecipe)recipes.getFirst().value()).getResultItem((HolderLookup.Provider)level.registryAccess());
        }
    }
}

