/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.luaObjects;

import com.simibubi.create.api.contraption.storage.fluid.MountedFluidStorageWrapper;
import com.simibubi.create.compat.computercraft.implementation.CreateLuaTable;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.Schedule;
import com.simibubi.create.content.trains.station.GlobalStation;
import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dev.khloeleclair.create.additionallogistics.CreateAdditionalLogistics;
import dev.khloeleclair.create.additionallogistics.common.Config;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.ComputerUtil;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.luaObjects.LuaComparable;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.luaObjects.LuaInventoryTrainObject;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.luaObjects.LuaStationObject;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.luaObjects.LuaWriteableInventoryTrainObject;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.luaObjects.LuaWriteableTrainObject;
import dev.khloeleclair.create.additionallogistics.mixin.IStationPeripheralAccessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.Nullable;

public class LuaTrainObject
implements LuaComparable {
    protected final Train train;

    public static LuaTrainObject of(Train train, boolean writeable) {
        boolean allow_inventory = (Boolean)Config.Server.trainInventoryAccess.get();
        if (writeable) {
            return allow_inventory ? new LuaWriteableInventoryTrainObject(train) : new LuaWriteableTrainObject(train);
        }
        return allow_inventory ? new LuaInventoryTrainObject(train) : new LuaTrainObject(train);
    }

    protected LuaTrainObject(Train train) {
        this.train = train;
    }

    protected boolean isWriteable() {
        return false;
    }

    @Nullable
    protected ResourceKey<Level> getDimension() {
        for (Carriage carriage : this.train.carriages) {
            List dimensions = carriage.getPresentDimensions();
            if (dimensions.isEmpty()) continue;
            return (ResourceKey)dimensions.getFirst();
        }
        return null;
    }

    @Nullable
    protected Level getLevel() {
        MinecraftServer server = CreateAdditionalLogistics.getServer();
        if (server == null) {
            return null;
        }
        for (Carriage carriage : this.train.carriages) {
            ServerLevel level;
            List dimensions = carriage.getPresentDimensions();
            if (dimensions.isEmpty() || (level = server.getLevel((ResourceKey)dimensions.getFirst())) == null) continue;
            return level;
        }
        return null;
    }

    @LuaFunction(mainThread=true)
    public final String getId() {
        return this.train.id.toString();
    }

    @LuaFunction(mainThread=true)
    public final boolean isDerailed() {
        return this.train.derailed;
    }

    @LuaFunction(mainThread=true)
    @Nullable
    public final LuaStationObject getStation() {
        GlobalStation station = this.train.getCurrentStation();
        if (station == null) {
            return null;
        }
        return LuaStationObject.of(station, this.isWriteable());
    }

    @LuaFunction(mainThread=true)
    public final double getSpeed() {
        return this.train.speed;
    }

    @LuaFunction(mainThread=true)
    public final double getTargetSpeed() {
        return this.train.targetSpeed;
    }

    @LuaFunction(mainThread=true)
    public final double getThrottle() {
        return this.train.throttle;
    }

    @LuaFunction(mainThread=true)
    @Nullable
    public final Map<String, Object> getPosition() {
        Optional pos;
        ResourceKey<Level> dimension = this.getDimension();
        Optional optional = pos = dimension == null ? Optional.empty() : this.train.getPositionInDimension(dimension);
        if (pos.isEmpty()) {
            return null;
        }
        return ComputerUtil.getPosition((BlockPos)pos.get(), dimension);
    }

    @LuaFunction(mainThread=true)
    public final String getName() {
        return this.train.name.getString();
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Integer> listPackageDestinations() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Carriage carriage : this.train.carriages) {
            CombinedInvWrapper inventory = carriage.storage.getAllItems();
            if (inventory == null) continue;
            for (int slot = 0; slot < inventory.getSlots(); ++slot) {
                ItemStack stack = inventory.getStackInSlot(slot);
                if (!PackageItem.isPackage((ItemStack)stack)) continue;
                String address = PackageItem.getAddress((ItemStack)stack);
                result.put(address, result.getOrDefault(address, 0) + 1);
            }
        }
        return result;
    }

    protected Integer sizeItemsInternal() {
        int i = 0;
        for (Carriage carriage : this.train.carriages) {
            CombinedInvWrapper inventory = carriage.storage.getAllItems();
            if (inventory == null) continue;
            i += inventory.getSlots();
        }
        return i;
    }

    protected Map<?, ?> getItemDetailInternal(int slot) throws LuaException {
        int i = slot - 1;
        int total = 0;
        for (Carriage carriage : this.train.carriages) {
            CombinedInvWrapper inventory = carriage.storage.getAllItems();
            if (inventory == null) continue;
            total += inventory.getSlots();
            if (i >= inventory.getSlots()) {
                i -= inventory.getSlots();
                continue;
            }
            if (i < 0) break;
            ItemStack stack = inventory.getStackInSlot(i);
            return VanillaDetailRegistries.ITEM_STACK.getDetails((Object)stack);
        }
        throw new LuaException("Slot " + slot + " out of range, available slots between 1 and " + total);
    }

    protected Integer getItemLimitInternal(int slot) throws LuaException {
        int i = slot - 1;
        int total = 0;
        for (Carriage carriage : this.train.carriages) {
            CombinedInvWrapper inventory = carriage.storage.getAllItems();
            if (inventory == null) continue;
            total += inventory.getSlots();
            if (i >= inventory.getSlots()) {
                i -= inventory.getSlots();
                continue;
            }
            if (i < 0) break;
            return inventory.getSlotLimit(i);
        }
        throw new LuaException("Slot " + slot + " out of range, available slots between 1 and " + total);
    }

    protected Map<Integer, Object> listItemsInternal(boolean skip_non_packages) {
        HashMap<Integer, Object> result = new HashMap<Integer, Object>();
        int i = 0;
        for (Carriage carriage : this.train.carriages) {
            CombinedInvWrapper inventory = carriage.storage.getAllItems();
            if (inventory == null) continue;
            for (int slot = 0; slot < inventory.getSlots(); ++slot) {
                ItemStack stack = inventory.getStackInSlot(slot);
                ++i;
                if (stack.isEmpty() || skip_non_packages && !PackageItem.isPackage((ItemStack)stack)) {
                    result.put(i, null);
                    continue;
                }
                result.put(i, VanillaDetailRegistries.ITEM_STACK.getBasicDetails((Object)stack));
            }
        }
        return result;
    }

    protected Map<Integer, Object> tanksInternal() {
        HashMap<Integer, Object> result = new HashMap<Integer, Object>();
        int i = 0;
        for (Carriage carriage : this.train.carriages) {
            MountedFluidStorageWrapper fluids = carriage.storage.getFluids();
            if (fluids == null) continue;
            for (int tank = 0; tank < fluids.getTanks(); ++tank) {
                ++i;
                FluidStack fluid = fluids.getFluidInTank(tank);
                if (fluid == null || fluid.isEmpty()) {
                    result.put(i, null);
                    continue;
                }
                HashMap<String, Object> tankData = new HashMap<String, Object>();
                tankData.put("capacity", fluids.getTankCapacity(tank));
                tankData.put("amount", fluid.getAmount());
                Holder holder = fluid.getFluidHolder();
                String key = holder == null || holder.getKey() == null ? null : holder.getKey().location().toString();
                tankData.put("name", key);
                result.put(i, tankData);
            }
        }
        return result;
    }

    @LuaFunction(mainThread=true)
    public final boolean hasSchedule() {
        return this.train.runtime.getSchedule() != null;
    }

    @LuaFunction(mainThread=true)
    @Nullable
    public final CreateLuaTable getSchedule() throws LuaException {
        Schedule schedule = this.train.runtime.getSchedule();
        if (schedule == null) {
            return null;
        }
        Level level = this.getLevel();
        if (level == null) {
            throw new LuaException("train in unknown dimension");
        }
        return IStationPeripheralAccessor.callFromCompoundTag(schedule.write((HolderLookup.Provider)level.registryAccess()));
    }

    @Override
    public Map<?, ?> getTableRepresentation() {
        HashMap<String, UUID> result = new HashMap<String, UUID>();
        result.put("id", this.train.id);
        return result;
    }
}

