/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.flexible;

import com.simibubi.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.simibubi.create.content.decoration.encasing.EncasedBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.tterrag.registrate.util.entry.BlockEntry;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.flexible.FlexibleShaftBlock;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.flexible.FlexibleShaftBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.registries.CALBlocks;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class EncasedFlexibleShaftBlock
extends FlexibleShaftBlock
implements SpecialBlockItemRequirement,
EncasedBlock {
    public static final VoxelShape ENCASED_SHAPE = Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    public static final VoxelShape[] ENCASED_SIDE_SHAPES = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    private static final Map<Byte, VoxelShape> ENCASED_SHAPE_CACHE = new Byte2ObjectOpenHashMap();
    private final Supplier<Block> casing;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected VoxelShape getShapeWithSides(byte key) {
        VoxelShape cached;
        Map<Byte, VoxelShape> object = ENCASED_SHAPE_CACHE;
        synchronized (object) {
            cached = ENCASED_SHAPE_CACHE.get(key);
        }
        if (cached == null) {
            cached = ENCASED_SHAPE;
            for (Direction dir : Iterate.directions) {
                int index = dir.ordinal();
                if ((key & 1 << index) == 0) continue;
                cached = Shapes.joinUnoptimized((VoxelShape)cached, (VoxelShape)ENCASED_SIDE_SHAPES[index], (BooleanOp)BooleanOp.OR);
            }
            cached = cached.optimize();
            Map<Byte, VoxelShape> map = ENCASED_SHAPE_CACHE;
            synchronized (map) {
                ENCASED_SHAPE_CACHE.put(key, cached);
            }
        }
        return cached;
    }

    public EncasedFlexibleShaftBlock(BlockBehaviour.Properties properties, @Nullable DyeColor color, Supplier<Block> casing) {
        super(properties, color);
        this.casing = casing;
    }

    public EncasedFlexibleShaftBlock(BlockBehaviour.Properties properties, Supplier<Block> casing) {
        super(properties);
        this.casing = casing;
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BooleanProperty prop = SIDES[direction.ordinal()];
        boolean connects = this.connectsTo(level, pos, state, direction, neighborPos, level.getBlockState(neighborPos));
        if (connects && !((Boolean)state.getValue((Property)prop)).booleanValue()) {
            BlockEntity blockEntity;
            state = (BlockState)state.setValue((Property)prop, (Comparable)Boolean.valueOf(true));
            if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof FlexibleShaftBlockEntity) {
                FlexibleShaftBlockEntity fsb = (FlexibleShaftBlockEntity)blockEntity;
                fsb.setSide(direction, (byte)0);
            }
        }
        return state;
    }

    protected BlockEntry<FlexibleShaftBlock> getUnencased() {
        if (this.color == null) {
            return CALBlocks.FLEXIBLE_SHAFT;
        }
        return CALBlocks.DYED_FLEXIBLE_SHAFTS.get(this.color);
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level level = context.getLevel();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        level.levelEvent(2001, context.getClickedPos(), Block.getId((BlockState)state));
        KineticBlockEntity.switchToBlockState((Level)context.getLevel(), (BlockPos)context.getClickedPos(), (BlockState)this.getConnectedState(context.getLevel(), context.getClickedPos(), (BlockState)this.getUnencased().getDefaultState().setValue((Property)ACTIVE, (Comparable)((Boolean)state.getValue((Property)ACTIVE)))));
        return InteractionResult.SUCCESS;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        if (target instanceof BlockHitResult) {
            BlockHitResult result = (BlockHitResult)target;
            return (Boolean)state.getValue((Property)SIDES[result.getDirection().ordinal()]) == false ? this.getUnencased().asStack() : this.getCasing().asItem().getDefaultInstance();
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public Block getCasing() {
        return this.casing.get();
    }

    public ItemRequirement getRequiredItems(BlockState state, @Nullable BlockEntity blockEntity) {
        return ItemRequirement.of((BlockState)this.getUnencased().getDefaultState(), (BlockEntity)blockEntity);
    }

    public void handleEncasing(BlockState state, Level level, BlockPos pos, ItemStack heldItem, Player player, InteractionHand hand, BlockHitResult ray) {
        FlexibleShaftBlockEntity fsb;
        BlockState newState = (BlockState)this.defaultBlockState().setValue((Property)ACTIVE, (Comparable)((Boolean)state.getValue((Property)ACTIVE)));
        BlockEntity blockEntity = level.getBlockEntity(pos);
        FlexibleShaftBlockEntity be = blockEntity instanceof FlexibleShaftBlockEntity ? (fsb = (FlexibleShaftBlockEntity)blockEntity) : null;
        for (Direction dir : Iterate.directions) {
            newState = (BlockState)newState.setValue((Property)SIDES[dir.ordinal()], (Comparable)Boolean.valueOf(be == null || be.getSide(dir) == 0));
        }
        KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)newState);
    }
}

