/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.content.logistics.cashRegister;

import dev.khloeleclair.create.additionallogistics.client.api.currency.ICurrency;
import dev.khloeleclair.create.additionallogistics.common.CALLang;
import dev.khloeleclair.create.additionallogistics.common.content.logistics.cashRegister.CurrencyUtilities;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SimpleCurrency
implements ICurrency {
    private final ResourceLocation id;
    private final Map<Item, Integer> items;
    private final List<Item> items_by_value;

    public SimpleCurrency(ResourceLocation id) {
        this.id = id;
        this.items = new Object2IntArrayMap();
        this.items_by_value = new ArrayList<Item>();
    }

    public void addItem(Item item, int value) {
        Objects.requireNonNull(item);
        if (value <= 0) {
            throw new IllegalArgumentException("value must be greater than 0");
        }
        this.items.put(item, value);
        this.items_by_value.add(item);
        this.items_by_value.sort((a, b) -> -this.items.get(a).compareTo(this.items.get(b)));
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public Iterable<Item> getItems() {
        return this.items.keySet();
    }

    @Override
    public int getValue(ItemStack stack) {
        Item item = stack.getItem();
        int value = this.items.getOrDefault(item, 0);
        return value * stack.getCount();
    }

    @Override
    public int getValue(ItemStack stack, int count) {
        Item item = stack.getItem();
        int value = this.items.getOrDefault(item, 0);
        return value * count;
    }

    @Override
    public List<ItemStack> getStacksWithValue(int value) {
        int remaining = value;
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (Item item : this.items_by_value) {
            Integer item_value = this.items.get(item);
            if (item_value > remaining) continue;
            int item_amount = Math.floorDiv(remaining, (int)item_value);
            remaining -= item_amount * item_value;
            int max_stack = item.getDefaultMaxStackSize();
            while (item_amount > 0) {
                int count = Math.min(max_stack, item_amount);
                item_amount -= count;
                result.add(new ItemStack((ItemLike)item, count));
            }
        }
        return result;
    }

    @Override
    public ICurrency.ExtractionResult extractValue(ItemStack stack, int toExtract) {
        int value = this.getValue(stack);
        if (toExtract <= 0 || value <= 0 || stack.isEmpty()) {
            return new ICurrency.ExtractionResult(List.of(stack), toExtract);
        }
        if (toExtract >= value) {
            return new ICurrency.ExtractionResult(List.of(), toExtract - value);
        }
        int remaining = value - toExtract;
        int item_value = this.items.get(stack.getItem());
        int amount = remaining / item_value;
        int remainder = remaining % item_value;
        if (remainder == 0 && amount <= stack.getMaxStackSize()) {
            return new ICurrency.ExtractionResult(List.of(stack.copyWithCount(amount)), 0);
        }
        return new ICurrency.ExtractionResult(this.getStacksWithValue(value - toExtract), 0);
    }

    @Override
    public boolean hasFormatter() {
        return CurrencyUtilities.getFormatter(this.id) != null;
    }

    @Override
    public Component formatValue(int value) {
        Function<Integer, Component> formatter = CurrencyUtilities.getFormatter(this.id);
        if (formatter != null) {
            return formatter.apply(value);
        }
        return CALLang.number(value).component();
    }
}

