/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.content.logistics.packageAccelerator;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dev.khloeleclair.create.additionallogistics.common.Config;
import dev.khloeleclair.create.additionallogistics.common.ISetLazyTickCounter;
import dev.khloeleclair.create.additionallogistics.common.content.logistics.packageAccelerator.PackageAcceleratorBlock;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class PackageAcceleratorBlockEntity
extends KineticBlockEntity {
    public PackageAcceleratorBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = (float)Config.Common.acceleratorStressImpact.getAsDouble();
        return impact;
    }

    @Nullable
    public PackagerBlockEntity getPackager() {
        BlockEntity blockEntity;
        Optional facing = this.getBlockState().getOptionalValue((Property)PackageAcceleratorBlock.FACING);
        if (facing.isEmpty() || this.level == null) {
            return null;
        }
        BlockPos pos = this.worldPosition.relative((Direction)facing.get());
        if (this.level.isLoaded(pos) && (blockEntity = this.level.getBlockEntity(pos)) instanceof PackagerBlockEntity) {
            PackagerBlockEntity packager = (PackagerBlockEntity)blockEntity;
            return packager;
        }
        return null;
    }

    public void tick() {
        super.tick();
        float speed = Math.abs(this.getSpeed());
        if (speed < IRotate.SpeedLevel.MEDIUM.getSpeedValue()) {
            return;
        }
        PackagerBlockEntity packager = this.getPackager();
        if (packager == null) {
            return;
        }
        int ticks = 1;
        if (speed >= 256.0f) {
            ticks = 8;
        } else if (speed >= 128.0f) {
            ticks = 4;
        } else if (speed >= 64.0f) {
            ticks = 2;
        }
        ISetLazyTickCounter tc = (ISetLazyTickCounter)packager;
        tc.setLazyTickCounter(tc.getLazyTickCounter() - ticks);
        if (packager.animationTicks > 1) {
            packager.animationTicks = Math.max(1, packager.animationTicks - ticks);
        }
        if (packager.buttonCooldown > 0) {
            packager.buttonCooldown = Math.max(0, packager.buttonCooldown - 2 * ticks);
        }
    }
}

