/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.registries;

import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.foundation.utility.AdventureUtil;
import dev.khloeleclair.create.additionallogistics.CreateAdditionalLogistics;
import dev.khloeleclair.create.additionallogistics.client.content.kinetics.lazy.FlexibleShaftScreen;
import dev.khloeleclair.create.additionallogistics.client.content.logistics.cashRegister.SalesLedgerScreen;
import dev.khloeleclair.create.additionallogistics.common.IPromiseLimit;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.base.AbstractLazySimpleKineticBlock;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.flexible.FlexibleShaftBlock;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.flexible.FlexibleShaftBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.content.logistics.cashRegister.SalesHistoryData;
import dev.khloeleclair.create.additionallogistics.common.registries.CALDataComponents;
import dev.khloeleclair.create.additionallogistics.common.registries.CALItems;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class CALPackets {
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("3").executesOn(HandlerThread.MAIN);
        registrar.playToServer(UpdateGaugePromiseLimit.TYPE, UpdateGaugePromiseLimit.STREAM_CODEC, UpdateGaugePromiseLimit::handle);
        registrar.playToServer(ConfigureFlexibleShaft.TYPE, ConfigureFlexibleShaft.STREAM_CODEC, ConfigureFlexibleShaft::handle);
        registrar.playToServer(FinishedConfiguringFlexibleShaft.TYPE, FinishedConfiguringFlexibleShaft.STREAM_CODEC, FinishedConfiguringFlexibleShaft::handle);
        registrar.playToClient(OpenSalesLedgerScreen.TYPE, OpenSalesLedgerScreen.STREAM_CODEC, (message, access) -> OpenSalesLedgerScreen.handle(message));
        registrar.playToClient(OpenFlexibleShaftScreen.TYPE, OpenFlexibleShaftScreen.STREAM_CODEC, (message, access) -> OpenFlexibleShaftScreen.handle(message));
        registrar.playToClient(ServerToClientEvent.TYPE, ServerToClientEvent.STREAM_CODEC, (message, access) -> ServerToClientEvent.handle(message, access));
    }

    public record UpdateGaugePromiseLimit(FactoryPanelPosition pos, int limit, int additionalStock) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<UpdateGaugePromiseLimit> TYPE = new CustomPacketPayload.Type(CreateAdditionalLogistics.asResource("update_gauge_promise_limit"));
        public static final StreamCodec<ByteBuf, UpdateGaugePromiseLimit> STREAM_CODEC = StreamCodec.composite((StreamCodec)FactoryPanelPosition.STREAM_CODEC, UpdateGaugePromiseLimit::pos, (StreamCodec)ByteBufCodecs.INT, UpdateGaugePromiseLimit::limit, (StreamCodec)ByteBufCodecs.INT, UpdateGaugePromiseLimit::additionalStock, UpdateGaugePromiseLimit::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static void handle(UpdateGaugePromiseLimit message, IPayloadContext access) {
            Player player = access.player();
            if (player == null || player.isSpectator() || AdventureUtil.isAdventure((Player)player)) {
                return;
            }
            FactoryPanelPosition pos = message.pos;
            Level level = player.level();
            if (!level.isLoaded(pos.pos())) {
                return;
            }
            BlockEntity blockEntity = level.getBlockEntity(pos.pos());
            if (!(blockEntity instanceof FactoryPanelBlockEntity)) {
                return;
            }
            FactoryPanelBlockEntity be = (FactoryPanelBlockEntity)blockEntity;
            FactoryPanelBehaviour behavior = (FactoryPanelBehaviour)be.panels.get(pos.slot());
            if (!(behavior instanceof IPromiseLimit)) {
                return;
            }
            IPromiseLimit ipl = (IPromiseLimit)behavior;
            boolean changed = false;
            if (ipl.getCALPromiseLimit() != message.limit) {
                changed = true;
                ipl.setCALPromiseLimit(message.limit);
            }
            if (ipl.getCALAdditionalStock() != message.additionalStock) {
                changed = true;
                ipl.setCALAdditionalStock(message.additionalStock);
            }
            if (changed) {
                be.notifyUpdate();
            }
        }

        public void send() {
            PacketDistributor.sendToServer((CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public record ConfigureFlexibleShaft(BlockPos pos, Direction side, byte mode) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ConfigureFlexibleShaft> TYPE = new CustomPacketPayload.Type(CreateAdditionalLogistics.asResource("configure_flexible_shaft"));
        public static final StreamCodec<FriendlyByteBuf, ConfigureFlexibleShaft> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ConfigureFlexibleShaft::pos, (StreamCodec)Direction.STREAM_CODEC, ConfigureFlexibleShaft::side, (StreamCodec)ByteBufCodecs.BYTE, ConfigureFlexibleShaft::mode, ConfigureFlexibleShaft::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static void handle(ConfigureFlexibleShaft message, IPayloadContext access) {
            Player player = access.player();
            if (player == null || player.isSpectator() || AdventureUtil.isAdventure((Player)player)) {
                return;
            }
            BlockPos pos = message.pos;
            Level level = player.level();
            if (!level.isLoaded(pos)) {
                return;
            }
            BlockState state = level.getBlockState(pos);
            Block block = state.getBlock();
            if (!(block instanceof FlexibleShaftBlock)) {
                return;
            }
            FlexibleShaftBlock fsb = (FlexibleShaftBlock)block;
            fsb.setSide(level, pos, message.side, message.mode);
        }

        public static ConfigureFlexibleShaft of(BlockPos pos, Direction side, byte mode) {
            return new ConfigureFlexibleShaft(pos, side, mode);
        }

        public static ConfigureFlexibleShaft of(FlexibleShaftBlockEntity be, Direction side) {
            return new ConfigureFlexibleShaft(be.getBlockPos(), side, be.getSide(side));
        }

        public void send() {
            PacketDistributor.sendToServer((CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public record FinishedConfiguringFlexibleShaft(BlockPos pos) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<FinishedConfiguringFlexibleShaft> TYPE = new CustomPacketPayload.Type(CreateAdditionalLogistics.asResource("finished_configuring_flexible_shaft"));
        public static final StreamCodec<FriendlyByteBuf, FinishedConfiguringFlexibleShaft> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, FinishedConfiguringFlexibleShaft::pos, FinishedConfiguringFlexibleShaft::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static void handle(FinishedConfiguringFlexibleShaft message, IPayloadContext access) {
            BlockEntity blockEntity;
            Player player = access.player();
            if (player == null || player.isSpectator() || AdventureUtil.isAdventure((Player)player)) {
                return;
            }
            BlockPos pos = message.pos;
            Level level = player.level();
            if (!level.isLoaded(pos) || !((blockEntity = level.getBlockEntity(pos)) instanceof FlexibleShaftBlockEntity)) {
                return;
            }
            FlexibleShaftBlockEntity fsb = (FlexibleShaftBlockEntity)blockEntity;
            if (!fsb.shouldBeActive()) {
                fsb.deactivateSelf();
            }
        }

        public static FinishedConfiguringFlexibleShaft of(BlockPos pos) {
            return new FinishedConfiguringFlexibleShaft(pos);
        }

        public void send() {
            PacketDistributor.sendToServer((CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public record OpenSalesLedgerScreen(ItemStack stack, Map<UUID, String> playerNames) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<OpenSalesLedgerScreen> TYPE = new CustomPacketPayload.Type(CreateAdditionalLogistics.asResource("open_sales_ledger_screen"));
        public static final StreamCodec<RegistryFriendlyByteBuf, OpenSalesLedgerScreen> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, OpenSalesLedgerScreen::stack, (StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)UUIDUtil.STREAM_CODEC, (StreamCodec)ByteBufCodecs.STRING_UTF8), OpenSalesLedgerScreen::playerNames, OpenSalesLedgerScreen::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        @OnlyIn(value=Dist.CLIENT)
        public static void handle(OpenSalesLedgerScreen message) {
            Minecraft.getInstance().setScreen((Screen)new SalesLedgerScreen(message.stack, message.playerNames));
        }

        public static Optional<OpenSalesLedgerScreen> create(ItemStack stack) {
            GameProfileCache cache;
            if (stack.isEmpty() || !stack.is(CALItems.SALES_LEDGER)) {
                return Optional.empty();
            }
            SalesHistoryData history = (SalesHistoryData)stack.get(CALDataComponents.SALES_HISTORY);
            MinecraftServer server = CreateAdditionalLogistics.getServer();
            HashMap<UUID, String> playerNames = new HashMap<UUID, String>();
            if (history != null && server != null && (cache = server.getProfileCache()) != null) {
                for (UUID id : history.playerMap().values()) {
                    cache.get(id).ifPresent(profile -> {
                        String name = profile.getName();
                        if (name != null && !name.isEmpty()) {
                            playerNames.put(id, name);
                        }
                    });
                }
            }
            return Optional.of(new OpenSalesLedgerScreen(stack, playerNames));
        }

        public void send(ServerPlayer player) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public record OpenFlexibleShaftScreen(BlockPos pos) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<OpenFlexibleShaftScreen> TYPE = new CustomPacketPayload.Type(CreateAdditionalLogistics.asResource("open_flexible_shaft_screen"));
        public static final StreamCodec<FriendlyByteBuf, OpenFlexibleShaftScreen> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, OpenFlexibleShaftScreen::pos, OpenFlexibleShaftScreen::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        @OnlyIn(value=Dist.CLIENT)
        public static void handle(OpenFlexibleShaftScreen message) {
            Minecraft.getInstance().setScreen((Screen)new FlexibleShaftScreen(message.pos));
        }

        public static OpenFlexibleShaftScreen of(BlockPos pos) {
            return new OpenFlexibleShaftScreen(pos);
        }

        public void send(ServerPlayer player) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public record ServerToClientEvent(String key) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ServerToClientEvent> TYPE = new CustomPacketPayload.Type(CreateAdditionalLogistics.asResource("server_event"));
        public static final StreamCodec<FriendlyByteBuf, ServerToClientEvent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, ServerToClientEvent::key, ServerToClientEvent::new);
        public static final ServerToClientEvent CLEAR_INFORMATION = new ServerToClientEvent("clear_information");

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        @OnlyIn(value=Dist.CLIENT)
        public static void handle(ServerToClientEvent message, IPayloadContext context) {
            if (message.key.equals("clear_information")) {
                AbstractLazySimpleKineticBlock.clearInformationWalkCache();
            }
        }

        public void send(ServerLevel level) {
            PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }

        public void send(ServerLevel level, BlockPos pos) {
            PacketDistributor.sendToPlayersNear((ServerLevel)level, null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)160.0, (CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

