/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.peripheral.IPeripheral;
import dev.khloeleclair.create.additionallogistics.common.content.logistics.cashRegister.CashRegisterBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.content.logistics.cashRegister.SalesHistoryData;
import dev.khloeleclair.create.additionallogistics.common.content.logistics.packageEditor.PackageEditorBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.content.trains.networkMonitor.NetworkMonitorBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.registries.CALDataComponents;
import dev.khloeleclair.create.additionallogistics.common.registries.CALItems;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.AbstractEventfulComputerBehavior;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.luaObjects.LuaSaleObject;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.luaObjects.LuaSalesHistoryObject;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.peripherals.CashRegisterPeripheral;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.peripherals.NetworkMonitorPeripheral;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.peripherals.PackageEditorPeripheral;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.peripherals.SyncedPeripheral;
import java.util.function.Supplier;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class CALComputerBehavior
extends AbstractEventfulComputerBehavior {
    @Nullable
    IPeripheral peripheral;
    Supplier<IPeripheral> peripheralSupplier;

    public CALComputerBehavior(SmartBlockEntity sbe) {
        super(sbe);
        this.peripheralSupplier = CALComputerBehavior.getPeripheralFor(sbe);
    }

    public static Supplier<IPeripheral> getPeripheralFor(SmartBlockEntity sbe) {
        if (sbe instanceof CashRegisterBlockEntity) {
            CashRegisterBlockEntity cr = (CashRegisterBlockEntity)sbe;
            return () -> new CashRegisterPeripheral(cr);
        }
        if (sbe instanceof PackageEditorBlockEntity) {
            PackageEditorBlockEntity pe = (PackageEditorBlockEntity)sbe;
            return () -> new PackageEditorPeripheral(pe);
        }
        if (sbe instanceof NetworkMonitorBlockEntity) {
            NetworkMonitorBlockEntity nm = (NetworkMonitorBlockEntity)sbe;
            return () -> new NetworkMonitorPeripheral(nm);
        }
        throw new IllegalArgumentException("No peripheral available for " + String.valueOf(BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)sbe.getType())));
    }

    public static void registerItemDetailProviders() {
        VanillaDetailRegistries.ITEM_STACK.addProvider((out, stack) -> {
            if (stack.is(CALItems.SALES_LEDGER)) {
                LuaSalesHistoryObject obj = new LuaSalesHistoryObject((SalesHistoryData)stack.get(CALDataComponents.SALES_HISTORY));
                out.put("sales", obj);
            }
        });
    }

    public void updateArguments(Object ... arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            Object arg = arguments[i];
            if (arg instanceof ItemStack) {
                ItemStack is = (ItemStack)arg;
                arguments[i] = VanillaDetailRegistries.ITEM_STACK.getDetails((Object)is);
                continue;
            }
            if (arg instanceof SalesHistoryData) {
                SalesHistoryData history = (SalesHistoryData)arg;
                arguments[i] = new LuaSalesHistoryObject(history);
                continue;
            }
            if (!(arg instanceof Pair)) continue;
            Pair tuple = (Pair)arg;
            Object first = tuple.getFirst();
            Object second = tuple.getSecond();
            if (!(first instanceof SalesHistoryData)) continue;
            SalesHistoryData history = (SalesHistoryData)first;
            if (!(second instanceof SalesHistoryData.Sale)) continue;
            SalesHistoryData.Sale sale = (SalesHistoryData.Sale)second;
            arguments[i] = new LuaSaleObject(history, sale);
        }
    }

    @Override
    public void queueEvent(String event, Object ... arguments) {
        this.updateArguments(arguments);
        IPeripheral iPeripheral = this.peripheral;
        if (iPeripheral instanceof SyncedPeripheral) {
            SyncedPeripheral sp = (SyncedPeripheral)iPeripheral;
            sp.queueEvent(event, arguments);
        }
    }

    @Override
    public void queuePositionedEvent(String event, Object ... arguments) {
        this.updateArguments(arguments);
        IPeripheral iPeripheral = this.peripheral;
        if (iPeripheral instanceof SyncedPeripheral) {
            SyncedPeripheral sp = (SyncedPeripheral)iPeripheral;
            sp.queuePositionedEvent(event, arguments);
        }
    }

    public IPeripheral getPeripheralCapability() {
        if (this.peripheral == null) {
            this.peripheral = this.peripheralSupplier.get();
        }
        return this.peripheral;
    }

    public void removePeripheral() {
        if (this.peripheral != null) {
            this.getWorld().invalidateCapabilities(this.blockEntity.getBlockPos());
        }
    }
}

