/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.peripherals;

import com.simibubi.create.content.logistics.packagePort.postbox.PostboxBlockEntity;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.graph.TrackGraphLocation;
import com.simibubi.create.content.trains.station.GlobalStation;
import dan200.computercraft.api.lua.LuaFunction;
import dev.khloeleclair.create.additionallogistics.CreateAdditionalLogistics;
import dev.khloeleclair.create.additionallogistics.common.content.trains.networkMonitor.NetworkMonitorBlockEntity;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.peripherals.SyncedPeripheral;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class NetworkMonitorPeripheral
extends SyncedPeripheral<NetworkMonitorBlockEntity> {
    public NetworkMonitorPeripheral(NetworkMonitorBlockEntity blockEntity) {
        super(blockEntity);
    }

    private Map<String, Object> serializeStation(GlobalStation station, boolean include_trains) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", station.id.toString());
        result.put("name", station.name);
        if (include_trains) {
            result.put("train", this.serializeTrain(station.getPresentTrain()));
        }
        HashMap ports = new HashMap();
        int j = 0;
        MinecraftServer server = CreateAdditionalLogistics.getServer();
        ServerLevel level = server == null ? null : server.getLevel(station.blockEntityDimension);
        for (Map.Entry portEntry : station.connectedPorts.entrySet()) {
            BlockEntity blockEntity;
            ++j;
            GlobalStation.GlobalPackagePort port = (GlobalStation.GlobalPackagePort)portEntry.getValue();
            HashMap<String, Object> portData = new HashMap<String, Object>();
            portData.put("address", port.address);
            if (level != null && level.isLoaded((BlockPos)portEntry.getKey()) && (blockEntity = level.getBlockEntity((BlockPos)portEntry.getKey())) instanceof PostboxBlockEntity) {
                PostboxBlockEntity pbe = (PostboxBlockEntity)blockEntity;
                portData.put("send_only", !pbe.acceptsPackages);
            }
            ports.put(j, portData);
        }
        result.put("postboxes", ports);
        return result;
    }

    @Nullable
    private Map<String, Object> serializeTrain(@Nullable Train train) {
        if (train == null || train.invalid) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", train.id.toString());
        result.put("name", train.name.getString());
        return result;
    }

    @LuaFunction(mainThread=true)
    @Nullable
    public Map<String, ?> getStation(String key, Optional<Boolean> trains) {
        UUID id;
        TrackGraphLocation pos = ((NetworkMonitorBlockEntity)this.blockEntity).edgePoint.determineGraphLocation();
        try {
            id = UUID.fromString(key);
        }
        catch (IllegalArgumentException ex) {
            id = null;
        }
        GlobalStation station = id != null ? (GlobalStation)pos.graph.getPoint(EdgePointType.STATION, id) : (GlobalStation)pos.graph.getPoints(EdgePointType.STATION).stream().filter(x -> Objects.equals(x.name, key)).findFirst().orElse(null);
        if (station == null) {
            return null;
        }
        return this.serializeStation(station, trains.orElse(false));
    }

    @LuaFunction(mainThread=true)
    public Map<Integer, Map<String, ?>> listStations() {
        TrackGraphLocation pos = ((NetworkMonitorBlockEntity)this.blockEntity).edgePoint.determineGraphLocation();
        Collection stations = pos.graph.getPoints(EdgePointType.STATION);
        HashMap result = new HashMap();
        int i = 0;
        for (GlobalStation entry : stations) {
            result.put(++i, this.serializeStation(entry, false));
        }
        return result;
    }

    public String getType() {
        return "CreateAdditionalLogistics_NetworkMonitor";
    }
}

