/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.peripherals;

import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.compat.computercraft.AttachedComputerPacket;
import com.simibubi.create.compat.computercraft.implementation.ComputerBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.ref.WeakReference;
import java.util.Map;
import javax.annotation.Nullable;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public abstract class SyncedPeripheral<T extends SmartBlockEntity>
implements IPeripheral {
    protected final T blockEntity;
    private final Map<Integer, WeakReference<IComputerAccess>> computers = new Int2ObjectOpenHashMap();

    public SyncedPeripheral(T blockEntity) {
        this.blockEntity = blockEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(IComputerAccess computer) {
        Map<Integer, WeakReference<IComputerAccess>> map = this.computers;
        synchronized (map) {
            this.computers.put(computer.getID(), new WeakReference<IComputerAccess>(computer));
        }
        this.updateBlockEntity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(IComputerAccess computer) {
        Map<Integer, WeakReference<IComputerAccess>> map = this.computers;
        synchronized (map) {
            this.computers.remove(computer.getID());
        }
        this.updateBlockEntity();
    }

    public void queuePositionedEvent(String event, Object ... arguments) {
        this.pruneDeadComputers();
        for (WeakReference<IComputerAccess> ref : this.computers.values()) {
            IComputerAccess computer = (IComputerAccess)ref.get();
            if (computer == null) continue;
            Object[] args = new Object[arguments.length + 1];
            System.arraycopy(arguments, 0, args, 1, arguments.length);
            args[0] = computer.getAttachmentName();
            computer.queueEvent(event, args);
        }
    }

    public void queueEvent(String event, Object ... arguments) {
        this.pruneDeadComputers();
        for (WeakReference<IComputerAccess> ref : this.computers.values()) {
            IComputerAccess computer = (IComputerAccess)ref.get();
            if (computer == null) continue;
            computer.queueEvent(event, arguments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pruneDeadComputers() {
        Map<Integer, WeakReference<IComputerAccess>> map = this.computers;
        synchronized (map) {
            this.computers.values().removeIf(ref -> ref.get() == null);
        }
    }

    private void updateBlockEntity() {
        this.pruneDeadComputers();
        boolean hasAttachedComputer = !this.computers.isEmpty();
        ((AbstractComputerBehaviour)this.blockEntity.getBehaviour(ComputerBehaviour.TYPE)).setHasAttachedComputer(hasAttachedComputer);
        CatnipServices.NETWORK.sendToAllClients((CustomPacketPayload)new AttachedComputerPacket(this.blockEntity.getBlockPos(), hasAttachedComputer));
    }

    public boolean equals(@Nullable IPeripheral other) {
        return this == other;
    }
}

