/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.khloeleclair.create.additionallogistics.common.Config;
import dev.khloeleclair.create.additionallogistics.common.IPromiseLimit;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FactoryPanelBehaviour.class})
public abstract class MixinFactoryPanelBehaviour
extends FilteringBehaviour
implements IPromiseLimit {
    private static final String CAL_PROMISE_LIMIT_KEY = "CAL$PromiseLimit";
    private static final String CAL_ADDITIONAL_STOCK_KEY = "CAL$Stock$Add";
    private static final String CAL_LAST_INVENTORY_KEY = "CAL$LastInv";
    private static final String CAL_REMAINING_ADDITIONAL_KEY = "CAL$Rem$Add";
    @Shadow
    public boolean satisfied;
    @Unique
    private int CAL$promiseLimit = -1;
    @Unique
    private int CAL$AdditionalStock = 0;
    @Unique
    private int CAL$LastInventory = -1;
    @Unique
    private int CAL$RemainingAdditional = 0;

    @Shadow
    public abstract int getLevelInStorage();

    @Shadow
    public abstract int getPromised();

    public MixinFactoryPanelBehaviour(SmartBlockEntity be, ValueBoxTransform slot) {
        super(be, slot);
    }

    @Override
    public boolean hasCALPromiseLimit() {
        return this.CAL$promiseLimit >= 0 && (Boolean)Config.Common.enablePromiseLimits.get() != false;
    }

    @Override
    public int getCALPromiseLimit() {
        return this.CAL$promiseLimit;
    }

    @Override
    public void setCALPromiseLimit(int value) {
        if (value < 0) {
            value = -1;
        }
        this.CAL$promiseLimit = value;
    }

    @Override
    public int getCALAdditionalStock() {
        return this.CAL$AdditionalStock;
    }

    @Override
    public boolean hasCALAdditionalStock() {
        return this.CAL$AdditionalStock > 0;
    }

    @Override
    public void setCALAdditionalStock(int value) {
        if (value < 0) {
            value = 0;
        }
        if (value == this.CAL$AdditionalStock) {
            return;
        }
        this.CAL$AdditionalStock = value;
        if (this.CAL$RemainingAdditional > value) {
            this.CAL$RemainingAdditional = value;
        }
    }

    @Unique
    private FactoryPanelBehaviour FPB() {
        return (FactoryPanelBehaviour)this;
    }

    @Unique
    private void CAL$writeData(CompoundTag nbt) {
        FactoryPanelBehaviour fpb = this.FPB();
        if (!fpb.active) {
            return;
        }
        String tagName = CreateLang.asId((String)fpb.slot.name());
        CompoundTag tag = nbt.getCompound(tagName);
        tag.putInt(CAL_PROMISE_LIMIT_KEY, this.CAL$promiseLimit);
        if (fpb.panelBE().restocker) {
            tag.putInt(CAL_ADDITIONAL_STOCK_KEY, this.CAL$AdditionalStock);
            tag.putInt(CAL_LAST_INVENTORY_KEY, this.CAL$LastInventory);
            tag.putInt(CAL_REMAINING_ADDITIONAL_KEY, this.CAL$RemainingAdditional);
        }
        nbt.put(tagName, (Tag)tag);
    }

    @ModifyVariable(method={"tickStorageMonitor"}, at=@At(value="STORE"), name={"inStorage"})
    private int CAL$tickStorageMonitor$inStorage(int value) {
        if (this.CAL$RemainingAdditional > 0 && this.CAL$LastInventory > value) {
            int difference = this.CAL$LastInventory - value;
            this.CAL$RemainingAdditional -= difference;
            if (this.CAL$RemainingAdditional < 0) {
                this.CAL$RemainingAdditional = 0;
            }
        }
        this.CAL$LastInventory = value;
        return value;
    }

    @Inject(method={"tickStorageMonitor"}, at={@At(value="RETURN")})
    private void CAL$onTickStorageMonitor(CallbackInfo ci) {
        if (!this.satisfied && this.CAL$RemainingAdditional <= 0 && this.FPB().panelBE().restocker) {
            this.CAL$RemainingAdditional = this.CAL$AdditionalStock;
        } else if (this.satisfied) {
            this.CAL$RemainingAdditional = 0;
        }
    }

    @ModifyVariable(method={"tickStorageMonitor"}, at=@At(value="LOAD"), name={"demand"})
    private int CAL$tickStorageMonitor$getDemand(int original) {
        if (this.CAL$RemainingAdditional > 0) {
            return original + this.CAL$RemainingAdditional;
        }
        return original;
    }

    @ModifyVariable(method={"tryRestock"}, at=@At(value="LOAD"), name={"demand"})
    private int CAL$tryRestock$getDemand(int original) {
        if (this.CAL$RemainingAdditional > 0) {
            return original + this.CAL$RemainingAdditional;
        }
        return original;
    }

    @Inject(method={"tryRestock"}, at={@At(value="INVOKE_ASSIGN", target="Lorg/joml/Math;clamp(III)I")}, cancellable=true)
    private void CAL$onTryRestock(CallbackInfo ci, @Local(ordinal=1) int inStorage, @Local(ordinal=2) int promised, @Local(ordinal=4) int demand, @Local(ordinal=5) LocalIntRef amountToOrder) {
        if (!this.hasCALPromiseLimit()) {
            return;
        }
        int limit = this.getCALPromiseLimit();
        int amount = amountToOrder.get();
        if (promised + amount > limit) {
            amount = limit - promised;
        }
        if (amount <= 0) {
            ci.cancel();
            return;
        }
        amountToOrder.set(amount);
    }

    @Inject(method={"tickRequests"}, at={@At(value="INVOKE", target="resetTimer", shift=At.Shift.AFTER)}, cancellable=true)
    private void CAL$inTickRequests(CallbackInfo ci) {
        if (!this.hasCALPromiseLimit()) {
            return;
        }
        FactoryPanelBehaviour fpb = this.FPB();
        int limit = this.getCALPromiseLimit();
        if (!fpb.panelBE().restocker) {
            limit *= fpb.recipeOutput;
        }
        if (limit <= 0 || fpb.getPromised() >= limit) {
            ci.cancel();
        }
    }

    @Inject(method={"writeSafe"}, at={@At(value="RETURN")})
    private void CAL$onWriteSafe(CompoundTag nbt, HolderLookup.Provider registries, CallbackInfo ci) {
        this.CAL$writeData(nbt);
    }

    @Inject(method={"write"}, at={@At(value="RETURN")})
    private void CAL$onWrite(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket, CallbackInfo ci) {
        this.CAL$writeData(nbt);
    }

    @Inject(method={"read"}, at={@At(value="RETURN")})
    private void CAL$onRead(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket, CallbackInfo ci) {
        FactoryPanelBehaviour fpb = this.FPB();
        if (!fpb.active) {
            return;
        }
        CompoundTag tag = nbt.getCompound(CreateLang.asId((String)fpb.slot.name()));
        if (tag.contains(CAL_PROMISE_LIMIT_KEY, 3)) {
            this.setCALPromiseLimit(tag.getInt(CAL_PROMISE_LIMIT_KEY));
        } else {
            this.setCALPromiseLimit(-1);
        }
        this.CAL$AdditionalStock = Mth.clamp((int)tag.getInt(CAL_ADDITIONAL_STOCK_KEY), (int)0, (int)128000);
        this.CAL$LastInventory = tag.getInt(CAL_LAST_INVENTORY_KEY);
        this.CAL$RemainingAdditional = tag.getInt(CAL_REMAINING_ADDITIONAL_KEY);
    }
}

