/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.network;

import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.foundation.utility.AdventureUtil;
import dev.khloeleclair.create.additionallogistics.CreateAdditionalLogistics;
import dev.khloeleclair.create.additionallogistics.client.screen.SalesLedgerScreen;
import dev.khloeleclair.create.additionallogistics.common.IPromiseLimit;
import dev.khloeleclair.create.additionallogistics.common.data.CustomComponents;
import dev.khloeleclair.create.additionallogistics.common.data.SalesHistoryData;
import dev.khloeleclair.create.additionallogistics.common.registries.CALItems;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class CustomPackets {
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1").executesOn(HandlerThread.MAIN);
        registrar.playToServer(UpdateGaugePromiseLimit.TYPE, UpdateGaugePromiseLimit.STREAM_CODEC, UpdateGaugePromiseLimit::handle);
        registrar.playToClient(OpenSalesLedgerScreen.TYPE, OpenSalesLedgerScreen.STREAM_CODEC, (message, access) -> OpenSalesLedgerScreen.handle(message));
    }

    public record UpdateGaugePromiseLimit(FactoryPanelPosition pos, int limit) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<UpdateGaugePromiseLimit> TYPE = new CustomPacketPayload.Type(CreateAdditionalLogistics.asResource("update_gauge_promise_limit"));
        public static final StreamCodec<ByteBuf, UpdateGaugePromiseLimit> STREAM_CODEC = StreamCodec.composite((StreamCodec)FactoryPanelPosition.STREAM_CODEC, UpdateGaugePromiseLimit::pos, (StreamCodec)ByteBufCodecs.INT, UpdateGaugePromiseLimit::limit, UpdateGaugePromiseLimit::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static void handle(UpdateGaugePromiseLimit message, IPayloadContext access) {
            Player player = access.player();
            if (player == null || player.isSpectator() || AdventureUtil.isAdventure((Player)player)) {
                return;
            }
            FactoryPanelPosition pos = message.pos;
            Level level = player.level();
            if (!level.isLoaded(pos.pos())) {
                return;
            }
            BlockEntity blockEntity = level.getBlockEntity(pos.pos());
            if (!(blockEntity instanceof FactoryPanelBlockEntity)) {
                return;
            }
            FactoryPanelBlockEntity be = (FactoryPanelBlockEntity)blockEntity;
            FactoryPanelBehaviour behavior = (FactoryPanelBehaviour)be.panels.get(pos.slot());
            if (!(behavior instanceof IPromiseLimit)) {
                return;
            }
            IPromiseLimit ipl = (IPromiseLimit)behavior;
            if (ipl.getPromiseLimit() == message.limit) {
                return;
            }
            ipl.setPromiseLimit(message.limit);
            be.notifyUpdate();
        }

        public void send() {
            PacketDistributor.sendToServer((CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public record OpenSalesLedgerScreen(ItemStack stack, Map<UUID, String> playerNames) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<OpenSalesLedgerScreen> TYPE = new CustomPacketPayload.Type(CreateAdditionalLogistics.asResource("open_sales_ledger_screen"));
        public static final StreamCodec<RegistryFriendlyByteBuf, OpenSalesLedgerScreen> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, OpenSalesLedgerScreen::stack, (StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)UUIDUtil.STREAM_CODEC, (StreamCodec)ByteBufCodecs.STRING_UTF8), OpenSalesLedgerScreen::playerNames, OpenSalesLedgerScreen::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        @OnlyIn(value=Dist.CLIENT)
        public static void handle(OpenSalesLedgerScreen message) {
            Minecraft.getInstance().setScreen((Screen)new SalesLedgerScreen(message.stack, message.playerNames));
        }

        public static Optional<OpenSalesLedgerScreen> create(ItemStack stack) {
            GameProfileCache cache;
            if (stack.isEmpty() || !stack.is(CALItems.SALES_LEDGER)) {
                return Optional.empty();
            }
            SalesHistoryData history = (SalesHistoryData)stack.get(CustomComponents.SALES_HISTORY);
            MinecraftServer server = CreateAdditionalLogistics.getServer();
            HashMap<UUID, String> playerNames = new HashMap<UUID, String>();
            if (history != null && server != null && (cache = server.getProfileCache()) != null) {
                for (UUID id : history.playerMap().values()) {
                    cache.get(id).ifPresent(profile -> {
                        String name = profile.getName();
                        if (name != null && !name.isEmpty()) {
                            playerNames.put(id, name);
                        }
                    });
                }
            }
            return Optional.of(new OpenSalesLedgerScreen(stack, playerNames));
        }

        public void send(ServerPlayer player) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

