/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.flexible;

import com.simibubi.create.api.contraption.transformable.TransformableBlockEntity;
import com.simibubi.create.api.schematic.nbt.PartialSafeNBT;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.decoration.encasing.EncasedBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotationIndicatorParticleData;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.base.AbstractLowEntityKineticBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.flexible.AbstractFlexibleShaftBlock;
import java.util.Arrays;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FlexibleShaftBlockEntity
extends AbstractLowEntityKineticBlockEntity
implements PartialSafeNBT,
TransformableBlockEntity {
    protected final byte[] sideActive = new byte[Iterate.directions.length];
    protected boolean validateSides;
    @Nullable
    protected Direction particleSide;
    protected int particleCountdown;

    public FlexibleShaftBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        Arrays.fill(this.sideActive, (byte)0);
    }

    @Override
    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        Arrays.fill(this.sideActive, (byte)0);
        if (compound.contains("Sides", 7)) {
            byte[] array = compound.getByteArray("Sides");
            System.arraycopy(array, 0, this.sideActive, 0, Math.min(array.length, this.sideActive.length));
        }
    }

    public void writeSafe(CompoundTag tag, HolderLookup.Provider registries) {
        super.writeSafe(tag, registries);
        tag.putByteArray("Sides", Arrays.copyOf(this.sideActive, this.sideActive.length));
    }

    @Override
    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putByteArray("Sides", Arrays.copyOf(this.sideActive, this.sideActive.length));
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level.isClientSide) {
            if (this.validateSides) {
                this.validateSides = false;
                this.checkSides();
            }
            if (this.particleCountdown > 0) {
                --this.particleCountdown;
                if (this.particleCountdown == 0) {
                    this.spawnSideParticles();
                }
            }
        }
    }

    protected void queueSideParticles(Direction side) {
        this.particleSide = side;
        this.particleCountdown = 2;
    }

    protected void spawnSideParticles() {
        Direction side = this.particleSide;
        if (side == null) {
            return;
        }
        this.particleSide = null;
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        float speed = this.getSpeed() * this.getRotationSpeedModifier(side);
        if (speed == 0.0f) {
            return;
        }
        float step = (float)side.getAxisDirection().getStep() * 0.5f;
        Direction.Axis axis = side.getAxis();
        Vec3 position = this.worldPosition.getCenter().add(axis == Direction.Axis.X ? (double)step : 0.0, axis == Direction.Axis.Y ? (double)step : 0.0, axis == Direction.Axis.Z ? (double)step : 0.0);
        IRotate.SpeedLevel speedLevel = IRotate.SpeedLevel.of((float)speed);
        int color = speedLevel.getColor();
        int particleSpeed = speedLevel.getParticleSpeed();
        particleSpeed = (int)((float)particleSpeed * Math.signum(speed));
        RotationIndicatorParticleData particleData = new RotationIndicatorParticleData(color, (float)particleSpeed, 0.75f, 0.65f, 5, side.getAxis());
        sl.sendParticles((ParticleOptions)particleData, position.x, position.y, position.z, 20, 0.0, 0.0, 0.0, 1.0);
    }

    protected boolean isNoisy() {
        return false;
    }

    @Override
    public boolean isValidBlockState(BlockState state) {
        this.validateSides = true;
        return super.isValidBlockState(state);
    }

    public boolean shouldBeActive() {
        for (byte side : this.sideActive) {
            if (side == 0) continue;
            return true;
        }
        return false;
    }

    protected void checkSides() {
        boolean changed = false;
        boolean detached = false;
        BlockState state = this.getBlockState();
        for (Direction side : Iterate.directions) {
            int index = side.ordinal();
            if (!((Boolean)state.getValue((Property)AbstractFlexibleShaftBlock.SIDES[index])).booleanValue() || this.sideActive[index] == 0) continue;
            if (this.hasConnection(side) && !detached) {
                detached = true;
                this.detachKinetics();
            }
            this.sideActive[index] = 0;
            changed = true;
        }
        if (!this.shouldBeActive()) {
            this.deactivateSelf();
        } else if (changed) {
            this.notifyUpdate();
            this.updateSpeed = true;
        }
    }

    public void deactivateSelf() {
        this.notifyConnectedToValidate();
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)AbstractFlexibleShaftBlock.ACTIVE, (Comparable)Boolean.valueOf(false)));
        AbstractLowEntityKineticBlockEntity.markDirty(this.level, this.worldPosition);
    }

    public boolean hasConnection(Direction side) {
        if (this.level == null || this.sideActive[side.ordinal()] == 0 || !this.hasNetwork()) {
            return false;
        }
        BlockPos pos = this.worldPosition.relative(side);
        BlockState state = this.level.getBlockState(pos);
        Block block = state.getBlock();
        if (!(block instanceof IRotate)) {
            return false;
        }
        IRotate rot = (IRotate)block;
        return rot.hasShaftTowards((LevelReader)this.level, pos, state, side.getOpposite());
    }

    public void toggleSide(Direction side) {
        byte value = this.sideActive[side.ordinal()];
        value = value == 0 ? (byte)1 : (value == 1 ? (byte)-1 : 0);
        this.setSide(side, value);
    }

    public void setSideUnsafe(Direction side, byte value) {
        this.sideActive[side.ordinal()] = value;
    }

    public boolean setSide(Direction side, byte value) {
        int index = side.ordinal();
        byte old_value = this.sideActive[index];
        if (old_value == value) {
            return false;
        }
        if (old_value != 0 && this.hasConnection(side)) {
            if (this.hasNetwork()) {
                this.getOrCreateNetwork().remove((KineticBlockEntity)this);
            }
            this.detachKinetics();
            this.removeSource();
        }
        this.sideActive[index] = value;
        this.queueSideParticles(side);
        BlockState state = this.getBlockState();
        if (state.getBlock() instanceof EncasedBlock) {
            boolean side_state;
            boolean bl = side_state = value == 0;
            if ((Boolean)state.getValue((Property)AbstractFlexibleShaftBlock.SIDES[index]) != side_state) {
                this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)AbstractFlexibleShaftBlock.SIDES[index], (Comparable)Boolean.valueOf(side_state)));
            }
        }
        this.updateSpeed = true;
        this.notifyUpdate();
        return true;
    }

    public byte getSide(Direction side) {
        return this.sideActive[side.ordinal()];
    }

    public float getRotationSpeedModifier(Direction face) {
        return 1.0f * (float)this.sideActive[face.ordinal()];
    }

    @Override
    public boolean isCustomConnection(KineticBlockEntity other, BlockState state, BlockState otherState) {
        IRotate rot;
        Block block;
        BlockPos relative = other.getBlockPos().subtract((Vec3i)this.worldPosition);
        Direction dir = Direction.fromDelta((int)relative.getX(), (int)relative.getY(), (int)relative.getZ());
        if (dir != null && this.sideActive[dir.ordinal()] != 0 && (block = otherState.getBlock()) instanceof IRotate && (rot = (IRotate)block).hasShaftTowards((LevelReader)this.level, other.getBlockPos(), otherState, dir.getOpposite())) {
            return false;
        }
        return super.isCustomConnection(other, state, otherState);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.notifyConnectedToValidate();
    }

    public void transform(BlockEntity blockEntity, StructureTransform transform) {
        byte[] newSides;
        byte[] sides = this.sideActive;
        if (transform.mirror != Mirror.NONE) {
            newSides = new byte[sides.length];
            for (Direction dir : Iterate.directions) {
                newSides[transform.mirror.mirror((Direction)dir).ordinal()] = sides[dir.ordinal()];
            }
            sides = newSides;
        }
        if (transform.rotation != Rotation.NONE) {
            newSides = new byte[sides.length];
            for (Direction dir : Iterate.directions) {
                newSides[transform.rotation.rotate((Direction)dir).ordinal()] = sides[dir.ordinal()];
            }
            sides = newSides;
        }
        System.arraycopy(sides, 0, this.sideActive, 0, sides.length);
    }
}

