/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.content.kinetics.verticalBelt;

import dev.khloeleclair.create.additionallogistics.common.content.kinetics.verticalBelt.AbstractVerticalBeltBlock;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.verticalBelt.VerticalBeltBlockEntity;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VerticalBeltHelper {
    public static BlockPos getPositionForOffset(VerticalBeltBlockEntity belt, int offset) {
        return belt.getController().above(offset);
    }

    public static class PositionIterator
    implements Iterator<BlockPos> {
        private final LevelReader world;
        private BlockPos currentPos;
        private boolean hasNext;
        @Nullable
        private BlockPos nextPos;

        public PositionIterator(LevelReader world, BlockPos startingPos) {
            this.world = world;
            this.currentPos = startingPos;
        }

        @Nullable
        private BlockPos readNext() {
            if (!this.hasNext) {
                BlockPos next = this.currentPos.above();
                this.nextPos = this.world.getBlockState(next).getBlock() instanceof AbstractVerticalBeltBlock ? next : null;
                this.hasNext = true;
            }
            return this.nextPos;
        }

        @Override
        public boolean hasNext() {
            return this.readNext() != null;
        }

        @Override
        public BlockPos next() {
            BlockPos next = this.readNext();
            if (next == null) {
                throw new NoSuchElementException();
            }
            this.currentPos = next;
            this.hasNext = false;
            return this.currentPos;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Positions
    implements Collection<BlockPos>,
    List<BlockPos> {
        private final LevelReader world;
        private final BlockPos origin;
        private int height = -1;

        public Positions(LevelReader world, BlockPos origin) {
            this.world = world;
            this.origin = origin;
        }

        private void load() {
            if (this.height >= 0) {
                return;
            }
            BlockPos currentPos = this.origin;
            while (this.height < 1000 && this.world.getBlockState(currentPos).getBlock() instanceof AbstractVerticalBeltBlock) {
                currentPos = currentPos.above();
                ++this.height;
            }
        }

        @Override
        public boolean addAll(int index, @NotNull Collection<? extends BlockPos> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BlockPos get(int index) {
            this.load();
            if (index < 0 || index >= this.height) {
                throw new IndexOutOfBoundsException();
            }
            if (index == 0) {
                return this.origin;
            }
            return this.origin.above(index);
        }

        @Override
        public BlockPos set(int index, BlockPos element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, BlockPos element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BlockPos remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            if (!(o instanceof BlockPos)) {
                return -1;
            }
            BlockPos opos = (BlockPos)o;
            if (opos.getX() != this.origin.getX() || opos.getZ() != this.origin.getZ()) {
                return -1;
            }
            this.load();
            int offset = opos.getY() - this.origin.getY();
            if (offset < 0 || offset >= this.height) {
                return -1;
            }
            return offset;
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.indexOf(o);
        }

        @Override
        @NotNull
        public ListIterator<BlockPos> listIterator() {
            return null;
        }

        @Override
        @NotNull
        public ListIterator<BlockPos> listIterator(int index) {
            return null;
        }

        @Override
        @NotNull
        public List<BlockPos> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            this.load();
            return this.height;
        }

        @Override
        public boolean isEmpty() {
            this.load();
            return this.height == 0;
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) != -1;
        }

        @Override
        @NotNull
        public Iterator<BlockPos> iterator() {
            return null;
        }

        @Override
        @NotNull
        public Object[] toArray() {
            this.load();
            Object[] result = new Object[this.height];
            for (int i = 0; i < this.height; ++i) {
                result[i] = i == 0 ? this.origin : this.origin.above(i);
            }
            return result;
        }

        @Override
        @NotNull
        public <T> T[] toArray(@NotNull T[] a) {
            this.load();
            if (a.length < this.height) {
                return Arrays.copyOf(this.toArray(), this.height, a.getClass());
            }
            for (int i = 0; i < this.height; ++i) {
                a[i] = i == 0 ? this.origin : this.origin.above(i);
            }
            if (a.length > this.height) {
                a[this.height] = null;
            }
            return a;
        }

        @Override
        public boolean add(BlockPos pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(@NotNull Collection<?> c) {
            for (Object entry : c) {
                if (this.indexOf(entry) != -1) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends BlockPos> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@NotNull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@NotNull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

