/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.luaObjects;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dev.khloeleclair.create.additionallogistics.common.content.logistics.cashRegister.SalesHistoryData;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.luaObjects.LuaComparable;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.luaObjects.LuaSaleObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class LuaSalesHistoryObject
implements LuaComparable {
    private final SalesHistoryData Data;

    public LuaSalesHistoryObject(@Nullable SalesHistoryData data) {
        this.Data = data == null ? SalesHistoryData.EMPTY : data;
    }

    @LuaFunction(mainThread=true)
    public int size() {
        return this.Data.saleCount();
    }

    @LuaFunction(mainThread=true)
    public final long getStartTime() {
        SalesHistoryData.Sale first = this.Data.firstSale();
        if (first == null) {
            return -1L;
        }
        return first.timestamp();
    }

    @LuaFunction(mainThread=true)
    public final long getEndTime() {
        SalesHistoryData.Sale last = this.Data.lastSale();
        if (last == null) {
            return -1L;
        }
        return last.timestamp();
    }

    @LuaFunction(mainThread=true)
    public final LuaSaleObject getSale(int slot) throws LuaException {
        List<SalesHistoryData.Sale> list = this.Data.getSales();
        int idx = slot - 1;
        if (idx < 0 || idx > list.size()) {
            throw new LuaException("Sale '" + slot + "' does not exist.");
        }
        return new LuaSaleObject(this.Data, list.get(idx));
    }

    @LuaFunction(mainThread=true)
    public final Map<Integer, LuaSaleObject> list() {
        HashMap<Integer, LuaSaleObject> result = new HashMap<Integer, LuaSaleObject>();
        List<SalesHistoryData.Sale> list = this.Data.getSales();
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            result.put(i + 1, new LuaSaleObject(this.Data, list.get(i)));
        }
        return result;
    }

    @Override
    public Map<?, ?> getTableRepresentation() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("size", this.size());
        map.put("sales", this.list());
        map.put("start", this.getStartTime());
        map.put("end", this.getEndTime());
        return map;
    }
}

