/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common;

import dev.khloeleclair.create.additionallogistics.common.CALLang;
import net.createmod.catnip.config.ui.BaseConfigScreen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    static final ForgeConfigSpec commonSpec;
    public static final _Common Common;
    static final ForgeConfigSpec clientSpec;
    public static final _Client Client;
    static final ForgeConfigSpec serverSpec;
    public static final _Server Server;

    private static String t(String path) {
        return CALLang.key("config." + path);
    }

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)serverSpec);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerClient() {
        BaseConfigScreen.setDefaultActionFor((String)"createadditionallogistics", screen -> screen.withSpecs(clientSpec, commonSpec, serverSpec));
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(_Common::new);
        commonSpec = (ForgeConfigSpec)pair.getRight();
        Common = (_Common)pair.getLeft();
        pair = new ForgeConfigSpec.Builder().configure(_Client::new);
        clientSpec = (ForgeConfigSpec)pair.getRight();
        Client = (_Client)pair.getLeft();
        pair = new ForgeConfigSpec.Builder().configure(_Server::new);
        serverSpec = (ForgeConfigSpec)pair.getRight();
        Server = (_Server)pair.getLeft();
    }

    public static class _Common {
        public final ForgeConfigSpec.BooleanValue enablePromiseLimits;
        public final ForgeConfigSpec.BooleanValue enableAdditionalStock;
        public final ForgeConfigSpec.BooleanValue protectStockKeeperSeats;
        public final ForgeConfigSpec.BooleanValue globAllowRegex;
        public final ForgeConfigSpec.BooleanValue globOptimize;
        public final ForgeConfigSpec.IntValue maxStarHeight;
        public final ForgeConfigSpec.IntValue maxRepetitions;
        public final ForgeConfigSpec.BooleanValue allowBackrefs;
        public final ForgeConfigSpec.DoubleValue acceleratorStressImpact;

        _Common(ForgeConfigSpec.Builder builder) {
            this.enablePromiseLimits = builder.comment("Adds a new configurable value to factory gauges that allows configuring how many promises each gauge can have at a time.").translation(Config.t("enable-promise-limits")).define("enablePromiseLimits", true);
            this.enableAdditionalStock = builder.comment("Adds a new configurable value to Restocker factory gauges that allows configuring the gauge to request additional items when restocking.").translation(Config.t("enable-additional-stock")).define("enableAdditionalStock", true);
            this.protectStockKeeperSeats = builder.comment("Prevent players from accidentally sitting in Seats holding a Stock Keeper.").translation(Config.t("protect-seats")).define("protectStockKeeperSeats", true);
            builder.comment("Package Addresses").push("addresses");
            this.globOptimize = builder.comment("Use optimized logic and caching for package address matching.").translation(Config.t("addresses.optimize")).define("globOptimize", true);
            this.globAllowRegex = builder.comment("Allow the user of regular expressions timestamp matching packages in Create (Frogports, Postboxes, Package Filters, etc.) with the \"RegEx:\" prefix.").translation(Config.t("addresses.allowRegex")).define("globAllowRegex", true);
            builder.comment("Regex Safety").push("regexSafety");
            this.maxStarHeight = builder.comment("Maximum star height to allow in one regular expression. This is intended to prevent catastrophic backtracking.").translation(Config.t("regex.starHeight")).defineInRange("maxStarHeight", 1, 0, 6);
            this.maxRepetitions = builder.comment("Maximum repetitions to allow in one regular expression. This is intended to minimize overall work.").translation(Config.t("regex.maxRepetitions")).defineInRange("maxRepetitions", 1000, 0, Integer.MAX_VALUE);
            this.allowBackrefs = builder.comment("Whether or not to allow backreferences in regular expressions.").translation(Config.t("regex.allowBackrefs")).define("allowBackrefs", false);
            builder.pop();
            builder.pop();
            builder.comment("Kinetics").push("kinetics");
            builder.comment("Package Accelerator").push("packageAccelerator");
            this.acceleratorStressImpact = builder.comment("The stress impact of the Package Accelerator").translation(Config.t("kinetics.stress-impact")).defineInRange("acceleratorStressImpact", 4.0, 1.0, 100.0);
            builder.pop();
            builder.pop();
        }
    }

    public static class _Client {
        _Client(ForgeConfigSpec.Builder builder) {
        }
    }

    public static class _Server {
        public final ForgeConfigSpec.BooleanValue currencyCompression;
        public final ForgeConfigSpec.BooleanValue currencyStockTicker;
        public final ForgeConfigSpec.BooleanValue trainInventoryAccess;
        public final ForgeConfigSpec.BooleanValue trainWriting;
        public final ForgeConfigSpec.BooleanValue trainArrivalEvents;

        _Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Currency Conversion").push("currencyConversion");
            this.currencyCompression = builder.comment("When enabled, items that are freely converted to and from other items (for example, 9 Diamonds equal 1 Diamond Block) will be converted automatically to make shopping easier. Otherwise, only specifically defined currencies will work.").translation(Config.t("currency-conversion.compression")).define("compression", true);
            this.currencyStockTicker = builder.comment("Allow Stock Tickers to perform Currency Conversion as well.").translation(Config.t("currency-conversion.stock-tickers")).define("allowStockTickers", false);
            builder.pop();
            builder.comment("Train Network Monitor").push("trainNetworkMonitor");
            this.trainInventoryAccess = builder.comment("When enabled, a train's inventory and fluid contents can be read using a Train Network Monitor Peripheral. When disabled, only information about packages is available.").translation(Config.t("trains.network-monitor.allow-inventory")).define("allowInventoryAccess", false);
            this.trainWriting = builder.comment("When enabled, trains and stations can be modified using a Train Network Monitor Peripheral. When disabled, data can only be read.").translation(Config.t("trains.network-monitor.allow-writing")).define("allowWriting", false);
            this.trainArrivalEvents = builder.comment("When enabled, Train Network Monitors will emit events whenever a train arrives or departs a station on the monitored train network.").translation(Config.t("trains.network-monitor.arrival-events")).define("arrivalEvents", true);
            builder.pop();
        }
    }

    public static enum CurrencyMode {
        DISABLED,
        ENABLED,
        AUTO;

    }
}

