/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common;

import dev.khloeleclair.create.additionallogistics.CreateAdditionalLogistics;
import dev.khloeleclair.create.additionallogistics.common.Config;
import dev.khloeleclair.create.additionallogistics.common.SafeRegex;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.createmod.catnip.data.Glob;
import net.createmod.catnip.data.Pair;
import org.jetbrains.annotations.Nullable;

public record PatternReplacement(String rawPattern, Pattern pattern, String replacement, boolean stop) {
    static final Pattern NON_CAPTURE_GROUPS = Pattern.compile(Pattern.quote("(?:"));

    public static Pattern compile(String input, boolean insensitive) {
        String regex;
        if (input.equals("{*}")) {
            regex = "^(.*)";
        } else if (input.regionMatches(true, 0, "regex:", 0, 6)) {
            regex = input.substring(6);
        } else {
            regex = Glob.toRegexPattern((String)input);
            if ((regex = NON_CAPTURE_GROUPS.matcher(regex).replaceAll("(")).startsWith("^") && regex.endsWith("$")) {
                regex = regex.substring(1, regex.length() - 1);
            }
        }
        SafeRegex.assertSafe(regex, (Integer)Config.Common.maxStarHeight.get(), (Integer)Config.Common.maxRepetitions.get(), (Boolean)Config.Common.allowBackrefs.get());
        return Pattern.compile(regex, insensitive ? 2 : 0);
    }

    public static PatternReplacement of(String regex) {
        return PatternReplacement.of(regex, "", false, false);
    }

    public static PatternReplacement of(String regex, @Nullable String replacement) {
        if (replacement == null) {
            replacement = "";
        }
        return PatternReplacement.of(regex, replacement, false, false);
    }

    public static PatternReplacement of(String regex, boolean stop) {
        return PatternReplacement.of(regex, "", stop, false);
    }

    public static PatternReplacement of(String regex, @Nullable String replacement, boolean stop) {
        if (replacement == null) {
            replacement = "";
        }
        return PatternReplacement.of(regex, replacement, stop, false);
    }

    public static PatternReplacement of(String regex, boolean stop, boolean insensitive) {
        return PatternReplacement.of(regex, "", stop, insensitive);
    }

    public static PatternReplacement of(String regex, @Nullable String replacement, boolean stop, boolean insensitive) {
        if (replacement == null) {
            replacement = "";
        }
        Pattern pattern = PatternReplacement.compile(regex, insensitive);
        SafeRegex.assertReplacementSafe(pattern.pattern(), replacement);
        return new PatternReplacement(regex, pattern, replacement, stop);
    }

    @Nullable
    public static PatternReplacement tryOf(String regex) {
        try {
            return PatternReplacement.of(regex);
        }
        catch (PatternSyntaxException ex) {
            return null;
        }
    }

    @Nullable
    public static PatternReplacement tryOf(String regex, @Nullable String replacement) {
        try {
            return PatternReplacement.of(regex, replacement);
        }
        catch (PatternSyntaxException ex) {
            CreateAdditionalLogistics.LOGGER.warn("Invalid regular expression: {}", (Object)regex, (Object)ex);
            return null;
        }
    }

    @Nullable
    public static PatternReplacement tryOf(String regex, boolean stop) {
        try {
            return PatternReplacement.of(regex, stop);
        }
        catch (PatternSyntaxException ex) {
            return null;
        }
    }

    @Nullable
    public static PatternReplacement tryOf(String regex, @Nullable String replacement, boolean stop) {
        try {
            return PatternReplacement.of(regex, replacement, stop);
        }
        catch (PatternSyntaxException ex) {
            CreateAdditionalLogistics.LOGGER.warn("Invalid regular expression: {}", (Object)regex, (Object)ex);
            return null;
        }
    }

    @Nullable
    public static PatternReplacement tryOf(String regex, boolean stop, boolean insensitive) {
        try {
            return PatternReplacement.of(regex, stop, insensitive);
        }
        catch (PatternSyntaxException ex) {
            return null;
        }
    }

    @Nullable
    public static PatternReplacement tryOf(String regex, @Nullable String replacement, boolean stop, boolean insensitive) {
        try {
            return PatternReplacement.of(regex, replacement, stop, insensitive);
        }
        catch (PatternSyntaxException ex) {
            CreateAdditionalLogistics.LOGGER.warn("Invalid regular expression: {}", (Object)regex, (Object)ex);
            return null;
        }
    }

    public String getRegex() {
        return this.pattern.pattern();
    }

    public boolean isCaseInsensitive() {
        return this.pattern.flags() == 2;
    }

    public Pair<String, Boolean> replace(String input) {
        try {
            Matcher matcher = this.pattern.matcher(input);
            boolean result = matcher.find();
            if (result) {
                StringBuilder sb = new StringBuilder();
                do {
                    matcher.appendReplacement(sb, this.replacement);
                } while (result = matcher.find());
                matcher.appendTail(sb);
                return Pair.of((Object)sb.toString(), (Object)true);
            }
            return Pair.of((Object)input, (Object)false);
        }
        catch (Exception ex) {
            CreateAdditionalLogistics.LOGGER.warn("Exception processing regular expression replacement for regex '{}' and replacement '{}': ", new Object[]{this.getRegex(), this.replacement, ex});
            return Pair.of((Object)input, (Object)false);
        }
    }
}

