/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.content.contraptions.actors.seats;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.actors.seat.SeatEntity;
import dev.khloeleclair.create.additionallogistics.common.content.contraptions.actors.seats.AbstractSeatBlock;
import dev.khloeleclair.create.additionallogistics.common.registries.CALEntityTypes;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class CustomSeatEntity
extends SeatEntity {
    public CustomSeatEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public CustomSeatEntity(Level world, BlockPos pos) {
        super((EntityType)CALEntityTypes.CUSTOM_SEAT.get(), world);
        this.f_19794_ = true;
    }

    public void m_6034_(double x, double y, double z) {
        this.m_20343_(x, y, z);
        this.m_20011_(this.m_142242_());
    }

    protected void m_19956_(Entity pEntity, Entity.MoveFunction pCallback) {
        double heightOffset = this.m_20186_() - pEntity.m_6049_();
        pCallback.m_20372_(pEntity, this.m_20185_(), heightOffset + CustomSeatEntity.getCustomEntitySeatOffset(pEntity), this.m_20189_());
    }

    public static double getCustomEntitySeatOffset(@Nullable Entity passenger) {
        Block block;
        Entity entity;
        double result = SeatEntity.getCustomEntitySeatOffset((Entity)passenger);
        if (passenger == null || !((entity = passenger.m_20202_()) instanceof AbstractContraptionEntity)) {
            return result;
        }
        AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entity;
        Contraption contraption = contraptionEntity.getContraption();
        if (!contraptionEntity.m_20363_(passenger)) {
            return result;
        }
        BlockPos seatPos = contraption.getSeatOf(passenger.m_20148_());
        StructureTemplate.StructureBlockInfo block2 = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(seatPos);
        if (block2 == null) {
            return result;
        }
        BlockState state = block2.f_74676_();
        if (state != null && (block = state.m_60734_()) instanceof AbstractSeatBlock) {
            AbstractSeatBlock seat = (AbstractSeatBlock)block;
            Vec3 offset = seat.getSeatPosition(null, BlockPos.f_121853_);
            result += offset.f_82480_ - 0.5;
        }
        return result;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Render
    extends EntityRenderer<CustomSeatEntity> {
        public Render(EntityRendererProvider.Context context) {
            super(context);
        }

        public boolean shouldRender(CustomSeatEntity p_225626_1_, Frustum p_225626_2_, double p_225626_3_, double p_225626_5_, double p_225626_7_) {
            return false;
        }

        public ResourceLocation getTextureLocation(CustomSeatEntity p_110775_1_) {
            return null;
        }
    }
}

