/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.base;

import com.simibubi.create.api.equipment.goggles.IProxyHoveringInformation;
import com.simibubi.create.content.decoration.encasing.EncasableBlock;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntityTicker;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.base.AbstractLowEntityKineticBlockEntity;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import java.util.Map;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLowEntityKineticBlock<T extends AbstractLowEntityKineticBlockEntity>
extends KineticBlock
implements IBE<T>,
IProxyHoveringInformation {
    public static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    public static final VoxelShape[] SIDE_SHAPES = new VoxelShape[]{Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), Block.m_49796_((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)2.0), Block.m_49796_((double)3.0, (double)3.0, (double)14.0, (double)13.0, (double)13.0, (double)16.0), Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)2.0, (double)13.0, (double)13.0), Block.m_49796_((double)14.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0)};
    protected static final Map<Byte, VoxelShape> SHAPE_CACHE = new Byte2ObjectOpenHashMap();
    @Nullable
    private static AbstractLowEntityKineticBlockEntity.WalkResult informationWalkResult;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VoxelShape getShapeWithSides(byte key) {
        VoxelShape cached;
        Map<Byte, VoxelShape> object = SHAPE_CACHE;
        synchronized (object) {
            cached = SHAPE_CACHE.get(key);
        }
        if (cached == null) {
            cached = SHAPE;
            for (Direction dir : Iterate.directions) {
                int index = dir.ordinal();
                if ((key & 1 << index) == 0) continue;
                cached = Shapes.m_83148_((VoxelShape)cached, (VoxelShape)SIDE_SHAPES[index], (BooleanOp)BooleanOp.f_82695_);
            }
            cached = cached.m_83296_();
            Map<Byte, VoxelShape> map = SHAPE_CACHE;
            synchronized (map) {
                SHAPE_CACHE.put(key, cached);
            }
        }
        return cached;
    }

    public AbstractLowEntityKineticBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static void clearInformationWalkCache() {
        informationWalkResult = null;
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof AbstractLowEntityKineticBlockEntity) {
            AbstractLowEntityKineticBlockEntity kbe = (AbstractLowEntityKineticBlockEntity)blockEntity;
            kbe.preventSpeedUpdate = 0;
            if (oldState.m_60734_() instanceof AbstractLowEntityKineticBlock != state.m_60734_() instanceof AbstractLowEntityKineticBlock) {
                return;
            }
            Block block = oldState.m_60734_();
            if (block instanceof IBE) {
                IBE oldIbe = (IBE)block;
                block = state.m_60734_();
                if (block instanceof IBE) {
                    IBE ibe = (IBE)block;
                    if (oldIbe.getBlockEntityType() != ibe.getBlockEntityType()) {
                        return;
                    }
                }
            }
            if (state.m_155947_() != oldState.m_155947_()) {
                return;
            }
            if (!this.areStatesKineticallyEquivalent(oldState, state)) {
                return;
            }
            kbe.preventSpeedUpdate = 2;
        }
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        AbstractLowEntityKineticBlock lek;
        boolean call_super = true;
        Block block = pNewState.m_60734_();
        if (block instanceof AbstractLowEntityKineticBlock && (lek = (AbstractLowEntityKineticBlock)block).getBlockEntityType() == this.getBlockEntityType()) {
            call_super = false;
        }
        if (call_super) {
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
        if (pLevel.f_46443_) {
            AbstractLowEntityKineticBlock.clearInformationWalkCache();
        }
    }

    public void onBlockStateChange(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState) {
        if (!this.isActive(newState) && level instanceof Level) {
            Level l = (Level)level;
            BlockEntity blockEntity = l.m_7702_(pos);
            if (blockEntity instanceof AbstractLowEntityKineticBlockEntity) {
                AbstractLowEntityKineticBlockEntity be = (AbstractLowEntityKineticBlockEntity)blockEntity;
                be.notifyConnectedToValidate();
            }
            l.m_46747_(pos);
        }
    }

    public BlockPos getInformationSource(Level level, BlockPos pos, BlockState state) {
        AbstractLowEntityKineticBlock b;
        if (!level.f_46443_) {
            return pos;
        }
        Block block = state.m_60734_();
        if (block instanceof AbstractLowEntityKineticBlock && (b = (AbstractLowEntityKineticBlock)block).isActive(state)) {
            return pos;
        }
        if (informationWalkResult == null || !informationWalkResult.visited().contains(pos)) {
            informationWalkResult = AbstractLowEntityKineticBlockEntity.walkBlocks(level, pos, 1);
        }
        if (!informationWalkResult.entities().isEmpty()) {
            return informationWalkResult.entities().firstKey();
        }
        return pos;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Nullable
    public IPlacementHelper getPlacementHelper() {
        return null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        EncasableBlock encasable;
        InteractionResult result;
        if (player.m_6144_() || !player.m_36326_()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        AbstractLowEntityKineticBlock abstractLowEntityKineticBlock = this;
        if (abstractLowEntityKineticBlock instanceof EncasableBlock && (result = (encasable = (EncasableBlock)abstractLowEntityKineticBlock).tryEncase(state, level, pos, stack, player, hand, hit)).m_19077_()) {
            return result;
        }
        IPlacementHelper helper = this.getPlacementHelper();
        if (helper != null && helper.matchesItem(stack)) {
            return helper.getOffset(player, level, state, pos, hit).placeInWorld(level, (BlockItem)stack.m_41720_(), player, hand, hit);
        }
        return InteractionResult.PASS;
    }

    protected boolean shouldConnectImpl(LevelAccessor level, BlockPos pos, BlockState state, Direction direction, BlockPos otherPos, BlockState otherState) {
        Block otherBlock = otherState.m_60734_();
        if (otherBlock instanceof AbstractLowEntityKineticBlock) {
            AbstractLowEntityKineticBlock lek = (AbstractLowEntityKineticBlock)otherBlock;
            DyeColor color = this.getColor(state);
            DyeColor otherColor = lek.getColor(otherState);
            return color == null || otherColor == null || color == otherColor;
        }
        return false;
    }

    public final boolean connectsTo(LevelAccessor level, BlockPos pos, BlockState state, Direction direction) {
        BlockPos otherPos = pos.m_121945_(direction);
        BlockState otherState = level.m_8055_(otherPos);
        return this.connectsTo(level, pos, state, direction, otherPos, otherState);
    }

    public final boolean connectsTo(LevelAccessor level, BlockPos pos, BlockState state, Direction direction, BlockPos otherPos, BlockState otherState) {
        Block block = otherState.m_60734_();
        if (!(block instanceof AbstractLowEntityKineticBlock)) {
            return false;
        }
        AbstractLowEntityKineticBlock lek = (AbstractLowEntityKineticBlock)block;
        return this.shouldConnectImpl(level, pos, state, direction, otherPos, otherState) && lek.shouldConnectImpl(level, otherPos, otherState, direction.m_122424_(), pos, state);
    }

    public abstract boolean isActive(BlockState var1);

    @Nullable
    public abstract DyeColor getColor(BlockState var1);

    @Nullable
    public <S extends BlockEntity> BlockEntityTicker<S> m_142354_(Level level, BlockState state, BlockEntityType<S> type) {
        if (this.isActive(state)) {
            return new SmartBlockEntityTicker();
        }
        return null;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (this.isActive(state)) {
            return this.getBlockEntityType().m_155264_(pos, state);
        }
        return null;
    }
}

