/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.cog;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.base.AbstractLazySimpleKineticBlock;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.cog.LazyCogWheelBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.registries.CALBlockEntityTypes;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLazyCogWheelBlock
extends AbstractLazySimpleKineticBlock<LazyCogWheelBlockEntity>
implements ICogWheel {
    boolean isLarge;

    public AbstractLazyCogWheelBlock(boolean large, BlockBehaviour.Properties properties) {
        super(properties);
        this.isLarge = large;
    }

    public boolean isLargeCog() {
        return this.isLarge;
    }

    public boolean isSmallCog() {
        return !this.isLarge;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return super.m_5940_(state, level, pos, context);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return CogWheelBlock.isValidCogwheelPosition((boolean)ICogWheel.isLargeCog((BlockState)state), (LevelReader)level, (BlockPos)pos, (Direction.Axis)((Direction.Axis)state.m_61143_((Property)AXIS)));
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (placer instanceof Player) {
            Player player = (Player)placer;
            this.triggerShiftingGearsAdvancement(worldIn, pos, state, player);
        }
    }

    protected void triggerShiftingGearsAdvancement(Level world, BlockPos pos, BlockState state, Player player) {
        if (world.f_46443_ || player == null) {
            return;
        }
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)CogWheelBlock.AXIS);
        for (Direction.Axis perpendicular1 : Iterate.axes) {
            if (perpendicular1 == axis) continue;
            Direction d1 = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)perpendicular1);
            for (Direction.Axis perpendicular2 : Iterate.axes) {
                if (perpendicular1 == perpendicular2 || axis == perpendicular2) continue;
                Direction d2 = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)perpendicular2);
                for (int offset1 : Iterate.positiveAndNegative) {
                    for (int offset2 : Iterate.positiveAndNegative) {
                        BlockPos connectedPos = pos.m_5484_(d1, offset1).m_5484_(d2, offset2);
                        BlockState blockState = world.m_8055_(connectedPos);
                        if (!(blockState.m_60734_() instanceof CogWheelBlock) || blockState.m_61143_((Property)CogWheelBlock.AXIS) != axis || ICogWheel.isLargeCog((BlockState)blockState) == this.isLarge) continue;
                        AllAdvancements.COGS.awardTo(player);
                    }
                }
            }
        }
    }

    @Override
    @Nullable
    public IPlacementHelper getPlacementHelper() {
        return null;
    }

    @Override
    @Nullable
    protected Direction.Axis getAxisForPlacement(BlockPlaceContext context) {
        if (context.m_43723_() != null && context.m_43723_().m_6144_()) {
            return context.m_43719_().m_122434_();
        }
        Level world = context.m_43725_();
        BlockPos placedOnPos = context.m_8083_().m_121945_(context.m_43719_().m_122424_());
        BlockState placedAgainst = world.m_8055_(placedOnPos);
        Block block = placedAgainst.m_60734_();
        if (ICogWheel.isSmallCog((BlockState)placedAgainst)) {
            return ((IRotate)block).getRotationAxis(placedAgainst);
        }
        Direction.Axis preferredAxis = AbstractLazyCogWheelBlock.getPreferredAxis(context);
        return preferredAxis != null ? preferredAxis : context.m_43719_().m_122434_();
    }

    public float getParticleTargetRadius() {
        return this.isLarge ? 1.125f : 0.65f;
    }

    public float getParticleInitialRadius() {
        return this.isLarge ? 1.0f : 0.75f;
    }

    public boolean isDedicatedCogWheel() {
        return true;
    }

    @Override
    @Nullable
    public DyeColor getColor(BlockState state) {
        return null;
    }

    @Override
    public boolean isActive(BlockState state) {
        return true;
    }

    public Class<LazyCogWheelBlockEntity> getBlockEntityClass() {
        return LazyCogWheelBlockEntity.class;
    }

    public BlockEntityType<? extends LazyCogWheelBlockEntity> getBlockEntityType() {
        return this.isLarge ? (BlockEntityType)CALBlockEntityTypes.LAZY_LARGE_COGWHEEL.get() : (BlockEntityType)CALBlockEntityTypes.LAZY_COGWHEEL.get();
    }
}

