/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.content.logistics.packageEditor;

import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.content.equipment.clipboard.ClipboardBlockEntity;
import com.simibubi.create.content.equipment.clipboard.ClipboardEntry;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.crate.BottomlessItemHandler;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import com.simibubi.create.content.logistics.packager.PackagerItemHandler;
import com.simibubi.create.content.logistics.packager.PackagingRequest;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.khloeleclair.create.additionallogistics.common.CALLang;
import dev.khloeleclair.create.additionallogistics.common.Config;
import dev.khloeleclair.create.additionallogistics.common.PatternReplacement;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.AbstractEventfulComputerBehavior;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.CALComputerCraftProxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.PatternSyntaxException;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class PackageEditorBlockEntity
extends PackagerBlockEntity
implements IHaveHoveringInformation {
    public AbstractEventfulComputerBehavior computerBehavior;
    protected boolean hasComputerReplacements = false;
    @Nullable
    protected BlockPos replacementsSource;
    @Nullable
    protected List<PatternReplacement> _replacements;
    @Nullable
    protected ReplacementSettings _replacementSettings;
    protected boolean hasReplacements;
    @Nullable
    protected String parseError;

    public PackageEditorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.computerBehavior.isPeripheralCap(cap)) {
            return this.computerBehavior.getPeripheralCapability();
        }
        return super.getCapability(cap, side);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        behaviours.removeIf(x -> x instanceof AbstractComputerBehaviour);
        this.computerBehavior = CALComputerCraftProxy.behavior((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.computerBehavior);
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.parseError != null && !this.parseError.isEmpty()) {
            tag.m_128359_("ParseError", this.parseError);
        }
        tag.m_128379_("HasReplacements", this.hasReplacements);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.parseError = tag.m_128425_("ParseError", 8) ? tag.m_128461_("ParseError") : null;
        this.hasReplacements = tag.m_128471_("HasReplacements");
    }

    public String applyRules(String address) {
        List<PatternReplacement> replacements = this.getReplacements();
        if (!replacements.isEmpty()) {
            for (PatternReplacement replacement : replacements) {
                Pair<String, Boolean> pair = replacement.replace(address);
                address = (String)pair.getFirst();
                if (!replacement.stop() || !((Boolean)pair.getSecond()).booleanValue()) continue;
                break;
            }
        }
        return address;
    }

    public void readdressPackage(ItemStack box) {
        List<PatternReplacement> replacements = this.getReplacements();
        if (!replacements.isEmpty()) {
            String address = PackageItem.getAddress((ItemStack)box);
            String newAddress = this.applyRules(address);
            if (newAddress.isEmpty()) {
                PackageItem.clearAddress((ItemStack)box);
            } else {
                PackageItem.addAddress((ItemStack)box, (String)newAddress);
            }
            this.computerBehavior.queuePositionedEvent("package_readdressed", address, newAddress, box);
        }
    }

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean supertip = super.addToTooltip(tooltip, isPlayerSneaking);
        if (!this.hasReplacements) {
            CALLang.translate("package_editor.no_address.title", new Object[0]).style(ChatFormatting.GOLD).forGoggles(tooltip);
            List cut = TooltipHelper.cutTextComponent((Component)CALLang.translate("package_editor.no_address", new Object[0]).component(), (FontHelper.Palette)FontHelper.Palette.GRAY_AND_WHITE);
            for (Component cmp : cut) {
                CALLang.builder().add(cmp).forGoggles(tooltip);
            }
            return true;
        }
        if (this.parseError == null) {
            return supertip;
        }
        CALLang.translate("package_editor.invalid_pattern.title", new Object[0]).style(ChatFormatting.GOLD).forGoggles(tooltip);
        List cut = TooltipHelper.cutTextComponent((Component)CALLang.translate("package_editor.invalid_pattern", new Object[0]).component(), (FontHelper.Palette)FontHelper.Palette.GRAY_AND_WHITE);
        for (Component cmp : cut) {
            CreateLang.builder().add(cmp).forGoggles(tooltip);
        }
        Iterator it = this.parseError.lines().iterator();
        boolean first = true;
        while (it.hasNext()) {
            String line = (String)it.next();
            cut = TooltipHelper.cutStringTextComponent((String)line, (FontHelper.Palette)(first ? FontHelper.Palette.ofColors((ChatFormatting)ChatFormatting.WHITE, (ChatFormatting)ChatFormatting.GOLD) : FontHelper.Palette.RED));
            first = false;
            for (Component cmp : cut) {
                CreateLang.builder().add(cmp).forGoggles(tooltip);
            }
        }
        return true;
    }

    public void invalidate() {
        super.invalidate();
        this.computerBehavior.removePeripheral();
    }

    public boolean unwrapBox(ItemStack box, boolean simulate) {
        if (this.animationTicks > 0 || this.redstonePowered) {
            return false;
        }
        this.getReplacements();
        if (this.parseError != null) {
            return false;
        }
        IItemHandler targetInv = (IItemHandler)this.targetInventory.getInventory();
        if (targetInv == null || targetInv instanceof PackagerItemHandler) {
            return false;
        }
        boolean targetIsCreativeCrate = targetInv instanceof BottomlessItemHandler;
        boolean anySpace = false;
        if (simulate) {
            box = box.m_41777_();
        }
        this.readdressPackage(box);
        for (int slot = 0; slot < targetInv.getSlots(); ++slot) {
            ItemStack remainder = targetInv.insertItem(slot, box, simulate);
            if (!remainder.m_41619_()) continue;
            anySpace = true;
            break;
        }
        if (!targetIsCreativeCrate && !anySpace) {
            return false;
        }
        if (simulate) {
            return true;
        }
        this.previouslyUnwrapped = box;
        this.animationInward = true;
        this.animationTicks = 20;
        this.notifyUpdate();
        return true;
    }

    public void recheckIfLinksPresent() {
    }

    public boolean redstoneModeActive() {
        return true;
    }

    public List<PatternReplacement> getReplacements() {
        if (this.hasComputerReplacements) {
            if (this._replacements == null) {
                return List.of();
            }
            return this._replacements;
        }
        if (this._replacements == null || !Objects.equals(this._replacementSettings, ReplacementSettings.get())) {
            this.updateReplacements();
        }
        return this._replacements;
    }

    public void maybeUpdateReplacements(BlockPos neighbor) {
        boolean is_relevant;
        BlockEntity nbe = this.f_58857_ == null ? null : this.f_58857_.m_7702_(neighbor);
        boolean bl = is_relevant = nbe instanceof SignBlockEntity || nbe instanceof ClipboardBlockEntity;
        if (is_relevant || neighbor.equals((Object)this.replacementsSource) || this._replacements == null) {
            this.updateReplacements();
        }
    }

    public void setComputerReplacements(@Nullable List<PatternReplacement> replacements) {
        if (replacements == null) {
            if (this.hasComputerReplacements) {
                this.hasComputerReplacements = false;
                this.updateReplacements();
            }
        } else {
            this.parseError = null;
            this.hasReplacements = true;
            this.hasComputerReplacements = true;
            this.replacementsSource = null;
            this._replacements = replacements;
            this.sendData();
        }
    }

    public void updateReplacements() {
        if (this.hasComputerReplacements) {
            return;
        }
        String lastError = this.parseError;
        boolean hadReplacements = this.hasReplacements;
        for (Direction side : Iterate.directions) {
            BlockPos pos = this.f_58858_.m_121945_(side);
            it.unimi.dsi.fastutil.Pair<List<PatternReplacement>, PatternSyntaxException> result = this.getSignOrClipboard(pos);
            if (result == null) continue;
            PatternSyntaxException ex = (PatternSyntaxException)result.second();
            if (ex != null) {
                this.replacementsSource = pos;
                this._replacements = List.of();
                this._replacementSettings = ReplacementSettings.get();
                this.parseError = ex.getMessage();
                this.hasReplacements = true;
                if (!Objects.equals(this.parseError, lastError) || hadReplacements != this.hasReplacements) {
                    this.sendData();
                }
                return;
            }
            List entries = (List)result.first();
            if (entries == null || entries.isEmpty()) continue;
            this.replacementsSource = pos;
            this._replacements = entries;
            this.parseError = null;
            this.hasReplacements = true;
            if (lastError != null || hadReplacements != this.hasReplacements) {
                this.sendData();
            }
            return;
        }
        this.replacementsSource = null;
        this._replacements = List.of();
        this._replacementSettings = ReplacementSettings.get();
        this.parseError = null;
        this.hasReplacements = false;
        if (lastError != null || hadReplacements != this.hasReplacements) {
            this.sendData();
        }
    }

    public void updateSignAddress() {
        this.signBasedAddress = "";
    }

    protected boolean isSignOrClipboardAttached(BlockState state, BlockPos pos) {
        if (state.m_61138_((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_)) {
            AttachFace face = (AttachFace)state.m_61143_((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_);
            if (face == AttachFace.CEILING) {
                return pos.m_121945_(Direction.UP).equals((Object)this.f_58858_);
            }
            if (face == AttachFace.FLOOR) {
                return pos.m_121945_(Direction.DOWN).equals((Object)this.f_58858_);
            }
        }
        if (state.m_61138_((Property)HorizontalDirectionalBlock.f_54117_)) {
            Direction opposite = ((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_();
            return pos.m_121945_(opposite).equals((Object)this.f_58858_);
        }
        return true;
    }

    @Nullable
    protected @Nullable it.unimi.dsi.fastutil.Pair<@Nullable List<PatternReplacement>, @Nullable PatternSyntaxException> getSignOrClipboard(BlockPos pos) {
        ClipboardBlockEntity cb;
        BlockEntity entity;
        BlockEntity blockEntity = entity = this.f_58857_ == null ? null : this.f_58857_.m_7702_(pos);
        if (entity instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)entity;
            ArrayList<PatternReplacement> result = new ArrayList<PatternReplacement>(1);
            for (boolean front : Iterate.trueAndFalse) {
                SignText text = sign.m_277157_(front);
                Component[] messages = text.m_276945_(false);
                for (int i = 0; i < messages.length; i += 2) {
                    PatternReplacement pattern;
                    String replacement;
                    String regex = messages[i].getString();
                    String string = replacement = i + 1 < messages.length ? messages[i + 1].getString() : "";
                    if (regex.isEmpty()) continue;
                    try {
                        pattern = PatternReplacement.of(regex, replacement);
                    }
                    catch (PatternSyntaxException ex) {
                        return it.unimi.dsi.fastutil.Pair.of(null, (Object)ex);
                    }
                    result.add(pattern);
                }
            }
            if (!result.isEmpty()) {
                return it.unimi.dsi.fastutil.Pair.of(result, null);
            }
        }
        if (entity instanceof ClipboardBlockEntity && this.isSignOrClipboardAttached((cb = (ClipboardBlockEntity)entity).m_58900_(), pos)) {
            List pages = ClipboardEntry.readAll((ItemStack)cb.dataContainer);
            ArrayList<PatternReplacement> result = new ArrayList<PatternReplacement>();
            if (pages != null) {
                for (List page : pages) {
                    if (page == null || page.isEmpty()) continue;
                    for (int i = 0; i < page.size(); i += 2) {
                        PatternReplacement pattern;
                        boolean stop;
                        ClipboardEntry regexEntry = (ClipboardEntry)page.get(i);
                        ClipboardEntry replacementEntry = i + 1 < page.size() ? (ClipboardEntry)page.get(i + 1) : null;
                        String regex = regexEntry == null ? null : regexEntry.text.getString();
                        String replacement = replacementEntry == null ? "" : replacementEntry.text.getString();
                        boolean insensitive = regexEntry != null && regexEntry.checked;
                        boolean bl = stop = replacementEntry != null && replacementEntry.checked;
                        if (regex == null || regex.isEmpty()) continue;
                        try {
                            pattern = PatternReplacement.of(regex, replacement, stop, insensitive);
                        }
                        catch (PatternSyntaxException ex) {
                            return it.unimi.dsi.fastutil.Pair.of(null, (Object)ex);
                        }
                        result.add(pattern);
                    }
                }
            }
            if (!result.isEmpty()) {
                return it.unimi.dsi.fastutil.Pair.of(result, null);
            }
        }
        return null;
    }

    public void attemptToSend(List<PackagingRequest> queuedRequests) {
        if (!this.heldBox.m_41619_() || this.animationTicks != 0 || this.buttonCooldown > 0) {
            return;
        }
        if (!this.queuedExitingPackages.isEmpty()) {
            return;
        }
        this.getReplacements();
        if (this.parseError != null) {
            return;
        }
        IItemHandler targetInv = (IItemHandler)this.targetInventory.getInventory();
        if (targetInv == null || targetInv instanceof PackagerItemHandler) {
            return;
        }
        this.attemptToFindPackage(targetInv);
        if (this.heldBox.m_41619_()) {
            return;
        }
        this.readdressPackage(this.heldBox);
    }

    protected void attemptToFindPackage(IItemHandler targetInv) {
        for (int slot = 0; slot < targetInv.getSlots(); ++slot) {
            ItemStack extracted = targetInv.extractItem(slot, 1, true);
            if (extracted.m_41619_() || !PackageItem.isPackage((ItemStack)extracted)) continue;
            targetInv.extractItem(slot, 1, false);
            this.heldBox = extracted.m_41777_();
            this.animationInward = false;
            this.animationTicks = 20;
            this.notifyUpdate();
            return;
        }
    }

    protected record ReplacementSettings(int maxStarHeight, int maxRepetitions, boolean allowBackrefs) {
        static ReplacementSettings get() {
            return new ReplacementSettings((Integer)Config.Common.maxStarHeight.get(), (Integer)Config.Common.maxRepetitions.get(), (Boolean)Config.Common.allowBackrefs.get());
        }
    }
}

