/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.registries;

import net.createmod.catnip.lang.Lang;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class CALTags {
    public static <T> TagKey<T> optionalTag(Registry<T> registry, ResourceLocation id) {
        return TagKey.m_203882_((ResourceKey)registry.m_123023_(), (ResourceLocation)id);
    }

    public static <T> TagKey<T> commonTag(Registry<T> registry, String path) {
        return CALTags.optionalTag(registry, new ResourceLocation("c", path));
    }

    public static TagKey<Block> commonBlockTag(String path) {
        return CALTags.commonTag(BuiltInRegistries.f_256975_, path);
    }

    public static TagKey<Item> commonItemTag(String path) {
        return CALTags.commonTag(BuiltInRegistries.f_257033_, path);
    }

    public static void init() {
        CALBlockTags.init();
        CALItemTags.init();
    }

    public static enum CALBlockTags {
        SHORT_SEATS,
        TALL_SEATS,
        LAZY,
        FLEXIBLE_SHAFTS,
        BASIC_SHAFTS,
        LAZY_COGS,
        LAZY_LARGE_COGS;

        public final TagKey<Block> tag;
        public final boolean alwaysDatagen;

        private CALBlockTags() {
            this(NameSpace.MOD);
        }

        private CALBlockTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CALBlockTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CALBlockTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private CALBlockTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId((String)this.name()) : path);
            this.tag = optional ? CALTags.optionalTag(BuiltInRegistries.f_256975_, id) : BlockTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Block block) {
            return block.m_204297_().m_203656_(this.tag);
        }

        public boolean matches(ItemStack stack) {
            BlockItem blockItem;
            Item item;
            return stack != null && (item = stack.m_41720_()) instanceof BlockItem && this.matches((blockItem = (BlockItem)item).m_40614_());
        }

        public boolean matches(BlockState state) {
            return state.m_204336_(this.tag);
        }

        private static void init() {
        }
    }

    public static enum CALItemTags {
        SHORT_SEATS,
        TALL_SEATS,
        LAZY,
        FLEXIBLE_SHAFTS,
        BASIC_SHAFTS,
        LAZY_COGS,
        LAZY_LARGE_COGS,
        NUGGETS_DIAMOND(NameSpace.COMMON, "nuggets/diamond"),
        NUGGETS_EMERALD(NameSpace.COMMON, "nuggets/emerald");

        public final TagKey<Item> tag;
        public final boolean alwaysDatagen;

        private CALItemTags() {
            this(NameSpace.MOD);
        }

        private CALItemTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CALItemTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CALItemTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private CALItemTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId((String)this.name()) : path);
            this.tag = optional ? CALTags.optionalTag(BuiltInRegistries.f_257033_, id) : ItemTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Item item) {
            return item.m_204114_().m_203656_(this.tag);
        }

        public boolean matches(ItemStack stack) {
            return stack.m_204117_(this.tag);
        }

        private static void init() {
        }
    }

    public static enum NameSpace {
        MOD("createadditionallogistics", false, true),
        COMMON("c");

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private NameSpace(String id) {
            this(id, true, false);
        }

        private NameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }
}

