/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.utilities;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.stockTicker.PackageOrder;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.content.logistics.tableCloth.BlueprintOverlayShopContext;
import com.simibubi.create.content.logistics.tableCloth.ShoppingListItem;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.khloeleclair.create.additionallogistics.CreateAdditionalLogistics;
import dev.khloeleclair.create.additionallogistics.api.Currency;
import dev.khloeleclair.create.additionallogistics.api.ICurrency;
import dev.khloeleclair.create.additionallogistics.api.ICurrencyBuilder;
import dev.khloeleclair.create.additionallogistics.common.CALLang;
import dev.khloeleclair.create.additionallogistics.common.Config;
import dev.khloeleclair.create.additionallogistics.common.content.logistics.cashRegister.CashRegisterBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.utilities.RecipeHelper;
import dev.khloeleclair.create.additionallogistics.common.utilities.SimpleCurrency;
import dev.khloeleclair.create.additionallogistics.mixin.IStockTickerBlockEntityAccessor;
import dev.khloeleclair.create.additionallogistics.mixin.client.IBlueprintOverlayRendererAccessor;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import org.jetbrains.annotations.Nullable;

public class CurrencyUtilities {
    public static final Map<ResourceLocation, ICurrency> CURRENCIES = new Object2ObjectOpenHashMap();
    public static final Map<Item, ResourceLocation> API_CURRENCIES = new Object2ObjectOpenHashMap();
    public static final Map<ResourceLocation, ICurrency.IValueFormatter> FORMATTERS = new Object2ObjectOpenHashMap();
    public static final Map<ResourceLocation, ICurrency.IValueFormatter> BUILTIN_FORMATTERS = new Object2ObjectOpenHashMap();
    private static boolean isPopulated;

    public static boolean isConversionEnabled(boolean is_cash_register) {
        if (!is_cash_register && !((Boolean)Config.Server.currencyStockTicker.get()).booleanValue()) {
            return false;
        }
        if (((Boolean)Config.Server.currencyCompression.get()).booleanValue()) {
            return true;
        }
        CurrencyUtilities.ensurePopulated();
        return !CURRENCIES.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ICurrency.IValueFormatter getFormatter(ResourceLocation id) {
        Map<ResourceLocation, ICurrency.IValueFormatter> map = FORMATTERS;
        synchronized (map) {
            if (FORMATTERS.containsKey(id)) {
                return FORMATTERS.get(id);
            }
        }
        map = BUILTIN_FORMATTERS;
        synchronized (map) {
            return BUILTIN_FORMATTERS.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerCurrency(ResourceLocation id, ICurrency currency) {
        Map<ResourceLocation, ICurrency> map = CURRENCIES;
        synchronized (map) {
            CURRENCIES.put(id, currency);
        }
        map = API_CURRENCIES;
        synchronized (map) {
            for (Item item : currency.getItems()) {
                API_CURRENCIES.put(item, currency.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerFormatter(ResourceLocation id, ICurrency.IValueFormatter formatter) {
        Map<ResourceLocation, ICurrency.IValueFormatter> map = FORMATTERS;
        synchronized (map) {
            FORMATTERS.put(id, formatter);
        }
    }

    private static void ensurePopulated() {
        if (isPopulated) {
            return;
        }
        isPopulated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ICurrency get(ResourceLocation id) {
        CurrencyUtilities.ensurePopulated();
        Map<ResourceLocation, ICurrency> map = CURRENCIES;
        synchronized (map) {
            return CURRENCIES.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ICurrency getForItem(Item item) {
        ResourceLocation id;
        CurrencyUtilities.ensurePopulated();
        Map<Object, Object> map = API_CURRENCIES;
        synchronized (map) {
            id = API_CURRENCIES.get(item);
        }
        if (id != null) {
            map = CURRENCIES;
            synchronized (map) {
                return CURRENCIES.get(id);
            }
        }
        return RecipeHelper.getCompactingCurrency(item);
    }

    public static void interactWithShop(Player player, Level level, BlockPos targetPos, ItemStack mainHandItem) {
        BlockEntity blockEntity;
        if (level.f_46443_ || !((blockEntity = level.m_7702_(targetPos)) instanceof StockTickerBlockEntity)) {
            return;
        }
        StockTickerBlockEntity tickerBE = (StockTickerBlockEntity)blockEntity;
        ShoppingListItem.ShoppingList list = ShoppingListItem.getList((ItemStack)mainHandItem);
        if (list == null) {
            return;
        }
        if (!tickerBE.behaviour.freqId.equals(list.shopNetwork())) {
            AllSoundEvents.DENY.playOnServer(level, (Vec3i)player.m_20183_());
            CreateLang.translate((String)"stock_keeper.wrong_network", (Object[])new Object[0]).style(ChatFormatting.RED).sendStatus(player);
            return;
        }
        Couple bakeEntries = list.bakeEntries((LevelAccessor)level, null);
        Pair<Map<ICurrency, Long>, List<BigItemStack>> payment = CurrencyUtilities.splitCost(player, ((InventorySummary)bakeEntries.getSecond()).getStacksByCount());
        Map paymentCurrencies = (Map)payment.getFirst();
        List paymentOther = (List)payment.getSecond();
        InventorySummary orderEntries = (InventorySummary)bakeEntries.getFirst();
        PackageOrder order = new PackageOrder(orderEntries.getStacksByCount());
        tickerBE.getAccurateSummary();
        InventorySummary recentSummary = tickerBE.getRecentSummary();
        for (Object entry : order.stacks()) {
            if (recentSummary.getCountOf(((BigItemStack)entry).stack) >= ((BigItemStack)entry).count) continue;
            AllSoundEvents.DENY.playOnServer(level, (Vec3i)player.m_20183_());
            CreateLang.translate((String)"stock_keeper.stock_level_too_low", (Object[])new Object[0]).style(ChatFormatting.RED).sendStatus(player);
            return;
        }
        InventorySummary consumed = new InventorySummary();
        paymentOther.forEach(arg_0 -> ((InventorySummary)consumed).add(arg_0));
        for (Map.Entry entry : paymentCurrencies.entrySet()) {
            ((ICurrency)entry.getKey()).getStacksWithValue((Long)entry.getValue()).forEach(arg_0 -> ((InventorySummary)consumed).add(arg_0));
        }
        int occupiedSlots = 0;
        for (BigItemStack entry : consumed.getStacksByCount()) {
            occupiedSlots += Mth.m_14167_((float)((float)entry.count / (float)entry.stack.m_41741_()));
        }
        SmartInventory smartInventory = ((IStockTickerBlockEntityAccessor)tickerBE).getReceivedPayments();
        for (int i = 0; i < smartInventory.getSlots(); ++i) {
            if (!smartInventory.getStackInSlot(i).m_41619_()) continue;
            --occupiedSlots;
        }
        if (occupiedSlots > 0) {
            AllSoundEvents.DENY.playOnServer(level, (Vec3i)player.m_20183_());
            CreateLang.translate((String)"stock_keeper.cash_register_full", (Object[])new Object[0]).style(ChatFormatting.RED).sendStatus(player);
            return;
        }
        for (boolean simulate : Iterate.trueAndFalse) {
            ArrayList<ItemStack> toTransfer = new ArrayList<ItemStack>();
            for (Map.Entry entry : paymentCurrencies.entrySet()) {
                ExtractValueResult result = CurrencyUtilities.extractValueFromPlayer(player, (ICurrency)entry.getKey(), (Long)entry.getValue(), simulate);
                if (simulate) {
                    if (result.remaining > 0L) {
                        CurrencyUtilities.youreTooPoor(level, player);
                        return;
                    }
                    if (!result.inventoryFull) continue;
                    AllSoundEvents.DENY.playOnServer(level, (Vec3i)player.m_20183_());
                    CALLang.translate("stock_keeper.player_inventory_full", new Object[0]).style(ChatFormatting.RED).sendStatus(player);
                    return;
                }
                toTransfer.addAll(((ICurrency)entry.getKey()).getStacksWithValue((Long)entry.getValue()));
            }
            InventorySummary tally = new InventorySummary();
            paymentOther.forEach(arg_0 -> ((InventorySummary)tally).add(arg_0));
            for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                int countOf;
                ItemStack item = player.m_150109_().m_8020_(i);
                if (item.m_41619_() || (countOf = tally.getCountOf(item)) == 0) continue;
                int toRemove = Math.min(item.m_41613_(), countOf);
                tally.add(item, -toRemove);
                if (simulate) continue;
                int newStackSize = item.m_41613_() - toRemove;
                player.m_150109_().m_6836_(i, newStackSize == 0 ? ItemStack.f_41583_ : item.m_255036_(newStackSize));
                toTransfer.add(item.m_255036_(toRemove));
            }
            if (simulate && tally.getTotalCount() != 0) {
                AllSoundEvents.DENY.playOnServer(level, (Vec3i)player.m_20183_());
                CreateLang.translate((String)"stock_keeper.too_broke", (Object[])new Object[0]).style(ChatFormatting.RED).sendStatus(player);
                return;
            }
            if (simulate) continue;
            toTransfer.forEach(s -> ItemHandlerHelper.insertItemStacked((IItemHandler)receivedPayments, (ItemStack)s, (boolean)false));
        }
        tickerBE.broadcastPackageRequest(LogisticallyLinkedBehaviour.RequestType.PLAYER, order, null, ShoppingListItem.getAddress((ItemStack)mainHandItem));
        if (tickerBE instanceof CashRegisterBlockEntity) {
            CashRegisterBlockEntity register = (CashRegisterBlockEntity)tickerBE;
            register.recordSale(player, list);
        }
        player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        if (!order.isEmpty()) {
            AllSoundEvents.STOCK_TICKER_TRADE.playOnServer(level, (Vec3i)tickerBE.m_58899_());
        }
    }

    private static void youreTooPoor(Level level, Player player) {
        AllSoundEvents.DENY.playOnServer(level, (Vec3i)player.m_20183_());
        CreateLang.translate((String)"stock_keeper.too_broke", (Object[])new Object[0]).style(ChatFormatting.RED).sendStatus(player);
    }

    public static ExtractValueResult extractValueFromPlayer(Player player, ICurrency currency, long value, boolean simulate) {
        return CurrencyUtilities.extractValueFrom(player, player.m_9236_(), player.m_20183_(), (IItemHandlerModifiable)new PlayerInvWrapper(player.m_150109_()), currency, value, simulate);
    }

    public static ExtractValueResult extractValueFromBlock(@Nullable Player player, BlockEntity be, IItemHandlerModifiable itemHandler, ICurrency currency, long value, boolean simulate) {
        return CurrencyUtilities.extractValueFrom(player, be.m_58904_(), be.m_58899_(), itemHandler, currency, value, simulate);
    }

    public static ExtractValueResult extractValueFrom(@Nullable Player player, Level level, BlockPos pos, IItemHandlerModifiable itemHandler, ICurrency currency, long value, boolean simulate) {
        if (value <= 0L) {
            return ExtractValueResult.of(false, 0L);
        }
        long remaining = value;
        int emptied_slots = 0;
        InventorySummary to_insert = new InventorySummary();
        boolean[] modes = simulate ? new boolean[]{false} : Iterate.trueAndFalse;
        for (boolean exact : modes) {
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                ItemStack stack = itemHandler.getStackInSlot(slot);
                ICurrency.ExtractionResult result = currency.extractValue(player, stack, remaining, exact);
                if (result.remainingValue() == remaining) continue;
                remaining = result.remainingValue();
                if (simulate) {
                    result.remaining().forEach(arg_0 -> ((InventorySummary)to_insert).add(arg_0));
                    ++emptied_slots;
                } else if (result.remaining().isEmpty()) {
                    itemHandler.setStackInSlot(slot, ItemStack.f_41583_);
                } else {
                    List<ItemStack> stacks = result.remaining();
                    itemHandler.setStackInSlot(slot, stacks.get(0));
                    if (stacks.size() > 1) {
                        for (int j = 1; j < stacks.size(); ++j) {
                            ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stacks.get(j), (boolean)false);
                            if (remainder.m_41619_() || level.f_46443_) continue;
                            ItemEntity entity = new ItemEntity(level, (double)pos.m_123341_(), (double)((float)pos.m_123342_() + 0.5f), (double)pos.m_123343_(), remainder);
                            entity.m_32010_(40);
                            entity.m_20256_(entity.m_20184_().m_82542_(0.0, 1.0, 0.0));
                            level.m_7967_((Entity)entity);
                        }
                    }
                }
                if (remaining <= 0L) break;
            }
            if (remaining <= 0L) break;
        }
        if (simulate) {
            int occupiedSlots = 0;
            for (BigItemStack entry : to_insert.getStacksByCount()) {
                occupiedSlots += Mth.m_14167_((float)((float)entry.count / (float)entry.stack.m_41741_()));
            }
            occupiedSlots -= emptied_slots;
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                ItemStack stack = itemHandler.getStackInSlot(slot);
                if (!stack.m_41619_()) continue;
                --occupiedSlots;
            }
            if (occupiedSlots > 0) {
                return ExtractValueResult.of(true, remaining);
            }
        }
        return ExtractValueResult.of(false, remaining);
    }

    public static Pair<Map<ICurrency, Long>, List<BigItemStack>> splitCost(Player player, List<BigItemStack> input) {
        Object2LongArrayMap currency_cost = new Object2LongArrayMap();
        ArrayList<BigItemStack> other_cost = new ArrayList<BigItemStack>();
        for (BigItemStack entry : input) {
            ICurrency currency = CurrencyUtilities.getForItem(entry.stack.m_41720_());
            if (currency == null) {
                other_cost.add(entry);
                continue;
            }
            long value = currency.getValue(player, entry.stack, entry.count);
            currency_cost.put(currency, currency_cost.getOrDefault(currency, 0L) + value);
        }
        return Pair.of((Object)currency_cost, other_cost);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderShoppingList(@Nullable ShoppingListItem.ShoppingList list) {
        if (list == null || IBlueprintOverlayRendererAccessor.CAL$getActive()) {
            return;
        }
        Couple lists = list.bakeEntries((LevelAccessor)Minecraft.m_91087_().f_91073_, null);
        Pair<Map<ICurrency, Long>, List<BigItemStack>> costs = CurrencyUtilities.splitCost((Player)Minecraft.m_91087_().f_91074_, ((InventorySummary)lists.getSecond()).getStacks());
        Map currency_cost = (Map)costs.getFirst();
        List other_cost = (List)costs.getSecond();
        InventorySummary purchased = (InventorySummary)lists.getFirst();
        if (currency_cost == null || other_cost == null || purchased == null) {
            return;
        }
        IBlueprintOverlayRendererAccessor.callPrepareCustomOverlay();
        IBlueprintOverlayRendererAccessor.CAL$setNoOutput(false);
        IBlueprintOverlayRendererAccessor.CAL$setShopContext(new BlueprintOverlayShopContext(true, 1, 0));
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        List<Pair<ItemStack, Boolean>> ingredients = IBlueprintOverlayRendererAccessor.CAL$getIngredients();
        List<ItemStack> results = IBlueprintOverlayRendererAccessor.CAL$getResults();
        for (Map.Entry entry : currency_cost.entrySet()) {
            Long value;
            ICurrency currency = (ICurrency)entry.getKey();
            ExtractValueResult result = CurrencyUtilities.extractValueFromPlayer((Player)player, currency, value = (Long)entry.getValue(), true);
            boolean can_afford = !result.inventoryFull() && result.remaining() <= 0L;
            for (ItemStack item : currency.getStacksWithValue(value)) {
                ingredients.add((Pair<ItemStack, Boolean>)Pair.of((Object)item, (Object)can_afford));
            }
        }
        for (BigItemStack bigItemStack : other_cost) {
            boolean can_afford = IBlueprintOverlayRendererAccessor.callCanAfford((Player)player, bigItemStack);
            ingredients.add((Pair<ItemStack, Boolean>)Pair.of((Object)bigItemStack.stack.m_255036_(bigItemStack.count), (Object)can_afford));
        }
        for (BigItemStack bigItemStack : purchased.getStacksByCount()) {
            results.add(bigItemStack.stack.m_255036_(bigItemStack.count));
        }
    }

    public static void createShoppingListTooltip(Player player, ItemStack stack, List<Component> tooltipComponents, TooltipFlag tooltipFlag, @Nullable Couple<InventorySummary> lists) {
        if (lists == null) {
            return;
        }
        Pair<Map<ICurrency, Long>, List<BigItemStack>> costs = CurrencyUtilities.splitCost(player, ((InventorySummary)lists.getSecond()).getStacks());
        Map currency_cost = (Map)costs.getFirst();
        List other_cost = (List)costs.getSecond();
        InventorySummary purchased = (InventorySummary)lists.getFirst();
        for (BigItemStack bigItemStack : purchased.getStacks()) {
            tooltipComponents.add(CurrencyUtilities.addTooltipLine(ChatFormatting.GRAY, bigItemStack));
        }
        if (!currency_cost.isEmpty() || !other_cost.isEmpty()) {
            CreateLang.translate((String)"table_cloth.total_cost", (Object[])new Object[0]).style(ChatFormatting.GOLD).addTo(tooltipComponents);
            for (Map.Entry entry : currency_cost.entrySet()) {
                Component cmp;
                ICurrency currency = (ICurrency)entry.getKey();
                try {
                    cmp = currency.formatValue((Long)entry.getValue(), tooltipFlag);
                }
                catch (Exception ex) {
                    CreateAdditionalLogistics.LOGGER.error("Error running currency formatter for {}", (Object)currency.getId(), (Object)ex);
                    cmp = null;
                }
                if (cmp != null) {
                    tooltipComponents.add((Component)Component.m_237119_().m_130940_(ChatFormatting.YELLOW).m_7220_(cmp));
                    continue;
                }
                for (ItemStack item : currency.getStacksWithValue((Long)entry.getValue())) {
                    tooltipComponents.add(CurrencyUtilities.addTooltipLine(ChatFormatting.YELLOW, item));
                }
            }
            for (BigItemStack bigItemStack : other_cost) {
                tooltipComponents.add(CurrencyUtilities.addTooltipLine(ChatFormatting.YELLOW, bigItemStack));
            }
        }
    }

    private static Component addTooltipLine(ChatFormatting style, ItemStack entry) {
        MutableComponent result = CreateLang.builder().add(entry.m_41786_()).text(" x").text(String.valueOf(entry.m_41613_())).style(style).component();
        Rarity rarity = entry.m_41791_();
        if (rarity == Rarity.EPIC || rarity == Rarity.RARE) {
            return result.m_130938_(entry.m_41791_().getStyleModifier());
        }
        return result;
    }

    private static Component addTooltipLine(ChatFormatting style, BigItemStack entry) {
        return CreateLang.builder().add(entry.stack.m_41786_().m_6879_()).text(" x").text(String.valueOf(entry.count)).style(style).component();
    }

    public static void init() {
        Currency.setBackend(CurrencyBackend.INSTANCE);
    }

    static {
        BUILTIN_FORMATTERS.put(ResourceLocation.m_214293_((String)"numismatics", (String)"coins"), (value, ctx) -> {
            long cogs = value / 64L;
            int spurs = (int)(value % 64L);
            MutableComponent result = Component.m_237113_((String)String.valueOf(spurs)).m_130946_("\u00a4");
            if (cogs > 0L) {
                LangBuilder new_result = CALLang.number(cogs).text(" ").text(Component.m_237115_((String)"item.numismatics.cog").getString().toLowerCase(Locale.ROOT) + (cogs == 1L ? "" : "s"));
                if (spurs == 0) {
                    return new_result.component();
                }
                result = new_result.text(", ").add(result).component();
            }
            return result;
        });
    }

    public record ExtractValueResult(boolean inventoryFull, long remaining) {
        public static ExtractValueResult of(boolean inventoryFull, long remaining) {
            return new ExtractValueResult(inventoryFull, remaining);
        }
    }

    public static class CurrencyBackend
    implements ICurrency.ICurrencyBackend {
        public static CurrencyBackend INSTANCE = new CurrencyBackend();

        @Override
        public void registerFormatter(ResourceLocation id, ICurrency.IValueFormatter formatter) {
            CurrencyUtilities.registerFormatter(id, formatter);
        }

        @Override
        public void registerCurrency(ResourceLocation id, ICurrency currency) {
            CurrencyUtilities.registerCurrency(id, currency);
        }

        @Override
        public ICurrencyBuilder newBuilder(ResourceLocation id) {
            return new SimpleCurrency.CurrencyBuilder(id, this);
        }

        @Override
        @Nullable
        public ICurrency get(ResourceLocation id) {
            return CurrencyUtilities.get(id);
        }

        @Override
        @Nullable
        public ICurrency getForItem(Item item) {
            return CurrencyUtilities.getForItem(item);
        }
    }
}

