/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.peripheral.IPeripheral;
import dev.khloeleclair.create.additionallogistics.common.content.logistics.cashRegister.CashRegisterBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.content.logistics.cashRegister.SalesHistoryData;
import dev.khloeleclair.create.additionallogistics.common.content.logistics.packageEditor.PackageEditorBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.content.trains.networkMonitor.NetworkMonitorBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.registries.CALItems;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.AbstractEventfulComputerBehavior;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.PackageApi;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.luaObjects.LuaSaleObject;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.luaObjects.LuaSalesHistoryObject;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.peripherals.CashRegisterPeripheral;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.peripherals.NetworkMonitorPeripheral;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.peripherals.PackageEditorPeripheral;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.peripherals.SyncedPeripheral;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;

public class CALComputerBehavior
extends AbstractEventfulComputerBehavior {
    protected static final Capability<IPeripheral> PERIPHERAL_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPeripheral>(){});
    LazyOptional<IPeripheral> peripheral = LazyOptional.empty();
    NonNullSupplier<IPeripheral> peripheralSupplier;

    public CALComputerBehavior(SmartBlockEntity sbe) {
        super(sbe);
        this.peripheralSupplier = CALComputerBehavior.getPeripheralFor(sbe);
    }

    public static NonNullSupplier<IPeripheral> getPeripheralFor(SmartBlockEntity sbe) {
        if (sbe instanceof CashRegisterBlockEntity) {
            CashRegisterBlockEntity cr = (CashRegisterBlockEntity)sbe;
            return () -> new CashRegisterPeripheral(cr);
        }
        if (sbe instanceof PackageEditorBlockEntity) {
            PackageEditorBlockEntity pe = (PackageEditorBlockEntity)sbe;
            return () -> new PackageEditorPeripheral(pe);
        }
        if (sbe instanceof NetworkMonitorBlockEntity) {
            NetworkMonitorBlockEntity nm = (NetworkMonitorBlockEntity)sbe;
            return () -> new NetworkMonitorPeripheral(nm);
        }
        throw new IllegalArgumentException("No peripheral available for " + String.valueOf(BuiltInRegistries.f_257049_.m_7981_((Object)sbe.m_58903_())));
    }

    public static void registerApis() {
        ComputerCraftAPI.registerAPIFactory(computer -> new PackageApi());
    }

    public static void registerItemDetailProviders() {
        VanillaDetailRegistries.ITEM_STACK.addProvider((out, stack) -> {
            if (stack.m_150930_((Item)CALItems.SALES_LEDGER.get())) {
                SalesHistoryData history = SalesHistoryData.get(stack);
                if (history == null) {
                    history = SalesHistoryData.EMPTY;
                }
                LuaSalesHistoryObject obj = new LuaSalesHistoryObject(history);
                out.put("sales", obj);
            }
        });
    }

    public void updateArguments(Object ... arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            Object arg = arguments[i];
            if (arg instanceof ItemStack) {
                ItemStack is = (ItemStack)arg;
                arguments[i] = VanillaDetailRegistries.ITEM_STACK.getDetails((Object)is);
                continue;
            }
            if (arg instanceof SalesHistoryData) {
                SalesHistoryData history = (SalesHistoryData)arg;
                arguments[i] = new LuaSalesHistoryObject(history);
                continue;
            }
            if (!(arg instanceof Pair)) continue;
            Pair tuple = (Pair)arg;
            Object first = tuple.getFirst();
            Object second = tuple.getSecond();
            if (!(first instanceof SalesHistoryData)) continue;
            SalesHistoryData history = (SalesHistoryData)first;
            if (!(second instanceof SalesHistoryData.Sale)) continue;
            SalesHistoryData.Sale sale = (SalesHistoryData.Sale)second;
            arguments[i] = new LuaSaleObject(history, sale);
        }
    }

    @Override
    public void queueEvent(String event, Object ... arguments) {
        IPeripheral peripheral = this.peripheral.resolve().orElse(null);
        if (peripheral instanceof SyncedPeripheral) {
            SyncedPeripheral sp = (SyncedPeripheral)peripheral;
            this.updateArguments(arguments);
            sp.queueEvent(event, arguments);
        }
    }

    @Override
    public void queuePositionedEvent(String event, Object ... arguments) {
        IPeripheral peripheral = this.peripheral.resolve().orElse(null);
        if (peripheral instanceof SyncedPeripheral) {
            SyncedPeripheral sp = (SyncedPeripheral)peripheral;
            this.updateArguments(arguments);
            sp.queuePositionedEvent(event, arguments);
        }
    }

    public <T> boolean isPeripheralCap(Capability<T> cap) {
        return cap == PERIPHERAL_CAPABILITY;
    }

    public <T> LazyOptional<T> getPeripheralCapability() {
        if (!this.peripheral.isPresent()) {
            this.peripheral = LazyOptional.of(this.peripheralSupplier);
        }
        return this.peripheral.cast();
    }

    public void removePeripheral() {
        this.peripheral.invalidate();
    }
}

