/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.peripherals;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.packagePort.postbox.PostboxBlockEntity;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.graph.TrackGraphLocation;
import com.simibubi.create.content.trains.signal.TrackEdgePoint;
import com.simibubi.create.content.trains.station.GlobalPackagePort;
import com.simibubi.create.content.trains.station.GlobalStation;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dev.khloeleclair.create.additionallogistics.CreateAdditionalLogistics;
import dev.khloeleclair.create.additionallogistics.common.Config;
import dev.khloeleclair.create.additionallogistics.common.content.trains.networkMonitor.NetworkMonitorBlockEntity;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.luaObjects.LuaStationObject;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.luaObjects.LuaTrainObject;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.peripherals.SyncedPeripheral;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.Nullable;

public class NetworkMonitorPeripheral
extends SyncedPeripheral<NetworkMonitorBlockEntity> {
    public NetworkMonitorPeripheral(NetworkMonitorBlockEntity blockEntity) {
        super(blockEntity);
    }

    private Map<String, Object> serializeStation(GlobalStation station) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", station.id.toString());
        result.put("name", station.name);
        MinecraftServer server = CreateAdditionalLogistics.getServer();
        ServerLevel level = server == null ? null : server.m_129880_(station.blockEntityDimension);
        ArrayList<String> addresses = new ArrayList<String>();
        int incoming = 0;
        int outgoing = 0;
        for (Map.Entry portEntry : station.connectedPorts.entrySet()) {
            BlockEntity blockEntity;
            GlobalPackagePort port = (GlobalPackagePort)portEntry.getValue();
            BlockPos pos = (BlockPos)portEntry.getKey();
            if (port.address != null && !port.address.isBlank()) {
                addresses.add(port.address);
            }
            ItemStackHandler inventory = port.offlineBuffer;
            if (!port.primed && level != null && level.m_46749_(pos) && (blockEntity = level.m_7702_(pos)) instanceof PostboxBlockEntity) {
                PostboxBlockEntity pbe = (PostboxBlockEntity)blockEntity;
                inventory = pbe.inventory;
            }
            for (int slot = 0; slot < inventory.getSlots(); ++slot) {
                ItemStack stack = inventory.getStackInSlot(slot);
                if (!PackageItem.isPackage((ItemStack)stack)) continue;
                boolean is_incoming = PackageItem.matchAddress((ItemStack)stack, (String)port.address);
                if (is_incoming) {
                    ++incoming;
                    continue;
                }
                ++outgoing;
            }
        }
        result.put("addresses", addresses);
        result.put("packages_incoming", incoming);
        result.put("packages_outgoing", outgoing);
        return result;
    }

    @Nullable
    private Map<String, Object> serializeTrain(@Nullable Train train) {
        if (train == null || train.invalid) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", train.id.toString());
        result.put("name", train.name.getString());
        int packages = 0;
        for (Carriage carriage : train.carriages) {
            CombinedInvWrapper inventory = carriage.storage.getAllItems();
            if (inventory == null) continue;
            for (int slot = 0; slot < inventory.getSlots(); ++slot) {
                ItemStack box = inventory.getStackInSlot(slot);
                if (!PackageItem.isPackage((ItemStack)box)) continue;
                ++packages;
            }
        }
        result.put("packages", packages);
        return result;
    }

    @LuaFunction(mainThread=true)
    @Nullable
    public final LuaTrainObject getTrain(String key) throws LuaException {
        Train train = this.getTrainInternal(key);
        if (train == null) {
            return null;
        }
        return LuaTrainObject.of(train, this.isWriteable());
    }

    @Nullable
    private Train getTrainInternal(String key) throws LuaException {
        UUID id;
        TrackGraphLocation pos = ((NetworkMonitorBlockEntity)this.blockEntity).edgePoint.determineGraphLocation();
        try {
            id = UUID.fromString(key);
        }
        catch (IllegalArgumentException ex) {
            id = null;
        }
        Train train = null;
        if (id != null) {
            train = (Train)Create.RAILWAYS.trains.get(id);
            if (train == null || train.invalid || !train.graph.equals(pos.graph)) {
                train = null;
            }
        } else {
            for (Train thing : Create.RAILWAYS.trains.values()) {
                if (thing.invalid || !key.equals(thing.name.getString()) || !thing.graph.equals(pos.graph)) continue;
                if (train != null) {
                    throw new LuaException("ambiguous name; use an id instead");
                }
                train = thing;
            }
        }
        return train;
    }

    @Nullable
    private <T extends TrackEdgePoint> T getEdgePoint(EdgePointType<T> type, String key) throws LuaException {
        UUID id;
        TrackGraphLocation pos = ((NetworkMonitorBlockEntity)this.blockEntity).edgePoint.determineGraphLocation();
        try {
            id = UUID.fromString(key);
        }
        catch (IllegalArgumentException ex) {
            id = null;
        }
        if (id != null) {
            return (T)pos.graph.getPoint(type, id);
        }
        if (type != EdgePointType.STATION) {
            return null;
        }
        GlobalStation station = null;
        for (GlobalStation thing : pos.graph.getPoints(EdgePointType.STATION)) {
            if (!key.equals(thing.name)) continue;
            if (station != null) {
                throw new LuaException("ambiguous name");
            }
            station = thing;
        }
        return (T)station;
    }

    private boolean isWriteable() {
        return (Boolean)Config.Server.trainWriting.get();
    }

    @LuaFunction(mainThread=true)
    @Nullable
    public final LuaStationObject getStation(String key) throws LuaException {
        GlobalStation station = (GlobalStation)this.getEdgePoint(EdgePointType.STATION, key);
        if (station == null) {
            return null;
        }
        return LuaStationObject.of(station, this.isWriteable());
    }

    @LuaFunction(mainThread=true)
    public final Map<Integer, Map<String, ?>> listTrains() {
        TrackGraphLocation pos = ((NetworkMonitorBlockEntity)this.blockEntity).edgePoint.determineGraphLocation();
        HashMap result = new HashMap();
        int i = 0;
        for (Train train : Create.RAILWAYS.trains.values()) {
            if (train.invalid || !train.graph.equals(pos.graph)) continue;
            result.put(++i, this.serializeTrain(train));
        }
        return result;
    }

    @LuaFunction(mainThread=true)
    public final Map<Integer, Map<String, ?>> listStations() {
        TrackGraphLocation pos = ((NetworkMonitorBlockEntity)this.blockEntity).edgePoint.determineGraphLocation();
        Collection stations = pos.graph.getPoints(EdgePointType.STATION);
        HashMap result = new HashMap();
        int i = 0;
        for (GlobalStation entry : stations) {
            result.put(++i, this.serializeStation(entry));
        }
        return result;
    }

    public String getType() {
        return "CreateAdditionalLogistics_TrainNetworkMonitor";
    }
}

