/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.client.registries;

import net.createmod.catnip.gui.TextureSheetSegment;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public enum CALGuiTextures implements ScreenElement,
TextureSheetSegment
{
    CASH_REGISTER_BG("cash_register", 220, 124),
    PROMISE_LIMIT_BG("promise_limit", 72, 28);

    public final ResourceLocation location;
    private final int width;
    private final int height;
    private final int startX;
    private final int startY;

    private CALGuiTextures(String location, int width, int height) {
        this(location, 0, 0, width, height);
    }

    private CALGuiTextures(String location, int startX, int startY, int width, int height) {
        this("createadditionallogistics", location, startX, startY, width, height);
    }

    private CALGuiTextures(String namespace, String location, int startX, int startY, int width, int height) {
        this.location = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("textures/gui/" + location + ".png"));
        this.width = width;
        this.height = height;
        this.startX = startX;
        this.startY = startY;
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics graphics, int x, int y) {
        graphics.blit(this.location, x, y, this.startX, this.startY, this.width, this.height);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics graphics, int x, int y, Color c) {
        this.bind();
        UIRenderHelper.drawColoredTexture((GuiGraphics)graphics, (Color)c, (int)x, (int)y, (int)this.startX, (int)this.startY, (int)this.width, (int)this.height);
    }

    public int getStartX() {
        return this.startX;
    }

    public int getStartY() {
        return this.startY;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

