/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.blockentities;

import com.simibubi.create.AllDataComponents;
import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.compat.Mods;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.content.equipment.clipboard.ClipboardBlockEntity;
import com.simibubi.create.content.equipment.clipboard.ClipboardEntry;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.crate.BottomlessItemHandler;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import com.simibubi.create.content.logistics.packager.PackagerItemHandler;
import com.simibubi.create.content.logistics.packager.PackagingRequest;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import dan200.computercraft.api.peripheral.PeripheralCapability;
import dev.khloeleclair.create.additionallogistics.common.CALLang;
import dev.khloeleclair.create.additionallogistics.common.Config;
import dev.khloeleclair.create.additionallogistics.common.PatternReplacement;
import dev.khloeleclair.create.additionallogistics.common.registries.CALBlockEntityTypes;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.CALComputerCraftProxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.PatternSyntaxException;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class PackageEditorBlockEntity
extends PackagerBlockEntity
implements IHaveHoveringInformation {
    @Nullable
    public AbstractComputerBehaviour computerBehavior;
    protected boolean hasComputerReplacements = false;
    @Nullable
    protected BlockPos replacementsSource;
    @Nullable
    protected List<PatternReplacement> _replacements;
    @Nullable
    protected ReplacementSettings _replacementSettings;
    protected boolean hasReplacements;
    @Nullable
    protected String parseError;

    public PackageEditorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)CALBlockEntityTypes.PACKAGE_EDITOR.get(), (be, context) -> be.inventory);
        if (Mods.COMPUTERCRAFT.isLoaded()) {
            event.registerBlockEntity(PeripheralCapability.get(), (BlockEntityType)CALBlockEntityTypes.PACKAGE_EDITOR.get(), (be, context) -> be.computerBehavior.getPeripheralCapability());
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        behaviours.removeIf(x -> x instanceof AbstractComputerBehaviour);
        this.computerBehavior = CALComputerCraftProxy.behavior((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.computerBehavior);
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        if (this.parseError != null && !this.parseError.isEmpty()) {
            tag.putString("ParseError", this.parseError);
        }
        tag.putBoolean("HasReplacements", this.hasReplacements);
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.parseError = tag.contains("ParseError", 8) ? tag.getString("ParseError") : null;
        this.hasReplacements = tag.getBoolean("HasReplacements");
    }

    public String applyRules(String address) {
        List<PatternReplacement> replacements = this.getReplacements();
        if (!replacements.isEmpty()) {
            for (PatternReplacement replacement : replacements) {
                Pair<String, Boolean> pair = replacement.replace(address);
                address = (String)pair.getFirst();
                if (!replacement.stop() || !((Boolean)pair.getSecond()).booleanValue()) continue;
                break;
            }
        }
        return address;
    }

    public void readdressPackage(ItemStack box) {
        List<PatternReplacement> replacements = this.getReplacements();
        if (!replacements.isEmpty()) {
            String address = PackageItem.getAddress((ItemStack)box);
            if ((address = this.applyRules(address)).isEmpty()) {
                PackageItem.clearAddress((ItemStack)box);
            } else {
                PackageItem.addAddress((ItemStack)box, (String)address);
            }
        }
    }

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean supertip = super.addToTooltip(tooltip, isPlayerSneaking);
        if (!this.hasReplacements) {
            CALLang.translate("package_editor.no_address.title", new Object[0]).style(ChatFormatting.GOLD).forGoggles(tooltip);
            List cut = TooltipHelper.cutTextComponent((Component)CALLang.translate("package_editor.no_address", new Object[0]).component(), (FontHelper.Palette)FontHelper.Palette.GRAY_AND_WHITE);
            for (Component cmp : cut) {
                CALLang.builder().add(cmp).forGoggles(tooltip);
            }
            return true;
        }
        if (this.parseError == null) {
            return supertip;
        }
        CALLang.translate("package_editor.invalid_pattern.title", new Object[0]).style(ChatFormatting.GOLD).forGoggles(tooltip);
        List cut = TooltipHelper.cutTextComponent((Component)CALLang.translate("package_editor.invalid_pattern", new Object[0]).component(), (FontHelper.Palette)FontHelper.Palette.GRAY_AND_WHITE);
        for (Component cmp : cut) {
            CreateLang.builder().add(cmp).forGoggles(tooltip);
        }
        Iterator it = this.parseError.lines().iterator();
        boolean first = true;
        while (it.hasNext()) {
            String line = (String)it.next();
            cut = TooltipHelper.cutStringTextComponent((String)line, (FontHelper.Palette)(first ? FontHelper.Palette.ofColors((ChatFormatting)ChatFormatting.WHITE, (ChatFormatting)ChatFormatting.GOLD) : FontHelper.Palette.RED));
            first = false;
            for (Component cmp : cut) {
                CreateLang.builder().add(cmp).forGoggles(tooltip);
            }
        }
        return true;
    }

    public void tick() {
        super.tick();
    }

    public boolean unwrapBox(ItemStack box, boolean simulate) {
        if (this.animationTicks > 0 || this.redstonePowered) {
            return false;
        }
        this.getReplacements();
        if (this.parseError != null) {
            return false;
        }
        IItemHandler targetInv = (IItemHandler)this.targetInventory.getInventory();
        if (targetInv == null || targetInv instanceof PackagerItemHandler) {
            return false;
        }
        boolean targetIsCreativeCrate = targetInv instanceof BottomlessItemHandler;
        boolean anySpace = false;
        if (simulate) {
            box = box.copy();
        }
        this.readdressPackage(box);
        for (int slot = 0; slot < targetInv.getSlots(); ++slot) {
            ItemStack remainder = targetInv.insertItem(slot, box, simulate);
            if (!remainder.isEmpty()) continue;
            anySpace = true;
            break;
        }
        if (!targetIsCreativeCrate && !anySpace) {
            return false;
        }
        if (simulate) {
            return true;
        }
        this.previouslyUnwrapped = box;
        this.animationInward = true;
        this.animationTicks = 20;
        this.notifyUpdate();
        return true;
    }

    public void recheckIfLinksPresent() {
    }

    public boolean redstoneModeActive() {
        return true;
    }

    public List<PatternReplacement> getReplacements() {
        if (this.hasComputerReplacements) {
            if (this._replacements == null) {
                return List.of();
            }
            return this._replacements;
        }
        if (this._replacements == null || !Objects.equals(this._replacementSettings, ReplacementSettings.get())) {
            this.updateReplacements();
        }
        return this._replacements;
    }

    public void maybeUpdateReplacements(BlockPos neighbor) {
        boolean is_relevant;
        BlockEntity nbe = this.level == null ? null : this.level.getBlockEntity(neighbor);
        boolean bl = is_relevant = nbe instanceof SignBlockEntity || nbe instanceof ClipboardBlockEntity;
        if (is_relevant || neighbor.equals((Object)this.replacementsSource) || this._replacements == null) {
            this.updateReplacements();
        }
    }

    public void setComputerReplacements(@Nullable List<PatternReplacement> replacements) {
        if (replacements == null) {
            if (this.hasComputerReplacements) {
                this.hasComputerReplacements = false;
                this.updateReplacements();
            }
        } else {
            this.parseError = null;
            this.hasReplacements = true;
            this.hasComputerReplacements = true;
            this.replacementsSource = null;
            this._replacements = replacements;
            this.sendData();
        }
    }

    public void updateReplacements() {
        if (this.hasComputerReplacements) {
            return;
        }
        String lastError = this.parseError;
        boolean hadReplacements = this.hasReplacements;
        for (Direction side : Iterate.directions) {
            BlockPos pos = this.worldPosition.relative(side);
            it.unimi.dsi.fastutil.Pair<List<PatternReplacement>, PatternSyntaxException> result = this.getSignOrClipboard(pos);
            if (result == null) continue;
            PatternSyntaxException ex = (PatternSyntaxException)result.second();
            if (ex != null) {
                this.replacementsSource = pos;
                this._replacements = List.of();
                this._replacementSettings = ReplacementSettings.get();
                this.parseError = ex.getMessage();
                this.hasReplacements = true;
                if (!Objects.equals(this.parseError, lastError) || hadReplacements != this.hasReplacements) {
                    this.sendData();
                }
                return;
            }
            List entries = (List)result.first();
            if (entries == null || entries.isEmpty()) continue;
            this.replacementsSource = pos;
            this._replacements = entries;
            this.parseError = null;
            this.hasReplacements = true;
            if (lastError != null || hadReplacements != this.hasReplacements) {
                this.sendData();
            }
            return;
        }
        this.replacementsSource = null;
        this._replacements = List.of();
        this._replacementSettings = ReplacementSettings.get();
        this.parseError = null;
        this.hasReplacements = false;
        if (lastError != null || hadReplacements != this.hasReplacements) {
            this.sendData();
        }
    }

    protected void updateSignAddress() {
        this.signBasedAddress = "";
    }

    protected boolean isSignOrClipboardAttached(BlockState state, BlockPos pos) {
        if (state.hasProperty((Property)FaceAttachedHorizontalDirectionalBlock.FACE)) {
            AttachFace face = (AttachFace)state.getValue((Property)FaceAttachedHorizontalDirectionalBlock.FACE);
            if (face == AttachFace.CEILING) {
                return pos.relative(Direction.UP).equals((Object)this.worldPosition);
            }
            if (face == AttachFace.FLOOR) {
                return pos.relative(Direction.DOWN).equals((Object)this.worldPosition);
            }
        }
        if (state.hasProperty((Property)HorizontalDirectionalBlock.FACING)) {
            Direction opposite = ((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite();
            return pos.relative(opposite).equals((Object)this.worldPosition);
        }
        return true;
    }

    @Nullable
    protected @Nullable it.unimi.dsi.fastutil.Pair<@Nullable List<PatternReplacement>, @Nullable PatternSyntaxException> getSignOrClipboard(BlockPos pos) {
        ClipboardBlockEntity cb;
        BlockEntity entity;
        BlockEntity blockEntity = entity = this.level == null ? null : this.level.getBlockEntity(pos);
        if (entity instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)entity;
            ArrayList<PatternReplacement> result = new ArrayList<PatternReplacement>(1);
            for (boolean front : Iterate.trueAndFalse) {
                SignText text = sign.getText(front);
                Component[] messages = text.getMessages(false);
                for (int i = 0; i < messages.length; i += 2) {
                    PatternReplacement pattern;
                    String replacement;
                    String regex = messages[i].getString();
                    String string = replacement = i + 1 < messages.length ? messages[i + 1].getString() : "";
                    if (regex.isEmpty()) continue;
                    try {
                        pattern = PatternReplacement.of(regex, replacement);
                    }
                    catch (PatternSyntaxException ex) {
                        return it.unimi.dsi.fastutil.Pair.of(null, (Object)ex);
                    }
                    result.add(pattern);
                }
            }
            if (!result.isEmpty()) {
                return it.unimi.dsi.fastutil.Pair.of(result, null);
            }
        }
        if (entity instanceof ClipboardBlockEntity && this.isSignOrClipboardAttached((cb = (ClipboardBlockEntity)entity).getBlockState(), pos)) {
            List pages = (List)cb.dataContainer.get(AllDataComponents.CLIPBOARD_PAGES);
            ArrayList<PatternReplacement> result = new ArrayList<PatternReplacement>();
            if (pages != null) {
                for (List page : pages) {
                    if (page == null || page.isEmpty()) continue;
                    for (int i = 0; i < page.size(); i += 2) {
                        PatternReplacement pattern;
                        boolean stop;
                        ClipboardEntry regexEntry = (ClipboardEntry)page.get(i);
                        ClipboardEntry replacementEntry = i + 1 < page.size() ? (ClipboardEntry)page.get(i + 1) : null;
                        String regex = regexEntry == null ? null : regexEntry.text.getString();
                        String replacement = replacementEntry == null ? "" : replacementEntry.text.getString();
                        boolean insensitive = regexEntry != null && regexEntry.checked;
                        boolean bl = stop = replacementEntry != null && replacementEntry.checked;
                        if (regex == null || regex.isEmpty()) continue;
                        try {
                            pattern = PatternReplacement.of(regex, replacement, stop, insensitive);
                        }
                        catch (PatternSyntaxException ex) {
                            return it.unimi.dsi.fastutil.Pair.of(null, (Object)ex);
                        }
                        result.add(pattern);
                    }
                }
            }
            if (!result.isEmpty()) {
                return it.unimi.dsi.fastutil.Pair.of(result, null);
            }
        }
        return null;
    }

    public void attemptToSend(List<PackagingRequest> queuedRequests) {
        if (!this.heldBox.isEmpty() || this.animationTicks != 0 || this.buttonCooldown > 0) {
            return;
        }
        if (!this.queuedExitingPackages.isEmpty()) {
            return;
        }
        this.getReplacements();
        if (this.parseError != null) {
            return;
        }
        IItemHandler targetInv = (IItemHandler)this.targetInventory.getInventory();
        if (targetInv == null || targetInv instanceof PackagerItemHandler) {
            return;
        }
        this.attemptToFindPackage(targetInv);
        if (this.heldBox.isEmpty()) {
            return;
        }
        this.readdressPackage(this.heldBox);
    }

    protected void attemptToFindPackage(IItemHandler targetInv) {
        for (int slot = 0; slot < targetInv.getSlots(); ++slot) {
            ItemStack extracted = targetInv.extractItem(slot, 1, true);
            if (extracted.isEmpty() || !PackageItem.isPackage((ItemStack)extracted)) continue;
            targetInv.extractItem(slot, 1, false);
            this.heldBox = extracted.copy();
            this.animationInward = false;
            this.animationTicks = 20;
            this.notifyUpdate();
            return;
        }
    }

    protected record ReplacementSettings(int maxStarHeight, int maxRepetitions, boolean allowBackrefs) {
        static ReplacementSettings get() {
            return new ReplacementSettings((Integer)Config.Common.maxStarHeight.get(), (Integer)Config.Common.maxRepetitions.get(), (Boolean)Config.Common.allowBackrefs.get());
        }
    }
}

