/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common;

import dev.khloeleclair.create.additionallogistics.common.CALLang;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    static final ModConfigSpec commonSpec;
    public static final _Common Common;
    static final ModConfigSpec clientSpec;
    public static final _Client Client;
    static final ModConfigSpec serverSpec;
    public static final _Server Server;

    private static String t(String path) {
        return CALLang.key("config." + path);
    }

    public static void register(ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)clientSpec);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)serverSpec);
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(_Common::new);
        commonSpec = (ModConfigSpec)pair.getRight();
        Common = (_Common)pair.getLeft();
        pair = new ModConfigSpec.Builder().configure(_Client::new);
        clientSpec = (ModConfigSpec)pair.getRight();
        Client = (_Client)pair.getLeft();
        pair = new ModConfigSpec.Builder().configure(_Server::new);
        serverSpec = (ModConfigSpec)pair.getRight();
        Server = (_Server)pair.getLeft();
    }

    public static class _Common {
        public final ModConfigSpec.BooleanValue enablePromiseLimits;
        public final ModConfigSpec.BooleanValue enableAdditionalStock;
        public final ModConfigSpec.BooleanValue protectStockKeeperSeats;
        public final ModConfigSpec.BooleanValue globAllowRegex;
        public final ModConfigSpec.BooleanValue globOptimize;
        public final ModConfigSpec.IntValue maxStarHeight;
        public final ModConfigSpec.IntValue maxRepetitions;
        public final ModConfigSpec.BooleanValue allowBackrefs;
        public final ModConfigSpec.DoubleValue acceleratorStressImpact;

        _Common(ModConfigSpec.Builder builder) {
            this.enablePromiseLimits = builder.comment("Adds a new configurable value to factory gauges that allows configuring how many promises each gauge can have at a time.").translation(Config.t("enable-promise-limits")).define("enablePromiseLimits", true);
            this.enableAdditionalStock = builder.comment("Adds a new configurable value to Restocker factory gauges that allows configuring the gauge to request additional items when restocking.").translation(Config.t("enable-additional-stock")).define("enableAdditionalStock", true);
            this.protectStockKeeperSeats = builder.comment("Prevent players from accidentally sitting in Seats holding a Stock Keeper.").translation(Config.t("protect-seats")).define("protectStockKeeperSeats", true);
            builder.comment("Package Addresses").push("addresses");
            this.globOptimize = builder.comment("Use optimized logic and caching for package address matching.").translation(Config.t("addresses.optimize")).define("globOptimize", true);
            this.globAllowRegex = builder.comment("Allow the user of regular expressions timestamp matching packages in Create (Frogports, Postboxes, Package Filters, etc.) with the \"RegEx:\" prefix.").translation(Config.t("addresses.allowRegex")).define("globAllowRegex", true);
            builder.comment("Regex Safety").push("regexSafety");
            this.maxStarHeight = builder.comment("Maximum star height to allow in one regular expression. This is intended to prevent catastrophic backtracking.").translation(Config.t("regex.starHeight")).defineInRange("maxStarHeight", 1, 0, 6);
            this.maxRepetitions = builder.comment("Maximum repetitions to allow in one regular expression. This is intended to minimize overall work.").translation(Config.t("regex.maxRepetitions")).defineInRange("maxRepetitions", 1000, 0, Integer.MAX_VALUE);
            this.allowBackrefs = builder.comment("Whether or not to allow backreferences in regular expressions.").translation(Config.t("regex.allowBackrefs")).define("allowBackrefs", false);
            builder.pop();
            builder.pop();
            builder.comment("Kinetics").push("kinetics");
            builder.comment("Package Accelerator").push("packageAccelerator");
            this.acceleratorStressImpact = builder.comment("The stress impact of the Package Accelerator").translation(Config.t("kinetics.stress-impact")).defineInRange("acceleratorStressImpact", 4.0, 1.0, 100.0);
            builder.pop();
            builder.pop();
        }
    }

    public static class _Client {
        _Client(ModConfigSpec.Builder builder) {
        }
    }

    public static class _Server {
        public final ModConfigSpec.BooleanValue currencyConversion;
        public final ModConfigSpec.BooleanValue stockTickersConvertToo;
        public final ModConfigSpec.BooleanValue allowTrainInventoryReading;
        public final ModConfigSpec.BooleanValue allowTrainWriting;

        _Server(ModConfigSpec.Builder builder) {
            builder.comment("Currency Conversion").push("currencyConversion");
            this.currencyConversion = builder.comment("When enabled, items that are freely converted to and from other items (for example, 9 Diamonds equal 1 Diamond Block) will be converted automatically to make shopping easier. Otherwise, only specifically defined currencies will work.").translation(Config.t("currency-conversion.compression")).define("compression", true);
            this.stockTickersConvertToo = builder.comment("Allow Stock Tickers to perform Currency Conversion as well.").translation(Config.t("currency-conversion.stock-tickers")).define("allowStockTickers", false);
            builder.pop();
            builder.comment("Train Network Monitor").push("trainNetworkMonitor");
            this.allowTrainInventoryReading = builder.comment("When enabled, a train's inventory and fluid contents can be read using a Train Network Monitor Peripheral. When disabled, only information about packages is available.").translation(Config.t("trains.network-monitor.allow-inventory")).define("allowInventoryAccess", false);
            this.allowTrainWriting = builder.comment("When enabled, trains and stations can be modified using a Train Network Monitor Peripheral. When disabled, data can only be read.").translation(Config.t("trains.network-monitor.allow-writing")).define("allowWriting", false);
            builder.pop();
        }
    }

    public static enum CurrencyMode {
        DISABLED,
        ENABLED,
        AUTO;

    }
}

