/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.cog;

import com.simibubi.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.simibubi.create.content.decoration.encasing.EncasedBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.tterrag.registrate.util.entry.BlockEntry;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.cog.AbstractLazyCogWheelBlock;
import dev.khloeleclair.create.additionallogistics.common.registries.CALBlocks;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class EncasedLazyCogWheelBlock
extends AbstractLazyCogWheelBlock
implements SpecialBlockItemRequirement,
EncasedBlock {
    private final Supplier<Block> casing;

    public EncasedLazyCogWheelBlock(boolean large, BlockBehaviour.Properties properties, Supplier<Block> casing) {
        super(large, properties);
        this.casing = casing;
    }

    public static EncasedLazyCogWheelBlock small(BlockBehaviour.Properties properties, Supplier<Block> casing) {
        return new EncasedLazyCogWheelBlock(false, properties, casing);
    }

    public static EncasedLazyCogWheelBlock large(BlockBehaviour.Properties properties, Supplier<Block> casing) {
        return new EncasedLazyCogWheelBlock(true, properties, casing);
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.block();
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level level = context.getLevel();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        level.levelEvent(2001, context.getClickedPos(), Block.getId((BlockState)state));
        KineticBlockEntity.switchToBlockState((Level)context.getLevel(), (BlockPos)context.getClickedPos(), (BlockState)this.copyValuesForCasing(state, this.getLazyCog().getDefaultState()));
        return InteractionResult.SUCCESS;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        if (target instanceof BlockHitResult) {
            BlockHitResult result = (BlockHitResult)target;
            return result.getDirection().getAxis() == state.getValue((Property)AXIS) ? this.getLazyCog().asStack() : this.getCasing().asItem().getDefaultInstance();
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public Block getCasing() {
        return this.casing.get();
    }

    public BlockEntry<?> getLazyCog() {
        return this.isLarge ? CALBlocks.LAZY_LARGE_COGWHEEL : CALBlocks.LAZY_COGWHEEL;
    }

    public ItemRequirement getRequiredItems(BlockState state, @Nullable BlockEntity blockEntity) {
        return ItemRequirement.of((BlockState)this.getLazyCog().getDefaultState(), (BlockEntity)blockEntity);
    }

    public void handleEncasing(BlockState state, Level level, BlockPos pos, ItemStack heldItem, Player player, InteractionHand hand, BlockHitResult ray) {
        KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)this.copyValuesForCasing(state, this.defaultBlockState()));
    }
}

