/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.content.logistics.cashRegister;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.stockTicker.PackageOrder;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.content.logistics.tableCloth.ShoppingListItem;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.khloeleclair.create.additionallogistics.CreateAdditionalLogistics;
import dev.khloeleclair.create.additionallogistics.api.currency.ICurrency;
import dev.khloeleclair.create.additionallogistics.common.CALLang;
import dev.khloeleclair.create.additionallogistics.common.Config;
import dev.khloeleclair.create.additionallogistics.common.content.logistics.cashRegister.CashRegisterBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.content.logistics.cashRegister.SimpleCurrency;
import dev.khloeleclair.create.additionallogistics.common.registries.CALDataMaps;
import dev.khloeleclair.create.additionallogistics.common.utilities.RecipeHelper;
import dev.khloeleclair.create.additionallogistics.mixin.IStockTickerBlockEntityAccessor;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.registries.datamaps.DataMapsUpdatedEvent;
import org.jetbrains.annotations.Nullable;

public class CurrencyUtilities {
    public static final Map<ResourceLocation, ICurrency> CURRENCIES = new Object2ObjectOpenHashMap();
    public static final Map<Item, ResourceLocation> API_CURRENCIES = new Object2ObjectOpenHashMap();
    public static final Map<ResourceLocation, BiFunction<Integer, TooltipFlag, Component>> FORMATTERS = new Object2ObjectOpenHashMap();
    public static final Map<ResourceLocation, BiFunction<Integer, TooltipFlag, Component>> BUILTIN_FORMATTERS = new Object2ObjectOpenHashMap();
    private static boolean isPopulated;

    public static boolean isConversionEnabled(boolean is_cash_register) {
        if (!is_cash_register && !((Boolean)Config.Server.stockTickersConvertToo.get()).booleanValue()) {
            return false;
        }
        if (((Boolean)Config.Server.currencyConversion.get()).booleanValue()) {
            return true;
        }
        CurrencyUtilities.ensurePopulated();
        return !CURRENCIES.isEmpty();
    }

    public static boolean isConversionEnabled() {
        return CurrencyUtilities.isConversionEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static BiFunction<Integer, TooltipFlag, Component> getFormatter(ResourceLocation id) {
        Map<ResourceLocation, BiFunction<Integer, TooltipFlag, Component>> map = FORMATTERS;
        synchronized (map) {
            if (FORMATTERS.containsKey(id)) {
                return FORMATTERS.get(id);
            }
        }
        map = BUILTIN_FORMATTERS;
        synchronized (map) {
            return BUILTIN_FORMATTERS.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerCurrency(ResourceLocation id, ICurrency currency) {
        Map<ResourceLocation, ICurrency> map = CURRENCIES;
        synchronized (map) {
            CURRENCIES.put(id, currency);
        }
        map = API_CURRENCIES;
        synchronized (map) {
            for (Item item : currency.getItems()) {
                API_CURRENCIES.put(item, currency.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerFormatter(ResourceLocation id, BiFunction<Integer, TooltipFlag, Component> formatter) {
        Map<ResourceLocation, BiFunction<Integer, TooltipFlag, Component>> map = FORMATTERS;
        synchronized (map) {
            FORMATTERS.put(id, formatter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onDataMapUpdated(DataMapsUpdatedEvent event) {
        if (event.getRegistryKey() != Registries.ITEM || !isPopulated) {
            return;
        }
        Map<ResourceLocation, ICurrency> map = CURRENCIES;
        synchronized (map) {
            if (API_CURRENCIES.isEmpty()) {
                CURRENCIES.clear();
            } else {
                CURRENCIES.keySet().removeIf(x -> !API_CURRENCIES.containsValue(x));
            }
        }
        isPopulated = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensurePopulated() {
        if (isPopulated) {
            return;
        }
        isPopulated = true;
        Map entries = BuiltInRegistries.ITEM.getDataMap(CALDataMaps.CURRENCY_DATA);
        if (entries == null || entries.isEmpty()) {
            return;
        }
        Map<ResourceLocation, ICurrency> map = CURRENCIES;
        synchronized (map) {
            int i = 0;
            for (Map.Entry entry : entries.entrySet()) {
                Item item = BuiltInRegistries.ITEM.getOptional((ResourceKey)entry.getKey()).orElse(null);
                if (item == null) continue;
                CALDataMaps.CurrencyData data = (CALDataMaps.CurrencyData)entry.getValue();
                ResourceLocation id = data.id();
                int value = data.value();
                if (id == null) {
                    CreateAdditionalLogistics.LOGGER.warn("Ignoring currency entry for {} with null id", entry.getKey());
                    continue;
                }
                if (value < 1) {
                    CreateAdditionalLogistics.LOGGER.warn("Ignoring currency {} for {} with invalid valud", (Object)id, entry.getKey());
                    continue;
                }
                ICurrency currency = CURRENCIES.computeIfAbsent(id, SimpleCurrency::new);
                if (currency instanceof SimpleCurrency) {
                    SimpleCurrency sc = (SimpleCurrency)currency;
                    sc.addItem(item, value);
                }
                ++i;
            }
            CreateAdditionalLogistics.LOGGER.debug("Added {} items to {} currencies.", (Object)i, (Object)CURRENCIES.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ICurrency get(ResourceLocation id) {
        CurrencyUtilities.ensurePopulated();
        Map<ResourceLocation, ICurrency> map = CURRENCIES;
        synchronized (map) {
            return CURRENCIES.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ICurrency getForItem(Item item) {
        Map<Object, Object> map;
        ResourceLocation id;
        CurrencyUtilities.ensurePopulated();
        CALDataMaps.CurrencyData data = (CALDataMaps.CurrencyData)item.builtInRegistryHolder().getData(CALDataMaps.CURRENCY_DATA);
        if (data != null) {
            id = data.id();
        } else {
            map = API_CURRENCIES;
            synchronized (map) {
                id = API_CURRENCIES.get(item);
            }
        }
        if (id != null) {
            map = CURRENCIES;
            synchronized (map) {
                return CURRENCIES.get(id);
            }
        }
        return RecipeHelper.getCompactingCurrency(item);
    }

    public static void interactWithShop(Player player, Level level, BlockPos targetPos, ItemStack mainHandItem) {
        BlockEntity blockEntity;
        if (level.isClientSide || !((blockEntity = level.getBlockEntity(targetPos)) instanceof StockTickerBlockEntity)) {
            return;
        }
        StockTickerBlockEntity tickerBE = (StockTickerBlockEntity)blockEntity;
        ShoppingListItem.ShoppingList list = ShoppingListItem.getList((ItemStack)mainHandItem);
        if (list == null) {
            return;
        }
        if (!tickerBE.behaviour.freqId.equals(list.shopNetwork())) {
            AllSoundEvents.DENY.playOnServer(level, (Vec3i)player.blockPosition());
            CreateLang.translate((String)"stock_keeper.wrong_network", (Object[])new Object[0]).style(ChatFormatting.RED).sendStatus(player);
            return;
        }
        Couple bakeEntries = list.bakeEntries((LevelAccessor)level, null);
        Pair<Map<ICurrency, Integer>, List<BigItemStack>> payment = CurrencyUtilities.splitCost(((InventorySummary)bakeEntries.getSecond()).getStacksByCount());
        Map paymentCurrencies = (Map)payment.getFirst();
        List paymentOther = (List)payment.getSecond();
        InventorySummary orderEntries = (InventorySummary)bakeEntries.getFirst();
        PackageOrder order = new PackageOrder(orderEntries.getStacksByCount());
        tickerBE.getAccurateSummary();
        InventorySummary recentSummary = tickerBE.getRecentSummary();
        for (Object entry : order.stacks()) {
            if (recentSummary.getCountOf(((BigItemStack)entry).stack) >= ((BigItemStack)entry).count) continue;
            AllSoundEvents.DENY.playOnServer(level, (Vec3i)player.blockPosition());
            CreateLang.translate((String)"stock_keeper.stock_level_too_low", (Object[])new Object[0]).style(ChatFormatting.RED).sendStatus(player);
            return;
        }
        InventorySummary consumed = new InventorySummary();
        consumed.addAllBigItemStacks(paymentOther);
        for (Map.Entry entry : paymentCurrencies.entrySet()) {
            consumed.addAllItemStacks(((ICurrency)entry.getKey()).getStacksWithValue((Integer)entry.getValue()));
        }
        int occupiedSlots = 0;
        for (BigItemStack entry : consumed.getStacksByCount()) {
            occupiedSlots += Mth.ceil((float)((float)entry.count / (float)entry.stack.getMaxStackSize()));
        }
        SmartInventory smartInventory = ((IStockTickerBlockEntityAccessor)tickerBE).getReceivedPayments();
        for (int i = 0; i < smartInventory.getSlots(); ++i) {
            if (!smartInventory.getStackInSlot(i).isEmpty()) continue;
            --occupiedSlots;
        }
        if (occupiedSlots > 0) {
            AllSoundEvents.DENY.playOnServer(level, (Vec3i)player.blockPosition());
            CreateLang.translate((String)"stock_keeper.cash_register_full", (Object[])new Object[0]).style(ChatFormatting.RED).sendStatus(player);
            return;
        }
        for (boolean simulate : Iterate.trueAndFalse) {
            ArrayList<ItemStack> toTransfer = new ArrayList<ItemStack>();
            for (Map.Entry entry : paymentCurrencies.entrySet()) {
                ExtractValueResult result = CurrencyUtilities.extractValueFromPlayer(player, (ICurrency)entry.getKey(), (Integer)entry.getValue(), simulate);
                if (simulate) {
                    if (result.remaining > 0) {
                        CurrencyUtilities.youreTooPoor(level, player);
                        return;
                    }
                    if (!result.inventoryFull) continue;
                    AllSoundEvents.DENY.playOnServer(level, (Vec3i)player.blockPosition());
                    CALLang.translate("stock_keeper.player_inventory_full", new Object[0]).style(ChatFormatting.RED).sendStatus(player);
                    return;
                }
                toTransfer.addAll(((ICurrency)entry.getKey()).getStacksWithValue((Integer)entry.getValue()));
            }
            InventorySummary tally = new InventorySummary();
            tally.addAllBigItemStacks(paymentOther);
            for (int i = 0; i < player.getInventory().items.size(); ++i) {
                int countOf;
                ItemStack item = player.getInventory().getItem(i);
                if (item.isEmpty() || (countOf = tally.getCountOf(item)) == 0) continue;
                int toRemove = Math.min(item.getCount(), countOf);
                tally.add(item, -toRemove);
                if (simulate) continue;
                int newStackSize = item.getCount() - toRemove;
                player.getInventory().setItem(i, newStackSize == 0 ? ItemStack.EMPTY : item.copyWithCount(newStackSize));
                toTransfer.add(item.copyWithCount(toRemove));
            }
            if (simulate && tally.getTotalCount() != 0) {
                AllSoundEvents.DENY.playOnServer(level, (Vec3i)player.blockPosition());
                CreateLang.translate((String)"stock_keeper.too_broke", (Object[])new Object[0]).style(ChatFormatting.RED).sendStatus(player);
                return;
            }
            if (simulate) continue;
            toTransfer.forEach(s -> ItemHandlerHelper.insertItemStacked((IItemHandler)receivedPayments, (ItemStack)s, (boolean)false));
        }
        if (tickerBE instanceof CashRegisterBlockEntity) {
            CashRegisterBlockEntity register = (CashRegisterBlockEntity)tickerBE;
            register.recordSale(player, list);
        }
        tickerBE.broadcastPackageRequest(LogisticallyLinkedBehaviour.RequestType.PLAYER, order, null, ShoppingListItem.getAddress((ItemStack)mainHandItem));
        player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        if (!order.isEmpty()) {
            AllSoundEvents.STOCK_TICKER_TRADE.playOnServer(level, (Vec3i)tickerBE.getBlockPos());
        }
    }

    private static void youreTooPoor(Level level, Player player) {
        AllSoundEvents.DENY.playOnServer(level, (Vec3i)player.blockPosition());
        CreateLang.translate((String)"stock_keeper.too_broke", (Object[])new Object[0]).style(ChatFormatting.RED).sendStatus(player);
    }

    public static ExtractValueResult extractValueFromPlayer(Player player, ICurrency currency, int value, boolean simulate) {
        if (value <= 0) {
            return ExtractValueResult.of(false, 0);
        }
        int remaining = value;
        int emptied_slots = 0;
        InventorySummary to_insert = new InventorySummary();
        for (int i = 0; i < player.getInventory().items.size(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            ICurrency.ExtractionResult result = currency.extractValue(stack, remaining);
            if (result.remainingValue() == remaining) continue;
            remaining = result.remainingValue();
            if (simulate) {
                to_insert.addAllItemStacks(result.remaining());
                ++emptied_slots;
                continue;
            }
            if (result.remaining().isEmpty()) {
                player.getInventory().setItem(i, ItemStack.EMPTY);
                continue;
            }
            List<ItemStack> stacks = result.remaining();
            player.getInventory().setItem(i, stacks.getFirst());
            if (stacks.size() <= 1) continue;
            for (int j = 1; j < stacks.size(); ++j) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stacks.get(j));
            }
        }
        if (simulate) {
            int occupiedSlots = 0;
            for (BigItemStack entry : to_insert.getStacksByCount()) {
                occupiedSlots += Mth.ceil((float)((float)entry.count / (float)entry.stack.getMaxStackSize()));
            }
            occupiedSlots -= emptied_slots;
            for (int i = 0; i < player.getInventory().items.size(); ++i) {
                ItemStack stack = player.getInventory().getItem(i);
                if (!stack.isEmpty()) continue;
                --occupiedSlots;
            }
            if (occupiedSlots > 0) {
                return ExtractValueResult.of(true, remaining);
            }
        }
        return ExtractValueResult.of(false, remaining);
    }

    public static Pair<Map<ICurrency, Integer>, List<BigItemStack>> splitCost(List<BigItemStack> input) {
        Object2IntArrayMap currency_cost = new Object2IntArrayMap();
        ArrayList<BigItemStack> other_cost = new ArrayList<BigItemStack>();
        for (BigItemStack entry : input) {
            ICurrency currency = CurrencyUtilities.getForItem(entry.stack.getItem());
            if (currency == null) {
                other_cost.add(entry);
                continue;
            }
            int value = currency.getValue(entry.stack, entry.count);
            currency_cost.put(currency, currency_cost.getOrDefault(currency, 0) + value);
        }
        return Pair.of((Object)currency_cost, other_cost);
    }

    public static void createShoppingListTooltip(ItemStack stack, List<Component> tooltipComponents, TooltipFlag tooltipFlag, @Nullable Couple<InventorySummary> lists) {
        if (lists == null) {
            return;
        }
        Pair<Map<ICurrency, Integer>, List<BigItemStack>> costs = CurrencyUtilities.splitCost(((InventorySummary)lists.getSecond()).getStacks());
        Map currency_cost = (Map)costs.getFirst();
        List other_cost = (List)costs.getSecond();
        InventorySummary purchased = (InventorySummary)lists.getFirst();
        for (BigItemStack bigItemStack : purchased.getStacks()) {
            tooltipComponents.add(CurrencyUtilities.addTooltipLine(ChatFormatting.GRAY, bigItemStack));
        }
        if (!currency_cost.isEmpty() || !other_cost.isEmpty()) {
            CreateLang.translate((String)"table_cloth.total_cost", (Object[])new Object[0]).style(ChatFormatting.GOLD).addTo(tooltipComponents);
            for (Map.Entry entry : currency_cost.entrySet()) {
                Component cmp;
                ICurrency currency = (ICurrency)entry.getKey();
                if (currency.hasFormatter()) {
                    try {
                        cmp = currency.formatValue((Integer)entry.getValue(), tooltipFlag);
                    }
                    catch (Exception ex) {
                        CreateAdditionalLogistics.LOGGER.error("Error running currency formatter for {}", (Object)currency.getId(), (Object)ex);
                        cmp = null;
                    }
                } else {
                    cmp = null;
                }
                if (cmp != null) {
                    tooltipComponents.add((Component)Component.empty().withStyle(ChatFormatting.YELLOW).append(cmp));
                    continue;
                }
                for (ItemStack item : currency.getStacksWithValue((Integer)entry.getValue())) {
                    tooltipComponents.add(CurrencyUtilities.addTooltipLine(ChatFormatting.YELLOW, item));
                }
            }
            for (BigItemStack bigItemStack : other_cost) {
                tooltipComponents.add(CurrencyUtilities.addTooltipLine(ChatFormatting.YELLOW, bigItemStack));
            }
        }
    }

    private static Component addTooltipLine(ChatFormatting style, ItemStack entry) {
        return CreateLang.builder().add(entry.getHoverName().plainCopy()).text(" x").text(String.valueOf(entry.getCount())).style(style).component();
    }

    private static Component addTooltipLine(ChatFormatting style, BigItemStack entry) {
        return CreateLang.builder().add(entry.stack.getHoverName().plainCopy()).text(" x").text(String.valueOf(entry.count)).style(style).component();
    }

    static {
        BUILTIN_FORMATTERS.put(ResourceLocation.fromNamespaceAndPath((String)"numismatics", (String)"coins"), (value, ctx) -> {
            if (ctx.hasShiftDown()) {
                return null;
            }
            int cogs = value / 64;
            int spurs = value % 64;
            MutableComponent result = Component.literal((String)String.valueOf(spurs)).append("\u00a4");
            if (cogs > 0) {
                LangBuilder new_result = CALLang.number(cogs).text(" ").text(Component.translatable((String)"item.numismatics.cog").getString().toLowerCase(Locale.ROOT) + (cogs == 1 ? "" : "s"));
                if (spurs == 0) {
                    return new_result.component();
                }
                result = new_result.text(", ").add(result).component();
            }
            return result;
        });
    }

    public record ExtractValueResult(boolean inventoryFull, int remaining) {
        public static ExtractValueResult of(boolean inventoryFull, int remaining) {
            return new ExtractValueResult(inventoryFull, remaining);
        }
    }
}

