/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common;

import com.google.common.base.Ascii;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import dev.khloeleclair.create.additionallogistics.common.RegexTokenizer;
import it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import java.time.Duration;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.createmod.catnip.data.Glob;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SafeRegex {
    private static final Cache<String, CachedGlobResult> GLOB_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(Duration.ofMinutes(30L)).build();
    private static final Cache<String, CachedRegexResult> REGEX_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(Duration.ofMinutes(30L)).build();
    private static final Cache<ObjectObjectImmutablePair<String, String>, CachedReplacementResult> REPLACEMENT_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(Duration.ofMinutes(30L)).build();

    public static void assertReplacementSafe(@NotNull String regex, @NotNull String replacement) {
        ObjectObjectImmutablePair key = ObjectObjectImmutablePair.of((Object)regex, (Object)replacement);
        CachedReplacementResult cached = (CachedReplacementResult)REPLACEMENT_CACHE.getIfPresent((Object)key);
        if (cached == null) {
            try {
                CachedRegexResult rcache = SafeRegex.processRegex(regex);
                if (rcache.isError()) {
                    throw rcache.error;
                }
                Pattern pattern = rcache.pattern;
                Matcher matcher = pattern.matcher("");
                int groups = matcher.groupCount();
                Set<String> named = pattern.namedGroups().keySet();
                int pos = 0;
                while (pos < replacement.length()) {
                    char next = replacement.charAt(pos);
                    if (next == '\\') {
                        if (++pos == replacement.length()) {
                            throw new PatternSyntaxException("character to be escaped is missing", replacement, pos);
                        }
                        ++pos;
                        continue;
                    }
                    if (next == '$') {
                        if (++pos == replacement.length()) {
                            throw new PatternSyntaxException("Illegal group reference: group index is missing", replacement, pos);
                        }
                        next = replacement.charAt(pos);
                        if (next == '{') {
                            int begin = ++pos;
                            while (pos < replacement.length() && (Ascii.isLowerCase((char)(next = replacement.charAt(pos))) || Ascii.isUpperCase((char)next) || next >= '0' && next <= '9')) {
                                ++pos;
                            }
                            if (begin == pos) {
                                throw new PatternSyntaxException("named capturing group has 0 length name", replacement, pos);
                            }
                            if (next != '}') {
                                throw new PatternSyntaxException("named capturing group is missing trailing '}'", replacement, pos);
                            }
                            String group = replacement.substring(begin, pos);
                            if (!named.contains(group)) {
                                throw new PatternSyntaxException("Group with name {" + group + "} does not exist", replacement, pos);
                            }
                            ++pos;
                            continue;
                        }
                        int num = next - 48;
                        if (num < 0 || num > 9) {
                            throw new PatternSyntaxException("Illegal group reference", replacement, pos);
                        }
                        if (num > groups) {
                            throw new PatternSyntaxException("Group '" + num + "' does not exist", replacement, pos);
                        }
                        ++pos;
                        continue;
                    }
                    ++pos;
                }
                cached = new CachedReplacementResult(null);
            }
            catch (PatternSyntaxException ex) {
                cached = new CachedReplacementResult(ex);
            }
            REPLACEMENT_CACHE.put((Object)key, (Object)cached);
        }
        if (cached.isError()) {
            throw cached.error;
        }
    }

    @NotNull
    private static CachedRegexResult processRegex(@NotNull String regex) {
        CachedRegexResult cached = (CachedRegexResult)REGEX_CACHE.getIfPresent((Object)regex);
        if (cached == null) {
            try {
                Pattern pattern = Pattern.compile(regex);
                RegexTokenizer.Node node = RegexTokenizer.parse(regex);
                cached = new CachedRegexResult(pattern, node.starHeight(), node.repetitions(), RegexTokenizer.visitNodes(node, x -> x instanceof RegexTokenizer.ReferenceNode));
            }
            catch (PatternSyntaxException ex) {
                cached = new CachedRegexResult(ex);
            }
            REGEX_CACHE.put((Object)regex, (Object)cached);
        }
        return cached;
    }

    public static CachedRegexResult assertSafe(@NotNull String regex, int starHeightLimit, int repetitionLimit, boolean allowBackreference) throws PatternSyntaxException {
        CachedRegexResult cached = SafeRegex.processRegex(regex);
        if (cached.isError()) {
            throw cached.error;
        }
        if (cached.starHeight > starHeightLimit) {
            throw new PatternSyntaxException("Unsafe regex: star height (" + cached.starHeight + ") exceeds limit (" + starHeightLimit + ")", regex, 0);
        }
        if (cached.repetitions > repetitionLimit) {
            throw new PatternSyntaxException("Unsafe regex: potential repetitions (" + cached.repetitions + ") exceed limit (" + repetitionLimit + ")", regex, 0);
        }
        if (!allowBackreference && cached.hasBackref) {
            throw new PatternSyntaxException("Unsafe regex: usage of backref", regex, 0);
        }
        return cached;
    }

    public static boolean isSafe(String regex, int starHeightLimit, int repetitionLimit, boolean allowBackreference) {
        try {
            SafeRegex.assertSafe(regex, starHeightLimit, repetitionLimit, allowBackreference);
        }
        catch (PatternSyntaxException ex) {
            return false;
        }
        return true;
    }

    private static String cachedToRegexPattern(String address) {
        CachedGlobResult cached = (CachedGlobResult)GLOB_CACHE.getIfPresent((Object)address);
        if (cached == null) {
            try {
                cached = new CachedGlobResult(Glob.toRegexPattern((String)address), null);
            }
            catch (PatternSyntaxException ex) {
                cached = new CachedGlobResult(null, ex);
            }
            GLOB_CACHE.put((Object)address, (Object)cached);
        }
        return cached.regex;
    }

    public static boolean matchAddress(String boxAddress, String address) {
        CachedRegexResult info2;
        if (address.isBlank()) {
            return boxAddress.isBlank();
        }
        if (address.equals("*") || boxAddress.equals("*")) {
            return true;
        }
        try {
            info2 = SafeRegex.processRegex(SafeRegex.cachedToRegexPattern(address));
            if (info2.isError()) {
                throw info2.error;
            }
            if (info2.pattern != null && info2.pattern.matcher(boxAddress).matches()) {
                return true;
            }
        }
        catch (PatternSyntaxException info2) {
            // empty catch block
        }
        try {
            info2 = SafeRegex.processRegex(SafeRegex.cachedToRegexPattern(boxAddress));
            if (info2.isError()) {
                throw info2.error;
            }
            if (info2.pattern != null && info2.pattern.matcher(address).matches()) {
                return true;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return false;
    }

    private record CachedReplacementResult(@Nullable PatternSyntaxException error) {
        boolean isError() {
            return this.error != null;
        }
    }

    public static final class CachedRegexResult {
        @Nullable
        public final Pattern pattern;
        public final int starHeight;
        public final int repetitions;
        public final boolean hasBackref;
        @Nullable
        public final PatternSyntaxException error;

        CachedRegexResult(Pattern pattern, int starHeight, int repetitions, boolean hasBackref) {
            this.pattern = pattern;
            this.starHeight = starHeight;
            this.repetitions = repetitions;
            this.hasBackref = hasBackref;
            this.error = null;
        }

        CachedRegexResult(PatternSyntaxException error) {
            this.pattern = null;
            this.starHeight = 0;
            this.repetitions = 0;
            this.hasBackref = false;
            this.error = error;
        }

        public boolean isError() {
            return this.error != null;
        }
    }

    private record CachedGlobResult(@Nullable String regex, @Nullable PatternSyntaxException error) {
    }
}

