/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.flexible;

import com.simibubi.create.content.decoration.encasing.EncasedBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.base.AbstractLowEntityKineticBlock;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.base.AbstractLowEntityKineticBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.flexible.FlexibleShaftBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.registries.CALBlockEntityTypes;
import dev.khloeleclair.create.additionallogistics.common.registries.CALPackets;
import dev.khloeleclair.create.additionallogistics.mixin.RotationPropagatorInvoker;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFlexibleShaftBlock
extends AbstractLowEntityKineticBlock<FlexibleShaftBlockEntity> {
    public static final BooleanProperty[] SIDES = new BooleanProperty[]{BooleanProperty.create((String)"down"), BooleanProperty.create((String)"up"), BlockStateProperties.NORTH, BlockStateProperties.SOUTH, BlockStateProperties.WEST, BlockStateProperties.EAST};
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    @Nullable
    protected final DyeColor color;

    protected AbstractFlexibleShaftBlock(BlockBehaviour.Properties properties, @Nullable DyeColor color) {
        super(properties);
        this.color = color;
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
        if (state.hasProperty((Property)ProperWaterloggedBlock.WATERLOGGED)) {
            state = (BlockState)state.setValue((Property)ProperWaterloggedBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        for (BooleanProperty side : SIDES) {
            state = (BlockState)state.setValue((Property)side, (Comparable)Boolean.valueOf(false));
        }
        this.registerDefaultState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add((Property[])SIDES);
        builder.add(new Property[]{ACTIVE});
        if (this instanceof ProperWaterloggedBlock) {
            builder.add(new Property[]{ProperWaterloggedBlock.WATERLOGGED});
        }
    }

    @Override
    public boolean isActive(BlockState state) {
        return (Boolean)state.getValue((Property)ACTIVE);
    }

    @Override
    @Nullable
    public DyeColor getColor(BlockState state) {
        return this.color;
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        BlockState newState = state;
        for (Direction dir : Iterate.directions) {
            newState = (BlockState)newState.setValue((Property)SIDES[mirror.mirror(dir).ordinal()], (Comparable)((Boolean)state.getValue((Property)SIDES[dir.ordinal()])));
        }
        return newState;
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        BlockState newState = state;
        for (Direction dir : Iterate.directions) {
            newState = (BlockState)newState.setValue((Property)SIDES[rotation.rotate(dir).ordinal()], (Comparable)((Boolean)state.getValue((Property)SIDES[dir.ordinal()])));
        }
        return newState;
    }

    protected BlockState getConnectedState(Level level, BlockPos pos, BlockState initialState) {
        BlockState state = initialState;
        for (Direction dir : Iterate.directions) {
            int index = dir.ordinal();
            BlockPos dpos = pos.relative(dir);
            BlockState dstate = level.getBlockState(dpos);
            boolean connects = this.connectsTo((LevelAccessor)level, pos, state, dir, dpos, dstate);
            state = (BlockState)state.setValue((Property)SIDES[index], (Comparable)Boolean.valueOf(connects));
        }
        return state;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        return this.getConnectedState(level, pos, super.getStateForPlacement(context));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        byte key = 0;
        for (Direction dir : Iterate.directions) {
            int index = dir.ordinal();
            if (!((Boolean)state.getValue((Property)SIDES[index])).booleanValue()) continue;
            key = (byte)(key | 1 << index);
        }
        return this.getShapeWithSides(key);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BooleanProperty prop = SIDES[direction.ordinal()];
        boolean connects = this.connectsTo(level, pos, state, direction, neighborPos, level.getBlockState(neighborPos));
        if ((Boolean)state.getValue((Property)prop) != connects && level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            state = (BlockState)state.setValue((Property)prop, (Comparable)Boolean.valueOf(connects));
            AbstractLowEntityKineticBlockEntity.markDirty((Level)sl, pos);
        }
        return state;
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return Direction.Axis.Y;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        BlockEntity blockEntity;
        if (!this.isActive(state) || !((blockEntity = world.getBlockEntity(pos)) instanceof FlexibleShaftBlockEntity)) {
            return false;
        }
        FlexibleShaftBlockEntity fsb = (FlexibleShaftBlockEntity)blockEntity;
        return fsb.getSide(face) != 0;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!player.getMainHandItem().isEmpty()) {
            return InteractionResult.FAIL;
        }
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            CALPackets.OpenFlexibleShaftScreen.of(pos).send(sp);
        }
        return InteractionResult.SUCCESS;
    }

    public void setSide(Level level, BlockPos pos, Direction side, byte value) {
        BlockEntity blockEntity;
        if (level.isClientSide || !level.isLoaded(pos)) {
            return;
        }
        BlockState state = level.getBlockState(pos);
        if (!((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
            if (value == 0) {
                return;
            }
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
            AbstractLowEntityKineticBlockEntity.markDirty(level, pos);
        }
        if (!((blockEntity = level.getBlockEntity(pos)) instanceof FlexibleShaftBlockEntity)) {
            return;
        }
        FlexibleShaftBlockEntity fsb = (FlexibleShaftBlockEntity)blockEntity;
        fsb.setSide(side, value);
        if (!fsb.shouldBeActive()) {
            fsb.deactivateSelf();
        }
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        IRotate rot;
        BlockPos offsetPos;
        BlockState offsetState;
        Block block;
        BlockEntity blockEntity;
        Level level = context.getLevel();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        Direction side = context.getClickedFace();
        if (((Boolean)state.getValue((Property)SIDES[side.ordinal()])).booleanValue() && !(this instanceof EncasedBlock)) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.getClickedPos();
        if (!((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
            AbstractLowEntityKineticBlockEntity.markDirty(level, pos);
        }
        if (!((blockEntity = level.getBlockEntity(context.getClickedPos())) instanceof FlexibleShaftBlockEntity)) {
            return InteractionResult.SUCCESS;
        }
        FlexibleShaftBlockEntity fsb = (FlexibleShaftBlockEntity)blockEntity;
        byte mode = fsb.getSide(side);
        if (mode == 0 && (block = (offsetState = level.getBlockState(offsetPos = pos.relative(side))).getBlock()) instanceof IRotate && (rot = (IRotate)block).hasShaftTowards((LevelReader)level, offsetPos, offsetState, side.getOpposite()) && (block = level.getBlockEntity(offsetPos)) instanceof KineticBlockEntity) {
            KineticBlockEntity kbe = (KineticBlockEntity)block;
            fsb.setSideUnsafe(side, (byte)1);
            float neighborSpeed = kbe.getTheoreticalSpeed();
            float newSpeed = RotationPropagatorInvoker.callGetConveyedSpeed((KineticBlockEntity)fsb, kbe);
            float oppositeSpeed = RotationPropagatorInvoker.callGetConveyedSpeed((KineticBlockEntity)fsb, kbe);
            if (newSpeed != 0.0f && oppositeSpeed != 0.0f) {
                boolean incompatible;
                boolean bl = incompatible = Math.signum(newSpeed) != Math.signum(neighborSpeed) && newSpeed != 0.0f && neighborSpeed != 0.0f;
                if (incompatible) {
                    fsb.setSide(side, (byte)-1);
                    return InteractionResult.SUCCESS;
                }
            }
            fsb.setSideUnsafe(side, mode);
        }
        fsb.toggleSide(side);
        if (!fsb.shouldBeActive()) {
            fsb.deactivateSelf();
        }
        return InteractionResult.SUCCESS;
    }

    public Class<FlexibleShaftBlockEntity> getBlockEntityClass() {
        return FlexibleShaftBlockEntity.class;
    }

    public BlockEntityType<? extends FlexibleShaftBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CALBlockEntityTypes.FLEXIBLE_SHAFT.get();
    }
}

