/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.content.trains.networkMonitor;

import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.signal.SingleBlockEntityEdgePoint;
import dev.khloeleclair.create.additionallogistics.CreateAdditionalLogistics;
import dev.khloeleclair.create.additionallogistics.common.content.trains.networkMonitor.NetworkMonitorBlockEntity;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class NetworkMonitor
extends SingleBlockEntityEdgePoint {
    public static final EdgePointType<NetworkMonitor> NETWORK_MONITOR = EdgePointType.register((ResourceLocation)CreateAdditionalLogistics.asResource("network_monitor"), NetworkMonitor::new);

    public static void onTrainArrival(TrackGraph graph, UUID train, UUID station) {
        graph.getPoints(NETWORK_MONITOR).forEach(point -> point.onTrainArrival(train, station));
    }

    public static void onTrainDeparture(TrackGraph graph, UUID train) {
        graph.getPoints(NETWORK_MONITOR).forEach(point -> point.onTrainDeparture(train));
    }

    @Nullable
    public NetworkMonitorBlockEntity getEntity() {
        BlockEntity blockEntity;
        MinecraftServer server = CreateAdditionalLogistics.getServer();
        if (server == null || this.blockEntityDimension == null) {
            return null;
        }
        ServerLevel level = server.getLevel(this.blockEntityDimension);
        if (level == null || !level.isLoaded(this.blockEntityPos) || !((blockEntity = level.getBlockEntity(this.blockEntityPos)) instanceof NetworkMonitorBlockEntity)) {
            return null;
        }
        NetworkMonitorBlockEntity nmbe = (NetworkMonitorBlockEntity)blockEntity;
        return nmbe;
    }

    public void onTrainArrival(UUID train, UUID station) {
        NetworkMonitorBlockEntity nmbe = this.getEntity();
        if (nmbe != null) {
            nmbe.onTrainArrival(train, station);
        }
    }

    public void onTrainDeparture(UUID train) {
        NetworkMonitorBlockEntity nmbe = this.getEntity();
        if (nmbe != null) {
            nmbe.onTrainDeparture(train);
        }
    }

    public void tick(TrackGraph graph, boolean preTrains) {
        super.tick(graph, preTrains);
    }
}

