/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.utilities;

import com.simibubi.create.content.equipment.extendoGrip.ExtendoGripItem;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class FlexiblePoleHelper<T extends Comparable<T>>
implements IPlacementHelper {
    protected final Predicate<BlockState> statePredicate;
    protected final Function<BlockState, T> comparableSupplier;
    @Nullable
    protected final Property<T> property;

    public FlexiblePoleHelper(Predicate<BlockState> statePredicate, Function<BlockState, T> comparableSupplier, @Nullable Property<T> property) {
        this.statePredicate = statePredicate;
        this.comparableSupplier = comparableSupplier;
        this.property = property;
    }

    public boolean matches(BlockState state, T value) {
        if (!this.statePredicate.test(state)) {
            return false;
        }
        return this.comparableSupplier.apply(state) == value;
    }

    public int attachedPoles(Level world, BlockPos pos, Direction direction, T value) {
        BlockPos checkPos = pos.relative(direction);
        BlockState state = world.getBlockState(checkPos);
        int count = 0;
        while (this.matches(state, value)) {
            ++count;
            checkPos = checkPos.relative(direction);
            state = world.getBlockState(checkPos);
        }
        return count;
    }

    public Predicate<BlockState> getStatePredicate() {
        return this.statePredicate;
    }

    public BlockState getStateForPlacement(Level world, BlockPos pos, BlockState state, BlockPos sourcePos, BlockState sourceState) {
        if (this.property != null && state.hasProperty(this.property)) {
            return (BlockState)state.setValue(this.property, sourceState.getValue(this.property));
        }
        return state;
    }

    public PlacementOffset getOffset(@Nullable Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
        AttributeInstance reach;
        List directions = IPlacementHelper.orderedByDistanceOnlyAxis((BlockPos)pos, (Vec3)ray.getLocation(), (Direction.Axis)Direction.Axis.Y);
        int range = (Integer)AllConfigs.server().equipment.placementAssistRange.get();
        if (player != null && (reach = player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE)) != null && reach.hasModifier(ExtendoGripItem.singleRangeAttributeModifier.id())) {
            range += 4;
        }
        Comparable sourceProperty = (Comparable)this.comparableSupplier.apply(state);
        for (Direction dir : directions) {
            BlockPos newPos;
            BlockState newState;
            int poles = this.attachedPoles(world, pos, dir, sourceProperty);
            if (poles >= range || !(newState = world.getBlockState(newPos = pos.relative(dir, poles + 1))).canBeReplaced()) continue;
            return PlacementOffset.success((Vec3i)newPos, s -> this.getStateForPlacement(world, newPos, (BlockState)s, pos, state));
        }
        return PlacementOffset.fail();
    }
}

