/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.peripherals;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dev.khloeleclair.create.additionallogistics.common.PatternReplacement;
import dev.khloeleclair.create.additionallogistics.common.content.logistics.packageEditor.PackageEditorBlockEntity;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.peripherals.SyncedPeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.Nullable;

public class PackageEditorPeripheral
extends SyncedPeripheral<PackageEditorBlockEntity> {
    public PackageEditorPeripheral(PackageEditorBlockEntity blockEntity) {
        super(blockEntity);
    }

    @Override
    public void attach(IComputerAccess computer) {
        super.attach(computer);
        ((PackageEditorBlockEntity)this.blockEntity).setComputerReplacements(null);
    }

    @Override
    public void detach(IComputerAccess computer) {
        super.detach(computer);
        ((PackageEditorBlockEntity)this.blockEntity).setComputerReplacements(null);
    }

    @Nullable
    public Map<String, Object> getRule(int idx) {
        List<PatternReplacement> replacements = ((PackageEditorBlockEntity)this.blockEntity).getReplacements();
        if (idx < 0 || idx >= replacements.size()) {
            return null;
        }
        PatternReplacement replacement = replacements.get(idx);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("pattern", replacement.rawPattern());
        result.put("replacement", replacement.replacement());
        result.put("ignore_case", replacement.isCaseInsensitive());
        result.put("is_stop", replacement.stop());
        return result;
    }

    @LuaFunction(mainThread=true)
    public final Map<Integer, ?> listRules() {
        List<PatternReplacement> replacements = ((PackageEditorBlockEntity)this.blockEntity).getReplacements();
        HashMap<Integer, Map<String, Object>> result = new HashMap<Integer, Map<String, Object>>();
        for (int i = 0; i < replacements.size(); ++i) {
            result.put(i + 1, this.getRule(i));
        }
        return result;
    }

    @Nullable
    private String getString(@Nullable Object obj, String field, boolean allowNull) throws LuaException {
        if (obj == null && allowNull) {
            return null;
        }
        if (obj instanceof String) {
            String str = (String)obj;
            return str;
        }
        throw new LuaException(field + " must be a string" + (allowNull ? " or nil" : ""));
    }

    private boolean getBoolean(@Nullable Object obj, String field) throws LuaException {
        if (obj instanceof Boolean) {
            Boolean bool = (Boolean)obj;
            return bool;
        }
        if (obj == null) {
            return false;
        }
        throw new LuaException(field + " must be a boolean");
    }

    private PatternReplacement readReplacement(@Nullable Object input) throws LuaException {
        PatternReplacement rule;
        if (!(input instanceof Map)) {
            throw new LuaException("Rule must be a table");
        }
        Map ruleTable = (Map)input;
        @Nullable String pattern = null;
        String replacement = null;
        boolean ignore_case = false;
        boolean is_stop = false;
        for (Map.Entry entry : ruleTable.entrySet()) {
            Object key = entry.getKey();
            if (key.equals("pattern")) {
                pattern = this.getString(entry.getValue(), "pattern", false);
                continue;
            }
            if (key.equals("replacement")) {
                replacement = this.getString(entry.getValue(), "replacement", true);
                continue;
            }
            if (key.equals("ignore_case")) {
                ignore_case = this.getBoolean(entry.getValue(), "ignore_case");
                continue;
            }
            if (key.equals("is_stop")) {
                is_stop = this.getBoolean(entry.getValue(), "is_stop");
                continue;
            }
            throw new LuaException("Invalid key in rule '" + String.valueOf(key) + "'");
        }
        if (pattern == null) {
            throw new LuaException("Rule must have a pattern");
        }
        try {
            rule = PatternReplacement.of(pattern, replacement, is_stop, ignore_case);
        }
        catch (PatternSyntaxException ex) {
            throw new LuaException("Invalid rule: " + ex.getMessage());
        }
        return rule;
    }

    @LuaFunction(mainThread=true)
    public final void resetRules() {
        ((PackageEditorBlockEntity)this.blockEntity).setComputerReplacements(null);
    }

    @LuaFunction(mainThread=true)
    public final void clearRules() {
        ((PackageEditorBlockEntity)this.blockEntity).setComputerReplacements(List.of());
    }

    @LuaFunction(mainThread=true)
    public final void setRules(IArguments arguments) throws LuaException {
        ArrayList<PatternReplacement> replacements = new ArrayList<PatternReplacement>();
        for (int i = 0; i < arguments.count(); ++i) {
            replacements.add(this.readReplacement(arguments.get(i)));
        }
        ((PackageEditorBlockEntity)this.blockEntity).setComputerReplacements(replacements);
    }

    @LuaFunction(mainThread=true)
    public final void addRule(Object input) throws LuaException {
        PatternReplacement rule = this.readReplacement(input);
        ArrayList<PatternReplacement> replacements = new ArrayList<PatternReplacement>(((PackageEditorBlockEntity)this.blockEntity).getReplacements());
        replacements.add(rule);
        ((PackageEditorBlockEntity)this.blockEntity).setComputerReplacements(replacements);
    }

    @LuaFunction(mainThread=true)
    public final void setRule(int index, Object input) throws LuaException {
        PatternReplacement rule = this.readReplacement(input);
        ArrayList<PatternReplacement> replacements = new ArrayList<PatternReplacement>(((PackageEditorBlockEntity)this.blockEntity).getReplacements());
        int idx = index - 1;
        if (idx < 0 || idx > replacements.size()) {
            throw new LuaException("Index " + index + " out of range, expected between 1 and " + replacements.size());
        }
        if (idx == replacements.size()) {
            replacements.add(rule);
        } else {
            replacements.set(idx, rule);
        }
        ((PackageEditorBlockEntity)this.blockEntity).setComputerReplacements(replacements);
    }

    @LuaFunction(mainThread=true)
    public final String applyRules(String input) throws LuaException {
        return ((PackageEditorBlockEntity)this.blockEntity).applyRules(input);
    }

    public String getType() {
        return "CreateAdditionalLogistics_PackageEditor";
    }
}

