/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones;

import com.mojang.datafixers.util.Either;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.InternalMethods;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneStyle;
import net.blay09.mods.waystones.api.WaystoneTeleportContext;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.api.error.WaystoneTeleportError;
import net.blay09.mods.waystones.api.requirement.ConditionResolver;
import net.blay09.mods.waystones.api.requirement.ParameterSerializer;
import net.blay09.mods.waystones.api.requirement.RequirementFunction;
import net.blay09.mods.waystones.api.requirement.RequirementType;
import net.blay09.mods.waystones.api.requirement.VariableResolver;
import net.blay09.mods.waystones.api.requirement.WarpRequirement;
import net.blay09.mods.waystones.api.trait.IAttunementItem;
import net.blay09.mods.waystones.block.ModBlocks;
import net.blay09.mods.waystones.block.SharestoneBlock;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.config.WaystonesConfigData;
import net.blay09.mods.waystones.core.InvalidWaystone;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneManagerImpl;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.core.WaystoneTeleportContextImpl;
import net.blay09.mods.waystones.core.WaystoneTeleportManager;
import net.blay09.mods.waystones.item.ModItems;
import net.blay09.mods.waystones.requirement.RequirementModifierParser;
import net.blay09.mods.waystones.requirement.RequirementRegistry;
import net.blay09.mods.waystones.requirement.WarpRequirementsContextImpl;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class InternalMethodsImpl
implements InternalMethods {
    @Override
    public Either<WaystoneTeleportContext, WaystoneTeleportError> createDefaultTeleportContext(class_1297 entity, Waystone waystone, Consumer<WaystoneTeleportContext> init) {
        return WaystonesAPI.createCustomTeleportContext(entity, waystone).ifLeft(context -> {
            WaystonesConfigData.TransportMobs shouldTransportPets = WaystonesConfig.getActive().teleports.transportPets;
            if (shouldTransportPets == WaystonesConfigData.TransportMobs.ENABLED || shouldTransportPets == WaystonesConfigData.TransportMobs.SAME_DIMENSION && !context.isDimensionalTeleport()) {
                context.getAdditionalEntities().addAll(WaystoneTeleportManager.findPets(entity));
            }
            context.getLeashedEntities().addAll(WaystoneTeleportManager.findLeashedAnimals(entity));
            init.accept((WaystoneTeleportContext)context);
            context.setRequirements(this.resolveRequirements((WaystoneTeleportContext)context));
        });
    }

    @Override
    public Either<WaystoneTeleportContext, WaystoneTeleportError> createCustomTeleportContext(class_1297 entity, Waystone waystone) {
        if (!waystone.isValid()) {
            return Either.right((Object)new WaystoneTeleportError.InvalidWaystone(waystone));
        }
        MinecraftServer server = entity.method_5682();
        if (server == null) {
            return Either.right((Object)new WaystoneTeleportError.NotOnServer());
        }
        class_3218 targetLevel = server.method_3847(waystone.getDimension());
        if (targetLevel == null) {
            return Either.right((Object)new WaystoneTeleportError.InvalidDimension(waystone.getDimension()));
        }
        if (!waystone.isValidInLevel(targetLevel)) {
            return Either.right((Object)new WaystoneTeleportError.MissingWaystone(waystone));
        }
        return Either.left((Object)new WaystoneTeleportContextImpl(entity, waystone));
    }

    @Override
    public WaystoneTeleportContext createUnboundTeleportContext(class_1297 entity, Waystone waystone) {
        return new WaystoneTeleportContextImpl(entity, waystone);
    }

    @Override
    public WaystoneTeleportContext createUnboundTeleportContext(class_1297 entity) {
        return new WaystoneTeleportContextImpl(entity, InvalidWaystone.INSTANCE);
    }

    @Override
    public Either<List<class_1297>, WaystoneTeleportError> tryTeleport(WaystoneTeleportContext context) {
        return WaystoneTeleportManager.tryTeleport(context);
    }

    @Override
    public Either<List<class_1297>, WaystoneTeleportError> forceTeleport(WaystoneTeleportContext context) {
        return WaystoneTeleportManager.doTeleport(context);
    }

    @Override
    public Optional<Waystone> getWaystoneAt(class_1937 level, class_2338 pos) {
        return WaystoneManagerImpl.get(level.method_8503()).getWaystoneAt((class_1922)level, pos);
    }

    @Override
    public Optional<Waystone> getWaystoneAt(MinecraftServer server, class_1922 level, class_2338 pos) {
        return WaystoneManagerImpl.get(server).getWaystoneAt(level, pos);
    }

    @Override
    public Optional<Waystone> getWaystone(class_1937 level, UUID uuid) {
        return WaystoneManagerImpl.get(level.method_8503()).getWaystoneById(uuid);
    }

    @Override
    public Optional<Waystone> getWaystone(MinecraftServer server, UUID uuid) {
        return WaystoneManagerImpl.get(server).getWaystoneById(uuid);
    }

    @Override
    public class_1799 createAttunedShard(Waystone warpPlate) {
        class_1799 itemStack = new class_1799((class_1935)ModItems.attunedShard);
        this.setBoundWaystone(itemStack, warpPlate);
        return itemStack;
    }

    @Override
    public class_1799 createBoundScroll(Waystone waystone) {
        class_1799 itemStack = new class_1799((class_1935)ModItems.warpScroll);
        this.setBoundWaystone(itemStack, waystone);
        return itemStack;
    }

    @Override
    public Optional<Waystone> placeWaystone(class_1937 level, class_2338 pos, WaystoneStyle style) {
        class_2248 block = Balm.getRegistries().getBlock(style.getBlockRegistryName());
        level.method_8652(pos, (class_2680)block.method_9564().method_11657((class_2769)WaystoneBlock.HALF, (Comparable)class_2756.field_12607), 3);
        level.method_8652(pos.method_10084(), (class_2680)block.method_9564().method_11657((class_2769)WaystoneBlock.HALF, (Comparable)class_2756.field_12609), 3);
        return this.getWaystoneAt(level, pos);
    }

    @Override
    public Optional<Waystone> placeSharestone(class_1937 level, class_2338 pos, class_1767 color) {
        SharestoneBlock sharestone = ModBlocks.getSharestone(color);
        if (sharestone == null) {
            return Optional.empty();
        }
        level.method_8652(pos, (class_2680)sharestone.method_9564().method_11657((class_2769)WaystoneBlock.HALF, (Comparable)class_2756.field_12607), 3);
        level.method_8652(pos.method_10084(), (class_2680)sharestone.method_9564().method_11657((class_2769)WaystoneBlock.HALF, (Comparable)class_2756.field_12609), 3);
        return this.getWaystoneAt(level, pos);
    }

    @Override
    public Optional<Waystone> placeWarpPlate(class_1937 level, class_2338 pos) {
        level.method_8652(pos, ModBlocks.warpPlate.method_9564(), 3);
        return this.getWaystoneAt(level, pos);
    }

    @Override
    public Optional<Waystone> getBoundWaystone(@Nullable class_1657 player, class_1799 itemStack) {
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof IAttunementItem) {
            IAttunementItem attunementItem = (IAttunementItem)class_17922;
            return attunementItem.getWaystoneAttunedTo(Balm.getHooks().getServer(), player, itemStack);
        }
        return Optional.empty();
    }

    @Override
    public void setBoundWaystone(class_1799 itemStack, @Nullable Waystone waystone) {
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof IAttunementItem) {
            IAttunementItem attunementItem = (IAttunementItem)class_17922;
            attunementItem.setWaystoneAttunedTo(itemStack, waystone);
        }
    }

    @Override
    public WarpRequirement resolveRequirements(WaystoneTeleportContext context) {
        WarpRequirementsContextImpl requirementsContext = new WarpRequirementsContextImpl(context);
        List<String> configuredModifiers = WaystonesConfig.getActive().teleports.warpRequirements;
        for (String modifier : configuredModifiers) {
            if (modifier.isBlank()) continue;
            RequirementModifierParser.parse(modifier).stream().filter(configuredModifier -> configuredModifier.requirement().modifier().isEnabled()).forEach(requirementsContext::apply);
        }
        return requirementsContext.resolve();
    }

    @Override
    public void registerRequirementType(RequirementType<?> requirementType) {
        RequirementRegistry.register(requirementType);
    }

    @Override
    public void registerRequirementModifier(RequirementFunction<?, ?> requirementModifier) {
        RequirementRegistry.register(requirementModifier);
    }

    @Override
    public void registerVariableResolver(VariableResolver variableResolver) {
        RequirementRegistry.register(variableResolver);
    }

    @Override
    public void registerConditionResolver(ConditionResolver<?> conditionResolver) {
        RequirementRegistry.register(conditionResolver);
    }

    @Override
    public void registerParameterSerializer(ParameterSerializer<?> parameterSerializer) {
        RequirementRegistry.register(parameterSerializer);
    }

    @Override
    public boolean isWaystoneActivated(class_1657 player, Waystone waystone) {
        return PlayerWaystoneManager.isWaystoneActivated(player, waystone);
    }

    @Override
    public Collection<Waystone> getActivatedWaystones(class_1657 player) {
        return PlayerWaystoneManager.getActivatedWaystones(player);
    }

    @Override
    public Optional<Waystone> getNearestWaystone(class_1657 player) {
        return PlayerWaystoneManager.getNearestWaystone(player);
    }

    @Override
    public void activateWaystone(class_3222 player, Waystone waystone) {
        PlayerWaystoneManager.activateWaystone((class_1657)player, waystone);
        WaystoneSyncManager.sendActivatedWaystones((class_1657)player);
    }

    @Override
    public void deactivateWaystone(class_3222 player, Waystone waystone) {
        PlayerWaystoneManager.deactivateWaystone((class_1657)player, waystone);
        WaystoneSyncManager.sendActivatedWaystones((class_1657)player);
    }

    @Override
    public Stream<Waystone> getAllWaystones(MinecraftServer server) {
        return WaystoneManagerImpl.get(server).getWaystones();
    }

    @Override
    public Stream<Waystone> getWaystonesByType(MinecraftServer server, class_2960 type) {
        return WaystoneManagerImpl.get(server).getWaystonesByType(type);
    }

    @Override
    public void removeWaystoneFromDatabase(MinecraftServer server, Waystone waystone) {
        WaystoneManagerImpl.get(server).removeWaystone(waystone);
        PlayerWaystoneManager.removeKnownWaystone(server, waystone);
    }
}

