/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.UUID;
import net.blay09.mods.waystones.api.MutableWaystone;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneOrigin;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.core.InvalidWaystone;
import net.blay09.mods.waystones.core.WaystoneManagerImpl;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class WaystoneProxy
implements Waystone,
MutableWaystone {
    private final MinecraftServer server;
    private final UUID waystoneUid;
    private Waystone backingWaystone;

    public WaystoneProxy(@Nullable MinecraftServer server, UUID waystoneUid) {
        this.server = server;
        this.waystoneUid = waystoneUid;
    }

    @Override
    public boolean isValidInLevel(class_3218 level) {
        return this.getBackingWaystone().isValidInLevel(level);
    }

    @Override
    public boolean isTransient() {
        return this.getBackingWaystone().isTransient();
    }

    @Override
    public boolean isValid() {
        return WaystoneManagerImpl.get(this.server).getWaystoneById(this.waystoneUid).isPresent();
    }

    public Waystone getBackingWaystone() {
        if (this.backingWaystone == null) {
            this.backingWaystone = WaystoneManagerImpl.get(this.server).getWaystoneById(this.waystoneUid).orElse(InvalidWaystone.INSTANCE);
        }
        return this.backingWaystone;
    }

    @Override
    public UUID getOwnerUid() {
        return this.getBackingWaystone().getOwnerUid();
    }

    @Override
    public UUID getWaystoneUid() {
        return this.waystoneUid;
    }

    @Override
    public class_2561 getName() {
        return this.getBackingWaystone().getName();
    }

    @Override
    public class_5321<class_1937> getDimension() {
        return this.getBackingWaystone().getDimension();
    }

    @Override
    public boolean wasGenerated() {
        return this.getBackingWaystone().wasGenerated();
    }

    @Override
    public WaystoneOrigin getOrigin() {
        return this.getBackingWaystone().getOrigin();
    }

    @Override
    public boolean isOwner(class_1657 player) {
        return this.getBackingWaystone().isOwner(player);
    }

    @Override
    public class_2338 getPos() {
        return this.getBackingWaystone().getPos();
    }

    @Override
    public class_2960 getWaystoneType() {
        return this.getBackingWaystone().getWaystoneType();
    }

    @Override
    public void setName(class_2561 name) {
        Waystone backingWaystone = this.getBackingWaystone();
        if (backingWaystone instanceof MutableWaystone) {
            ((MutableWaystone)((Object)backingWaystone)).setName(name);
        }
    }

    @Override
    public void setDimension(class_5321<class_1937> dimension) {
        Waystone backingWaystone = this.getBackingWaystone();
        if (backingWaystone instanceof MutableWaystone) {
            ((MutableWaystone)((Object)backingWaystone)).setDimension(dimension);
        }
    }

    @Override
    public void setPos(class_2338 pos) {
        Waystone backingWaystone = this.getBackingWaystone();
        if (backingWaystone instanceof MutableWaystone) {
            ((MutableWaystone)((Object)backingWaystone)).setPos(pos);
        }
    }

    @Override
    public void setOwnerUid(UUID ownerUid) {
        Waystone backingWaystone = this.getBackingWaystone();
        if (backingWaystone instanceof MutableWaystone) {
            ((MutableWaystone)((Object)backingWaystone)).setOwnerUid(ownerUid);
        }
    }

    @Override
    public void setTransient(boolean isTransient) {
        Waystone backingWaystone = this.getBackingWaystone();
        if (backingWaystone instanceof MutableWaystone) {
            ((MutableWaystone)((Object)backingWaystone)).setTransient(isTransient);
        }
    }

    @Override
    public WaystoneVisibility getVisibility() {
        return this.getBackingWaystone().getVisibility();
    }

    @Override
    public void setVisibility(WaystoneVisibility visibility) {
        Waystone backingWaystone = this.getBackingWaystone();
        if (backingWaystone instanceof MutableWaystone) {
            ((MutableWaystone)((Object)backingWaystone)).setVisibility(visibility);
        }
    }
}

