/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.data.pack;

import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.api.data.pack.IDataPackObject;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerTeam;
import com.gitlab.srcmc.rctmod.api.utils.JsonUtils;
import com.gitlab.srcmc.rctmod.api.utils.PathUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7367;

public class DataPackManager
extends class_4309
implements AutoCloseable {
    private static final Gson GSON = new Gson();
    public static final String PATH_GROUPS = "trainers/groups";
    public static final String PATH_SINGLE = "trainers/single";
    public static final String PATH_DEFAULT = "trainers/default";
    public static final String PATH_TRAINERS = "trainers";
    private final Map<String, DataLocator> contextMap = Map.ofEntries(Map.entry("mobs", new DataLocator(class_3264.field_14190, ".json")), Map.entry("dialogs", new DataLocator(class_3264.field_14190, ".json")), Map.entry("loot_table", new DataLocator(class_3264.field_14190, ".json")), Map.entry("textures", new DataLocator(class_3264.field_14188, ".png")));
    private Map<class_2960, class_3262> trainerTeams = new HashMap<class_2960, class_3262>();
    private class_3264 packType;

    public DataPackManager(class_3264 packType) {
        super(GSON, "rctmod");
        this.packType = packType;
    }

    public void init(class_3300 resourceManager) {
        this.clear();
        resourceManager.method_29213().filter(dp -> dp.method_14406(this.packType).contains("rctmod")).forEach(this::gather);
    }

    public void listTrainerTeams(class_3262.class_7664 out) {
        this.trainerTeams.forEach((k, v) -> out.accept(k, (Object)v.method_14405(this.packType, k)));
    }

    @Override
    public void close() {
        for (DataLocator dl : this.contextMap.values()) {
            for (class_3262 dp : dl.groupData.values()) {
                dp.close();
            }
            for (class_3262 dp : dl.singleData.values()) {
                dp.close();
            }
            if (dl.defaultData == null) continue;
            dl.defaultData.getValue().close();
        }
        for (class_3262 dp : this.trainerTeams.values()) {
            dp.close();
        }
    }

    protected void clear() {
        for (DataLocator dl : this.contextMap.values()) {
            dl.groupData.clear();
            dl.singleData.clear();
            dl.defaultData = null;
        }
        this.trainerTeams.clear();
    }

    public Optional<class_2960> findResource(String trainerId, String context) {
        DataLocator dl = this.contextMap.get(context);
        if (dl == null) {
            return Optional.empty();
        }
        class_2960 singlePath = class_2960.method_60655((String)"rctmod", (String)(context + "/trainers/single/" + trainerId + dl.fileSuffix));
        if (dl.singleData.containsKey(singlePath)) {
            return Optional.of(singlePath);
        }
        class_2960 groupsPath = this.findGroupsKey(trainerId, dl.groupData);
        if (groupsPath != null) {
            return Optional.of(groupsPath);
        }
        if (dl.defaultData != null) {
            return Optional.of(dl.defaultData.getKey());
        }
        return Optional.empty();
    }

    public Optional<TrainerTeam> loadTrainerTeam(String trainerId) {
        class_2960 teamResource = class_2960.method_60655((String)"rctmod", (String)("trainers/" + trainerId + ".json"));
        if (this.trainerTeams.containsKey(teamResource)) {
            return Optional.of(JsonUtils.loadFromOrThrow((class_7367<InputStream>)this.trainerTeams.get(teamResource).method_14405(this.packType, teamResource), TrainerTeam.class));
        }
        return Optional.empty();
    }

    public <T> void loadResource(String trainerId, String context, Consumer<T> consumer, Class<T> type) {
        this.loadResource(trainerId, context, consumer, TypeToken.get(type));
    }

    public <T> void loadResource(String trainerId, String context, Consumer<T> consumer, TypeToken<T> type) {
        class_2960 groupsPath;
        DataLocator dl = this.contextMap.get(context);
        class_2960 singlePath = class_2960.method_60655((String)"rctmod", (String)(context + "/trainers/single/" + trainerId + dl.fileSuffix));
        T obj = dl.singleData.containsKey(singlePath) ? JsonUtils.loadFromOrThrow((class_7367<InputStream>)dl.singleData.get(singlePath).method_14405(dl.packType, singlePath), type) : ((groupsPath = this.findGroupsKey(trainerId, dl.groupData)) != null ? JsonUtils.loadFromOrThrow((class_7367<InputStream>)dl.groupData.get(groupsPath).method_14405(dl.packType, groupsPath), type) : JsonUtils.loadFromOrThrow((class_7367<InputStream>)dl.defaultData.getValue().method_14405(dl.packType, dl.defaultData.getKey()), type));
        if (obj instanceof IDataPackObject) {
            IDataPackObject dpo = (IDataPackObject)obj;
            dpo.onLoad(this, trainerId, context);
        }
        consumer.accept(obj);
    }

    private void gather(class_3262 dataPack) {
        this.gatherTrainers(dataPack);
        this.gatherResources(dataPack);
        ModCommon.LOG.info("Data pack initialized: " + dataPack.method_14409());
    }

    private void gatherTrainers(class_3262 dataPack) {
        dataPack.method_14408(this.packType, "rctmod", PATH_TRAINERS, (rl, io) -> this.trainerTeams.put((class_2960)rl, dataPack));
    }

    private void gatherResources(class_3262 dataPack) {
        for (Map.Entry<String, DataLocator> entry : this.contextMap.entrySet()) {
            this.scanDataPack(dataPack, entry.getKey(), entry.getValue());
        }
    }

    private void scanDataPack(class_3262 dataPack, String context, DataLocator dl) {
        dataPack.method_14408(dl.packType, "rctmod", context + "/trainers/groups", (rl, io) -> dl.groupData.put((class_2960)rl, dataPack));
        dataPack.method_14408(dl.packType, "rctmod", context + "/trainers/single", (rl, io) -> dl.singleData.put((class_2960)rl, dataPack));
        class_2960 defaultRl = class_2960.method_60655((String)"rctmod", (String)(context + "/trainers/default" + dl.fileSuffix));
        class_7367 defaultData = dataPack.method_14405(dl.packType, defaultRl);
        if (defaultData != null) {
            dl.defaultData = Map.entry(defaultRl, dataPack);
        }
    }

    private class_2960 findGroupsKey(String trainerId, Map<class_2960, class_3262> groups) {
        class_2960 key = null;
        String longestGroupId = "";
        for (Map.Entry<class_2960, class_3262> groupsEntry : groups.entrySet()) {
            String groupsId = PathUtils.filename(groupsEntry.getKey().method_12832());
            if (groupsId.length() <= longestGroupId.length() || !trainerId.equals(groupsId) && !trainerId.startsWith(groupsId + "_")) continue;
            key = groupsEntry.getKey();
            longestGroupId = groupsId;
        }
        return key;
    }

    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profilerFiller) {
        this.init(resourceManager);
        this.close();
    }

    private static class DataLocator {
        public final Map<class_2960, class_3262> groupData = new HashMap<class_2960, class_3262>();
        public final Map<class_2960, class_3262> singleData = new HashMap<class_2960, class_3262>();
        public Map.Entry<class_2960, class_3262> defaultData;
        public final class_3264 packType;
        public final String fileSuffix;

        public DataLocator(class_3264 packType, String fileSuffix) {
            this.packType = packType;
            this.fileSuffix = fileSuffix;
        }
    }
}

