/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.data.pack;

import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.config.IServerConfig;
import com.gitlab.srcmc.rctmod.api.data.pack.DataPackManager;
import com.gitlab.srcmc.rctmod.api.data.pack.IDataPackObject;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerTeam;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2960;

public class TrainerMobData
implements IDataPackObject {
    private Type type = Type.NORMAL;
    private List<Set<String>> requiredDefeats = new ArrayList<Set<String>>();
    private int maxTrainerWins = 3;
    private int maxTrainerDefeats = 1;
    private int battleCooldownTicks = 240;
    private float spawnWeightFactor = 1.0f;
    private Set<String> biomeTagBlacklist = new HashSet<String>();
    private Set<String> biomeTagWhitelist = new HashSet<String>();
    private transient int rewardLevelCap;
    private transient Set<String> followdBy = new HashSet<String>();
    private transient Map<String, String[]> dialog = new HashMap<String, String[]>();
    private transient class_2960 textureResource;
    private transient class_2960 lootTableResource;
    private transient TrainerTeam trainerTeam;

    public TrainerMobData() {
        this.textureResource = class_2960.method_60655((String)"rctmod", (String)"textures/trainers/default.png");
        this.lootTableResource = class_2960.method_60655((String)"rctmod", (String)"trainers/default");
        this.trainerTeam = new TrainerTeam();
    }

    public TrainerMobData(TrainerMobData origin) {
        this.type = origin.type;
        this.rewardLevelCap = origin.rewardLevelCap;
        this.requiredDefeats = List.copyOf(origin.requiredDefeats);
        this.followdBy = Set.copyOf(origin.followdBy);
        this.maxTrainerWins = origin.maxTrainerWins;
        this.maxTrainerDefeats = origin.maxTrainerDefeats;
        this.battleCooldownTicks = origin.battleCooldownTicks;
        this.biomeTagBlacklist = Set.copyOf(origin.biomeTagBlacklist);
        this.biomeTagWhitelist = Set.copyOf(origin.biomeTagWhitelist);
        this.dialog = Map.copyOf(origin.dialog);
        this.textureResource = origin.textureResource;
        this.lootTableResource = origin.lootTableResource;
        this.trainerTeam = origin.trainerTeam;
    }

    public Type getType() {
        return this.type;
    }

    public void setRewardLevelCap(int levelCap) {
        IServerConfig cfg = RCTMod.getInstance().getServerConfig();
        this.rewardLevelCap = Math.min(100, Math.max(1, Math.max(cfg.initialLevelCap() + cfg.additiveLevelCapRequirement(), levelCap)));
    }

    public int getRewardLevelCap() {
        return this.rewardLevelCap;
    }

    public int getRequiredLevelCap() {
        IServerConfig cfg = RCTMod.getInstance().getServerConfig();
        return Math.max(1, Math.min(100, this.getTrainerTeam().getTeam().stream().map(p -> p.getLevel()).max(Integer::compare).orElse(0) + cfg.additiveLevelCapRequirement()));
    }

    public Stream<String> getMissingRequirements(Set<String> defeatedTrainerIds) {
        return this.getMissingRequirements(defeatedTrainerIds, false);
    }

    public Stream<String> getMissingRequirements(Set<String> defeatedTrainerIds, boolean includeAlternatives) {
        return this.requiredDefeats.stream().mapMulti((set, cons) -> {
            if (includeAlternatives) {
                if (set.stream().noneMatch(defeatedTrainerIds::contains)) {
                    set.stream().forEach(cons);
                }
            } else if (!set.isEmpty()) {
                if (set.stream().noneMatch(defeatedTrainerIds::contains)) {
                    cons.accept((String)set.stream().findFirst().get());
                }
            }
        });
    }

    public int getMaxTrainerWins() {
        return this.maxTrainerWins;
    }

    public int getMaxTrainerDefeats() {
        return this.maxTrainerDefeats;
    }

    public int getBattleCooldownTicks() {
        return this.battleCooldownTicks;
    }

    public float getSpawnWeightFactor() {
        return this.spawnWeightFactor;
    }

    public Set<String> getBiomeTagBlacklist() {
        return Collections.unmodifiableSet(this.biomeTagBlacklist);
    }

    public Set<String> getBiomeTagWhitelist() {
        return Collections.unmodifiableSet(this.biomeTagWhitelist);
    }

    public Set<String> getFollowdBy() {
        return Collections.unmodifiableSet(this.followdBy);
    }

    public boolean addFollowedBy(String trainerId) {
        return this.followdBy.add(trainerId);
    }

    public boolean removeFollowdBy(String trainerId) {
        return this.followdBy.remove(trainerId);
    }

    public void clearFollowedBy(String trainerId) {
        this.followdBy.clear();
    }

    public Map<String, String[]> getDialog() {
        return Collections.unmodifiableMap(this.dialog);
    }

    public class_2960 getTextureResource() {
        return this.textureResource;
    }

    public class_2960 getLootTableResource() {
        return this.lootTableResource;
    }

    public TrainerTeam getTrainerTeam() {
        return this.trainerTeam;
    }

    @Override
    public void onLoad(DataPackManager dpm, String trainerId, String context) {
        Optional<TrainerTeam> trainerTeam;
        Optional<class_2960> lootTableResource = dpm.findResource(trainerId, "loot_table");
        Optional<class_2960> textureResource = dpm.findResource(trainerId, "textures");
        if (textureResource.isPresent()) {
            this.textureResource = textureResource.get();
        }
        if (lootTableResource.isPresent()) {
            this.lootTableResource = class_2960.method_60655((String)"rctmod", (String)lootTableResource.get().method_12832().replace("loot_table/", "").replace(".json", ""));
        }
        dpm.loadResource(trainerId, "dialogs", dialog -> {
            this.dialog = dialog;
        }, new TypeToken<Map<String, String[]>>(this){});
        if (this.dialog == null) {
            this.dialog = new HashMap<String, String[]>();
        }
        if ((trainerTeam = dpm.loadTrainerTeam(trainerId)).isPresent()) {
            this.trainerTeam = trainerTeam.get();
        }
    }

    public static enum Type {
        NORMAL,
        LEADER,
        E4,
        CHAMP,
        TEAM_ROCKET,
        RIVAL;

        private static final Map<Type, String> symbols;
        private static final Map<Type, Integer> colors;

        public String toString() {
            return symbols.getOrDefault((Object)this, "");
        }

        public int toColor() {
            return colors.getOrDefault((Object)this, class_124.field_1068.method_532());
        }

        static {
            symbols = Map.of(LEADER, "[L]", E4, "[E]", CHAMP, "[C]", TEAM_ROCKET, "[T]", RIVAL, "[R]");
            colors = Map.of(LEADER, class_124.field_1060.method_532(), E4, class_124.field_1062.method_532(), CHAMP, class_124.field_1064.method_532(), TEAM_ROCKET, class_124.field_1080.method_532(), RIVAL, class_124.field_1065.method_532());
        }
    }
}

