/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.data.save;

import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.config.IServerConfig;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_7225;

public class TrainerPlayerData
extends class_18 {
    private Set<String> defeatedTrainerIds = new HashSet<String>();
    private class_1657 player;
    private int initialLevelCap;
    private int additiveLevelCapRequirement;
    private int levelCap;

    public TrainerPlayerData(class_1657 player) {
        this.player = player;
    }

    public int getLevelCap() {
        IServerConfig cfg = RCTMod.getInstance().getServerConfig();
        if (RCTMod.getInstance().getTrainerManager().updateRequired(this.player) || cfg.initialLevelCap() != this.initialLevelCap || cfg.additiveLevelCapRequirement() != this.additiveLevelCapRequirement) {
            this.additiveLevelCapRequirement = cfg.additiveLevelCapRequirement();
            this.initialLevelCap = cfg.initialLevelCap();
            this.updateLevelCap();
        }
        return this.levelCap;
    }

    private void updateLevelCap() {
        IServerConfig cfg = RCTMod.getInstance().getServerConfig();
        this.levelCap = Math.max(RCTMod.getInstance().getTrainerManager().getMinRequiredLevelCap(), Math.min(100, cfg.initialLevelCap() + cfg.additiveLevelCapRequirement()));
        this.defeatedTrainerIds.forEach(this::updateLevelCap);
    }

    private void updateLevelCap(String trainerId) {
        TrainerMobData tmd = RCTMod.getInstance().getTrainerManager().getData(trainerId);
        this.levelCap = Math.max(this.levelCap, Math.max(1, Math.min(100, Math.max(tmd.getRequiredLevelCap(), tmd.getRewardLevelCap()))));
    }

    public Set<String> getDefeatedTrainerIds() {
        return Collections.unmodifiableSet(this.defeatedTrainerIds);
    }

    public boolean addProgressDefeat(String trainerId) {
        if (PlayerState.get(this.player).isKeyTrainer(trainerId) && this.defeatedTrainerIds.add(trainerId)) {
            PlayerState ps = PlayerState.get(this.player);
            this.updateLevelCap(trainerId);
            ps.addProgressDefeat(trainerId);
            this.method_80();
            return true;
        }
        return false;
    }

    public boolean removeProgressDefeat(String trainerId) {
        if (this.defeatedTrainerIds.remove(trainerId)) {
            PlayerState ps = PlayerState.get(this.player);
            this.updateLevelCap();
            ps.removeProgressDefeat(trainerId);
            this.method_80();
            return true;
        }
        return false;
    }

    public boolean removeProgressDefeats() {
        if (this.defeatedTrainerIds.size() > 0) {
            PlayerState ps = PlayerState.get(this.player);
            this.defeatedTrainerIds.clear();
            this.updateLevelCap();
            ps.removeProgressDefeats();
            this.method_80();
            return true;
        }
        return false;
    }

    public class_2487 method_75(class_2487 compoundTag, class_7225.class_7874 provider) {
        byte b = 0;
        class_2487 progressDefeats = new class_2487();
        this.defeatedTrainerIds.forEach(tid -> progressDefeats.method_10567(tid, b));
        compoundTag.method_10566("progressDefeats", (class_2520)progressDefeats);
        return compoundTag;
    }

    public static String filePath(class_1657 player) {
        return String.format("%s.player.%s.stat", "rctmod", player.method_5667().toString());
    }

    public static class Builder {
        private class_1657 player;

        public Builder(class_1657 player) {
            this.player = player;
        }

        public TrainerPlayerData create() {
            TrainerPlayerData tpd = new TrainerPlayerData(this.player);
            tpd.updateLevelCap();
            return tpd;
        }

        public TrainerPlayerData of(class_2487 tag, class_7225.class_7874 provider) {
            TrainerPlayerData tpd = new TrainerPlayerData(this.player);
            if (tag.method_10545("progressDefeats")) {
                TrainerManager tm = RCTMod.getInstance().getTrainerManager();
                tpd.defeatedTrainerIds.addAll(tag.method_10562("progressDefeats").method_10541().stream().filter(tid -> !tm.getData((String)tid).getFollowdBy().isEmpty()).toList());
            } else {
                TrainerManager tm = RCTMod.getInstance().getTrainerManager();
                class_3218 level = this.player.method_5682().method_30002();
                tm.getAllData().filter(entry -> !((TrainerMobData)entry.getValue()).getFollowdBy().isEmpty()).map(entry -> (String)entry.getKey()).filter(tid -> tm.getBattleMemory(level, (String)tid).getDefeatByCount(this.player) > 0).forEach(tpd.defeatedTrainerIds::add);
            }
            tpd.updateLevelCap();
            return tpd;
        }
    }
}

