/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.data.sync;

import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.api.data.save.TrainerPlayerData;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3218;

public class PlayerState
implements Serializable {
    public static final int SYNC_INTERVAL_TICKS = 60;
    private static final long serialVersionUID = 0L;
    private static final Map<UUID, PlayerState> remoteStates = new HashMap<UUID, PlayerState>();
    private static PlayerState localState;
    private Map<String, Integer> trainerDefeatCounts = new HashMap<String, Integer>();
    private Map<TrainerMobData.Type, Integer> typeDefeatCounts = new HashMap<TrainerMobData.Type, Integer>();
    private Set<String> defeatedTrainerIds = new HashSet<String>();
    private Set<String> removedDefeatedTrainerIds = new HashSet<String>();
    private int levelCap;
    private transient class_1657 player;
    private transient PlayerState updated;
    private transient boolean hasChanges = true;
    private transient Map<TrainerMobData.Type, Integer> distinctTypeDefeatCounts = new HashMap<TrainerMobData.Type, Integer>();

    public static PlayerState get(class_1657 player) {
        return PlayerState.get(player, false);
    }

    public static PlayerState get(class_1657 player, boolean forceNew) {
        class_1937 level = player.method_37908();
        if (level.field_9236) {
            if (player.method_7340()) {
                if (forceNew || localState == null || !PlayerState.localState.player.equals((Object)player)) {
                    localState = new PlayerState(player);
                } else {
                    PlayerState.localState.player = player;
                }
                return localState;
            }
            throw new IllegalArgumentException("Cannot retrieve player state of other players on this client");
        }
        return remoteStates.compute(player.method_5667(), (key, ps) -> forceNew || ps == null || ps.player != player ? new PlayerState(player) : ps);
    }

    public byte[] serializeUpdate() {
        byte[] byArray;
        if (!this.hasChanges) {
            return new byte[0];
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(buf);
        try {
            oos.writeObject(this.updated);
            this.updated = new PlayerState(this);
            this.hasChanges = false;
            byArray = buf.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    oos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        oos.close();
        return byArray;
    }

    public void deserializeUpdate(byte[] bytes) {
        ByteArrayInputStream buf = new ByteArrayInputStream(bytes);
        try (ObjectInputStream ois = new ObjectInputStream(buf);){
            this.update((PlayerState)ois.readObject());
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private void setLevelCap(int levelCap) {
        if (this.levelCap != levelCap) {
            this.levelCap = levelCap;
            this.updated.levelCap = levelCap;
            this.hasChanges = true;
        }
    }

    public int getLevelCap() {
        if (!this.player.method_37908().field_9236) {
            this.setLevelCap(RCTMod.getInstance().getTrainerManager().getData(this.player).getLevelCap());
        }
        return this.levelCap;
    }

    public void addProgressDefeat(String trainerId) {
        if (this.defeatedTrainerIds.add(trainerId)) {
            this.updated.defeatedTrainerIds.add(trainerId);
            this.updated.removedDefeatedTrainerIds.remove(trainerId);
            this.hasChanges = true;
        }
    }

    public void removeProgressDefeat(String trainerId) {
        if (this.defeatedTrainerIds.remove(trainerId)) {
            this.updated.removedDefeatedTrainerIds.add(trainerId);
            this.updated.defeatedTrainerIds.remove(trainerId);
            this.hasChanges = true;
        }
    }

    public void removeProgressDefeats() {
        if (this.defeatedTrainerIds.size() > 0) {
            this.updated.removedDefeatedTrainerIds.addAll(this.defeatedTrainerIds);
            this.updated.defeatedTrainerIds.clear();
            this.defeatedTrainerIds.clear();
            this.hasChanges = true;
        }
    }

    public void addDefeat(String trainerId) {
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        TrainerMobData.Type tt = tm.getData(trainerId).getType();
        if (!this.trainerDefeatCounts.containsKey(trainerId)) {
            this.trainerDefeatCounts.put(trainerId, 1);
            this.updated.trainerDefeatCounts.put(trainerId, 1);
            this.distinctTypeDefeatCounts.compute(tt, (k, v) -> v == null ? 1 : v + 1);
        } else {
            this.updated.trainerDefeatCounts.put(trainerId, this.trainerDefeatCounts.compute(trainerId, (k, v) -> v == Integer.MAX_VALUE ? v : v + 1));
        }
        this.updated.typeDefeatCounts.put(tt, this.typeDefeatCounts.compute(tt, (k, v) -> v == null ? 1 : (v == Integer.MAX_VALUE ? v : v + 1)));
        this.hasChanges = true;
    }

    public void setDefeats(String trainerId, int defeats) {
        Integer currentDefeats = this.trainerDefeatCounts.computeIfAbsent(trainerId, key -> 0);
        if (defeats != currentDefeats) {
            TrainerManager tm = RCTMod.getInstance().getTrainerManager();
            TrainerMobData.Type tt = tm.getData(trainerId).getType();
            Integer typeDefeats = this.typeDefeatCounts.computeIfAbsent(tt, key -> 0);
            int newTypeDefeats = typeDefeats + (defeats - currentDefeats);
            if (newTypeDefeats == 0) {
                this.typeDefeatCounts.remove((Object)tt);
            } else {
                this.typeDefeatCounts.put(tt, newTypeDefeats);
            }
            if (defeats == 0) {
                this.trainerDefeatCounts.remove(trainerId);
                this.distinctTypeDefeatCounts.compute(tt, (k, v) -> v - 1);
            } else {
                this.trainerDefeatCounts.put(trainerId, defeats);
                if (currentDefeats == 0) {
                    this.distinctTypeDefeatCounts.compute(tt, (k, v) -> v == null ? 1 : v + 1);
                }
            }
            this.updated.trainerDefeatCounts.put(trainerId, defeats);
            this.updated.typeDefeatCounts.put(tt, newTypeDefeats);
            this.hasChanges = true;
        }
    }

    public long getTypeDefeatCount(TrainerMobData.Type type) {
        return this.getTypeDefeatCount(type, false);
    }

    public long getTypeDefeatCount(TrainerMobData.Type type, boolean distinct) {
        Integer count = distinct ? this.distinctTypeDefeatCounts.get((Object)type) : this.typeDefeatCounts.get((Object)type);
        return count == null ? 0L : (long)count.intValue();
    }

    public int getTrainerDefeatCount(String trainerId) {
        Integer count = this.trainerDefeatCounts.get(trainerId);
        return count == null ? 0 : count;
    }

    public long getTrainerDefeatCount() {
        return this.getTrainerDefeatCount(false);
    }

    public long getTrainerDefeatCount(boolean distinct) {
        if (distinct) {
            return this.trainerDefeatCounts.size();
        }
        return this.typeDefeatCounts.values().stream().mapToLong(i -> i.intValue()).reduce(0L, (i, j) -> i + j);
    }

    public boolean isKeyTrainer(String trainerId) {
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        TrainerMobData tmd = RCTMod.getInstance().getTrainerManager().getData(trainerId);
        return tmd != null && tmd.getFollowdBy().size() > 0 && tmd.getMissingRequirements(this.defeatedTrainerIds).findFirst().isEmpty() && tmd.getFollowdBy().stream().anyMatch(sid -> tm.getData((String)sid).getMissingRequirements(this.defeatedTrainerIds, true).anyMatch(rid -> trainerId.equals(rid)));
    }

    public boolean canBattle(String trainerId) {
        TrainerMobData tmd = RCTMod.getInstance().getTrainerManager().getData(trainerId);
        return this.getLevelCap() >= tmd.getRequiredLevelCap() && tmd.getMissingRequirements(this.defeatedTrainerIds).findFirst().isEmpty();
    }

    protected Map<String, Integer> getTrainerDefeatCounts() {
        return Collections.unmodifiableMap(this.trainerDefeatCounts);
    }

    protected Map<TrainerMobData.Type, Integer> getTypeDefeatCounts() {
        return Collections.unmodifiableMap(this.typeDefeatCounts);
    }

    private PlayerState(class_1657 player) {
        this.player = player;
        this.init();
        this.updated = this;
    }

    private PlayerState(PlayerState template) {
        this.levelCap = template.levelCap;
    }

    private void update(PlayerState updated) {
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        updated.trainerDefeatCounts.forEach((trainerId, count) -> {
            TrainerMobData.Type tt = tm.getData((String)trainerId).getType();
            if (count == 0) {
                if (this.trainerDefeatCounts.remove(trainerId) != null) {
                    this.distinctTypeDefeatCounts.compute(tt, (k, v) -> v - 1);
                }
            } else if (this.trainerDefeatCounts.put((String)trainerId, (Integer)count) == null) {
                this.distinctTypeDefeatCounts.compute(tt, (k, v) -> v == null ? 1 : v + 1);
            }
        });
        updated.typeDefeatCounts.forEach((type, count) -> {
            if (count == 0) {
                this.typeDefeatCounts.remove(type);
            } else {
                this.typeDefeatCounts.put((TrainerMobData.Type)((Object)type), (Integer)count);
            }
        });
        updated.defeatedTrainerIds.forEach(this.defeatedTrainerIds::add);
        updated.removedDefeatedTrainerIds.forEach(this.defeatedTrainerIds::remove);
        this.levelCap = updated.levelCap;
    }

    private void init() {
        this.trainerDefeatCounts.clear();
        this.typeDefeatCounts.clear();
        this.distinctTypeDefeatCounts.clear();
        this.defeatedTrainerIds.clear();
        this.removedDefeatedTrainerIds.clear();
        class_1937 level = this.player.method_37908();
        if (!level.field_9236) {
            TrainerManager tm = RCTMod.getInstance().getTrainerManager();
            class_3218 overworld = this.player.method_5682().method_30002();
            TrainerPlayerData tpd = tm.getData(this.player);
            this.levelCap = tpd.getLevelCap();
            this.defeatedTrainerIds.addAll(tpd.getDefeatedTrainerIds());
            tm.getAllData().forEach(entry -> {
                int defCount = tm.getBattleMemory(overworld, (String)entry.getKey()).getDefeatByCount(this.player);
                if (defCount > 0) {
                    TrainerMobData.Type tt = ((TrainerMobData)entry.getValue()).getType();
                    this.trainerDefeatCounts.put((String)entry.getKey(), defCount);
                    this.typeDefeatCounts.compute(tt, (k, v) -> v == null ? defCount : v + defCount);
                    this.distinctTypeDefeatCounts.compute(tt, (k, v) -> v == null ? 1 : v + 1);
                }
            });
        }
    }
}

