/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.service;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.gitlab.srcmc.rctapi.api.battle.BattleManager;
import com.gitlab.srcmc.rctapi.api.errors.RCTException;
import com.gitlab.srcmc.rctapi.api.models.TrainerModel;
import com.gitlab.srcmc.rctapi.api.trainer.Trainer;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerNPC;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerRegistry;
import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.TrainerBattle;
import com.gitlab.srcmc.rctmod.api.data.pack.DataPackManager;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.api.data.save.TrainerBattleMemory;
import com.gitlab.srcmc.rctmod.api.data.save.TrainerPlayerData;
import com.gitlab.srcmc.rctmod.api.utils.PathUtils;
import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4284;
import net.minecraft.server.MinecraftServer;

public class TrainerManager
extends DataPackManager {
    private Map<String, TrainerMobData> trainerMobs = new HashMap<String, TrainerMobData>();
    private Map<UUID, TrainerBattle> trainerBattles = new HashMap<UUID, TrainerBattle>();
    private Map<UUID, String> uuidToTrainerId = new HashMap<UUID, String>();
    private Set<String> playerTrainerIds = new HashSet<String>();
    private Set<class_1657> receivedUpdates = new HashSet<class_1657>();
    private MinecraftServer server;
    private class_3300 resourceManager;
    private boolean reloadRequired;
    private int minRequiredLevelCap;

    public TrainerManager() {
        super(class_3264.field_14190);
    }

    public void setServer(MinecraftServer server) {
        if (server != null) {
            BattleManager bm = ModCommon.RCT.getBattleManager();
            bm.getStates().stream().toList().forEach(bs -> bm.end(bs.getBattle().getBattleId(), true));
            ModCommon.RCT.getTrainerRegistry().init(server);
            this.resourceManager = server.method_34864();
            this.server = server;
            this.reloadRequired = true;
        }
    }

    public boolean isReloadRequired() {
        return this.reloadRequired;
    }

    public void setReloadRequired() {
        this.reloadRequired = true;
    }

    private boolean isServerRunning() {
        return this.server != null && this.server.method_3806() && this.server.method_18854();
    }

    private void registerTrainer(String trainerId, TrainerMobData tmd, Map<String, Trainer> oldTrainers) {
        if (this.isServerRunning()) {
            TrainerRegistry reg = ModCommon.RCT.getTrainerRegistry();
            try {
                TrainerNPC newTrainer = reg.registerNPC(trainerId, (TrainerModel)tmd.getTrainerTeam());
                Trainer oldTrainer = oldTrainers.get(trainerId);
                if (oldTrainer != null) {
                    newTrainer.setEntity(oldTrainer.getEntity());
                }
            }
            catch (RCTException errors) {
                ModCommon.LOG.error("Model validation failure for '" + trainerId + "'");
                errors.getErrors().forEach(error -> ModCommon.LOG.error(error.message));
            }
            catch (Exception e) {
                ModCommon.LOG.error("Failed to register trainer '" + trainerId + "'", (Throwable)e);
            }
        }
    }

    public String registerPlayer(class_1657 player) {
        String trainerId = this.uuidToTrainerId.get(player.method_5667());
        if (trainerId == null) {
            String name;
            int attempt = 0;
            trainerId = name = player.method_5477().getString().replace(' ', '_');
            while (this.playerTrainerIds.contains(trainerId)) {
                trainerId = String.format("%s_%d", name, ++attempt);
            }
            this.uuidToTrainerId.put(player.method_5667(), trainerId);
            this.playerTrainerIds.add(trainerId);
        }
        return trainerId;
    }

    public String unregisterPlayer(class_1657 player) {
        String trainerId = this.uuidToTrainerId.remove(player.method_5667());
        if (trainerId != null) {
            this.playerTrainerIds.remove(trainerId);
        }
        return trainerId;
    }

    public String getTrainerId(class_1657 player) {
        if (!this.uuidToTrainerId.containsKey(player.method_5667())) {
            this.registerPlayer(player);
        }
        return this.uuidToTrainerId.get(player.method_5667());
    }

    public void addBattle(class_1657 initiator, TrainerMob opponent) {
        this.trainerBattles.put(initiator.method_5667(), new TrainerBattle(initiator, opponent));
    }

    public void addBattle(class_1657[] initiatorSidePlayers, TrainerMob[] initiatorSideMobs, class_1657[] trainerSidePlayers, TrainerMob[] trainerSideMobs) {
        TrainerBattle battle = new TrainerBattle(initiatorSidePlayers, initiatorSideMobs, trainerSidePlayers, trainerSideMobs);
        this.trainerBattles.put(battle.getInitiator().method_5667(), battle);
    }

    public Optional<TrainerBattle> getBattle(UUID initiatorId) {
        return this.trainerBattles.containsKey(initiatorId) ? Optional.of(this.trainerBattles.get(initiatorId)) : Optional.empty();
    }

    public boolean removeBattle(UUID initiatorId) {
        return this.trainerBattles.remove(initiatorId) != null;
    }

    public TrainerMobData getData(TrainerMob mob) {
        return this.getData(mob.getTrainerId());
    }

    public TrainerMobData getData(String trainerId) {
        if (!this.trainerMobs.containsKey(trainerId)) {
            return new TrainerMobData();
        }
        return this.trainerMobs.get(trainerId);
    }

    public boolean isValidId(String trainerId) {
        return this.trainerMobs.containsKey(trainerId);
    }

    public int getPlayerLevel(class_1657 player) {
        int maxLevel = 0;
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            for (Pokemon pk : Cobblemon.INSTANCE.getStorage().getParty(serverPlayer)) {
                maxLevel = Math.max(maxLevel, pk.getLevel());
            }
        }
        return maxLevel;
    }

    public int getActivePokemon(class_1657 player) {
        int count = 0;
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            for (Pokemon pk : Cobblemon.INSTANCE.getStorage().getParty(serverPlayer)) {
                if (pk.isFainted()) continue;
                ++count;
            }
        }
        return count;
    }

    public TrainerPlayerData getData(class_1657 player) {
        TrainerPlayerData.Builder builder = new TrainerPlayerData.Builder(player);
        return (TrainerPlayerData)player.method_5682().method_30002().method_17983().method_17924(new class_18.class_8645(builder::create, builder::of, class_4284.field_19212), TrainerPlayerData.filePath(player));
    }

    public Stream<Map.Entry<String, TrainerMobData>> getAllData() {
        return this.trainerMobs.entrySet().stream();
    }

    public TrainerBattleMemory getBattleMemory(TrainerMob mob) {
        return this.getBattleMemory(mob.method_5682().method_30002(), mob.getTrainerId());
    }

    public TrainerBattleMemory getBattleMemory(class_3218 level, String trainerId) {
        return (TrainerBattleMemory)level.method_8503().method_30002().method_17983().method_17924(new class_18.class_8645(TrainerBattleMemory::new, TrainerBattleMemory::of, class_4284.field_19212), TrainerBattleMemory.filePath(trainerId));
    }

    public boolean updateRequired(class_1657 player) {
        return this.receivedUpdates.add(player);
    }

    public int getMinRequiredLevelCap() {
        return this.minRequiredLevelCap;
    }

    public void loadTrainers() {
        this.forceReload(this.resourceManager);
    }

    protected void forceReload(class_3300 resourceManager) {
        this.reloadRequired = false;
        DataPackManager dpm = RCTMod.getInstance().getServerDataManager();
        dpm.init(resourceManager);
        HashMap oldTrainers = new HashMap();
        HashMap<String, TrainerMobData> newTrainerMobs = new HashMap<String, TrainerMobData>();
        if (this.isServerRunning()) {
            TrainerRegistry reg = ModCommon.RCT.getTrainerRegistry();
            reg.getIds().stream().map(tid -> Map.entry(tid, reg.getById(tid))).filter(entry -> entry.getValue() instanceof TrainerNPC).forEach(entry -> oldTrainers.put((String)entry.getKey(), (Trainer)entry.getValue()));
            reg.clearNPCs();
        }
        dpm.listTrainerTeams((rl, io) -> {
            String trainerId = PathUtils.filename(rl.method_12832());
            dpm.loadResource(trainerId, "mobs", (T tmd) -> {
                newTrainerMobs.put(trainerId, (TrainerMobData)tmd);
                this.registerTrainer(trainerId, (TrainerMobData)tmd, oldTrainers);
            }, TrainerMobData.class);
        });
        newTrainerMobs.forEach((trainerId, tmd) -> tmd.getMissingRequirements(Set.of(), true).forEach(tid -> {
            TrainerMobData tmd2 = (TrainerMobData)newTrainerMobs.get(tid);
            if (tmd2 != null) {
                tmd2.addFollowedBy((String)trainerId);
            }
        }));
        int[] mrlvlcap = new int[]{100};
        newTrainerMobs.values().forEach(tmd -> {
            tmd.setRewardLevelCap(tmd.getFollowdBy().stream().map(tid -> {
                TrainerMobData tm = (TrainerMobData)newTrainerMobs.get(tid);
                Integer tl = tm.getTrainerTeam().getTeam().stream().map(p -> p.getLevel()).max(Integer::compare).orElse(0);
                return tl == 100 ? tl.intValue() : tm.getRequiredLevelCap();
            }).max(Integer::compare).orElse(tmd.getRequiredLevelCap()));
            if (!tmd.getFollowdBy().isEmpty()) {
                mrlvlcap[0] = Math.min(mrlvlcap[0], tmd.getRequiredLevelCap());
            }
        });
        this.trainerMobs = newTrainerMobs;
        if (this.isServerRunning()) {
            ModCommon.LOG.info(String.format("Registered %d trainers", this.trainerMobs.size()));
        }
        dpm.close();
        this.minRequiredLevelCap = mrlvlcap[0];
        this.receivedUpdates = new HashSet<class_1657>();
    }

    @Override
    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profilerFiller) {
        this.resourceManager = resourceManager;
        super.apply(object, resourceManager, profilerFiller);
        this.setReloadRequired();
    }
}

