/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.service;

import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.config.IServerConfig;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.api.data.save.collection.SavedMap;
import com.gitlab.srcmc.rctmod.api.data.save.collection.SavedStringChunkPosMap;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4284;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;

public class TrainerSpawner {
    private static float KEY_TRAINER_SPAWN_WEIGHT_FACTOR = 64.0f;
    private static float NON_KEY_TRAINER_SPAWN_CHANCE_DIV = 4.0f;
    private static final int SPAWN_RETRIES = 8;
    private static final boolean CAN_SPAWN_IN_WATER = false;
    private static final double TRAINER_DIRECT_SPAWN_CHANCE = 0.42;
    private Map<String, Integer> spawns = new HashMap<String, Integer>();
    private Map<String, Integer> identities = new HashMap<String, Integer>();
    private Map<String, Integer> playerSpawns = new HashMap<String, Integer>();
    private Map<String, class_1923> persistentChunks;
    private Set<TrainerMob> mobs = new HashSet<TrainerMob>();
    private Set<TrainerMob> persistentMobs = new HashSet<TrainerMob>();

    public void init(class_3218 level) {
        this.spawns.clear();
        this.identities.clear();
        this.playerSpawns.clear();
        this.persistentMobs.clear();
        this.mobs.clear();
        this.persistentChunks = (Map)level.method_17983().method_17924(new class_18.class_8645(SavedStringChunkPosMap::new, SavedStringChunkPosMap::of, class_4284.field_19212), SavedMap.filePath("spawn.chunks"));
        MinecraftServer server = level.method_8503();
        this.persistentChunks.values().forEach(cp -> server.method_3738().forEach(l -> l.method_14178().method_12124(cp, true)));
        if (RCTMod.getInstance().getServerConfig().logSpawning()) {
            ModCommon.LOG.info("Initialized Trainer Spawner service");
        }
    }

    public Set<TrainerMob> getSpawns() {
        return Sets.union(this.mobs, this.persistentMobs);
    }

    public void checkDespawns() {
        Iterator<TrainerMob> it = this.mobs.iterator();
        while (it.hasNext()) {
            TrainerMob mob = it.next();
            if (mob.method_31481() || mob.method_5947()) {
                it.remove();
                continue;
            }
            if (!mob.shouldDespawn()) continue;
            mob.method_5650(class_1297.class_5529.field_27000);
            it.remove();
        }
    }

    public void register(TrainerMob mob) {
        String identity = RCTMod.getInstance().getTrainerManager().getData(mob).getTrainerTeam().getIdentity();
        if (mob.method_5947()) {
            this.persistentChunks.put(mob.method_5845(), mob.method_31476());
            this.persistentMobs.add(mob);
        }
        if (!this.spawns.containsKey(mob.method_5845())) {
            IServerConfig config;
            UUID originPlayer = mob.getOriginPlayer();
            if (originPlayer != null) {
                this.playerSpawns.compute(originPlayer.toString(), (key, value) -> value == null ? 1 : value + 1);
            }
            this.identities.compute(identity, (key, value) -> value == null ? 1 : value + 1);
            this.spawns.put(mob.method_5845(), 0);
            if (!mob.method_5947()) {
                this.mobs.add(mob);
            }
            if ((config = RCTMod.getInstance().getServerConfig()).logSpawning()) {
                ModCommon.LOG.info(String.format("Registered%strainer '%s' (%s) to spawner, attached to %s (%d/%d), (%d/%d)", mob.method_5947() ? " persistent " : " ", mob.getTrainerId(), mob.method_5845(), originPlayer, this.getSpawnCount(originPlayer), config.maxTrainersPerPlayer(), this.getSpawnCount(), config.maxTrainersTotal()));
            }
        }
    }

    public void unregister(TrainerMob mob) {
        if (this.spawns.containsKey(mob.method_5845())) {
            IServerConfig config;
            String identity = RCTMod.getInstance().getTrainerManager().getData(mob).getTrainerTeam().getIdentity();
            UUID originPlayer = mob.getOriginPlayer();
            if (originPlayer != null) {
                this.playerSpawns.compute(originPlayer.toString(), (key, value) -> value == null || value <= 1 ? null : Integer.valueOf(value - 1));
            }
            this.identities.compute(identity, (key, value) -> value == null || value <= 1 ? null : Integer.valueOf(value - 1));
            this.spawns.remove(mob.method_5845());
            if (mob.method_5947()) {
                this.persistentChunks.remove(mob.method_5845());
                this.persistentMobs.remove((Object)mob);
            }
            if ((config = RCTMod.getInstance().getServerConfig()).logSpawning()) {
                ModCommon.LOG.info(String.format("Unregistered%strainer '%s' (%s) from spawner, attached to %s (%d/%d), (%d/%d)", mob.method_5947() ? " persistent " : " ", mob.getTrainerId(), mob.method_5845(), originPlayer, this.getSpawnCount(originPlayer), config.maxTrainersPerPlayer(), this.getSpawnCount(), config.maxTrainersTotal()));
            }
        }
    }

    public void unregisterPersistent(String mobUUID) {
        for (TrainerMob m : this.persistentMobs) {
            if (!m.method_5845().equals(mobUUID)) continue;
            m.setPersistent(false);
            return;
        }
    }

    public boolean isRegistered(TrainerMob mob) {
        return this.spawns.containsKey(mob.method_5845());
    }

    public void notifyChangeTrainerId(TrainerMob mob, String newTrainerId) {
        if (this.spawns.containsKey(mob.method_5845())) {
            ModCommon.LOG.info(String.format("Changing trainer id '%s' -> '%s' (%s)", mob.getTrainerId(), newTrainerId, mob.method_5845()));
            String identity = RCTMod.getInstance().getTrainerManager().getData(mob).getTrainerTeam().getIdentity();
            String newIdentity = RCTMod.getInstance().getTrainerManager().getData(newTrainerId).getTrainerTeam().getIdentity();
            this.identities.compute(identity, (key, value) -> value == null || value <= 1 ? null : Integer.valueOf(value - 1));
            this.identities.compute(newIdentity, (key, value) -> value == null ? 1 : value + 1);
        }
    }

    public void notifyChangeOriginPlayer(TrainerMob mob, UUID newOriginPlayer) {
        if (this.spawns.containsKey(mob.method_5845())) {
            UUID originPlayer = mob.getOriginPlayer();
            if (originPlayer != null) {
                this.playerSpawns.compute(originPlayer.toString(), (key, value) -> value == null || value <= 1 ? null : Integer.valueOf(value - 1));
            }
            if (newOriginPlayer != null) {
                this.playerSpawns.compute(newOriginPlayer.toString(), (key, value) -> value == null ? 1 : value + 1);
            }
            if (RCTMod.getInstance().getServerConfig().logSpawning()) {
                ModCommon.LOG.info(String.format("Changed origin player for '%s': '%s' -> '%s'", mob.getTrainerId(), String.valueOf(originPlayer), String.valueOf(newOriginPlayer)));
            }
        }
    }

    public void notifyChangePersistence(TrainerMob mob, boolean newPersistence) {
        if (this.spawns.containsKey(mob.method_5845())) {
            this.unregister(mob);
            mob.setPersistent(newPersistence, true);
            this.register(mob);
        }
    }

    public int getSpawnCount() {
        return this.getSpawnCount(false);
    }

    public int getSpawnCount(boolean includePersistent) {
        return this.spawns.size() - (includePersistent ? 0 : this.persistentMobs.size());
    }

    public int getSpawnCount(UUID playerId) {
        if (playerId != null) {
            return this.playerSpawns.getOrDefault(playerId.toString(), 0);
        }
        return 0;
    }

    public boolean attemptSpawnFor(class_1657 player, String trainerId, class_2338 pos) {
        return this.attemptSpawnFor(player, trainerId, pos, false, false);
    }

    public boolean attemptSpawnFor(class_1657 player, String trainerId, class_2338 pos, boolean setHome, boolean noOrigin) {
        IServerConfig cfg = RCTMod.getInstance().getServerConfig();
        return this.attemptSpawnFor(player, trainerId, pos, setHome, noOrigin, cfg.globalSpawnChance(), cfg.globalSpawnChanceMinimum());
    }

    public boolean attemptSpawnFor(class_1657 player, String trainerId, class_2338 pos, boolean setHome, boolean noOrigin, double globalChance, double globalChanceMin) {
        TrainerMobData tmd;
        class_1937 level = player.method_37908();
        if (RCTMod.getInstance().getTrainerManager().isValidId(trainerId) && TrainerSpawner.canSpawnAt(level, pos) && this.canSpawnFor(player, noOrigin, globalChance, globalChanceMin) && (tmd = RCTMod.getInstance().getTrainerManager().getData(trainerId)) != null && this.isUnique(tmd.getTrainerTeam().getIdentity()) && this.computeChance(player, trainerId, tmd) >= player.method_59922().method_43058()) {
            this.spawnFor(player, trainerId, pos, setHome, noOrigin);
            return true;
        }
        return false;
    }

    public boolean attemptSpawnFor(class_1657 player) {
        IServerConfig cfg = RCTMod.getInstance().getServerConfig();
        if (this.canSpawnFor(player, false, cfg.globalSpawnChance(), cfg.globalSpawnChanceMinimum())) {
            for (int i = 0; i < 8; ++i) {
                class_2338 pos = this.nextPos(player);
                if (pos == null) continue;
                SpawnCandidate spawnCandidate = this.nextSpawnCandidate(player, pos);
                if (spawnCandidate != null) {
                    this.spawnFor(player, spawnCandidate.id, pos);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean canSpawnAt(class_1937 level, class_2338 blockPos) {
        return !level.method_8320(blockPos.method_10074()).method_26215() && level.method_8320(blockPos).method_26215() && level.method_8320(blockPos.method_10084()).method_26215();
    }

    private boolean isUnique(String identity) {
        return !this.identities.containsKey(identity);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canSpawnFor(class_1657 player, boolean noOrigin, double globalChance, double globalChanceMin) {
        IServerConfig config = RCTMod.getInstance().getServerConfig();
        int spawnCountPl = this.getSpawnCount(player.method_5667());
        int maxCountPl = config.maxTrainersPerPlayer();
        double chanceRange = Math.max(0.0, globalChance - globalChanceMin);
        if (this.getSpawnCount() >= config.maxTrainersTotal()) return false;
        if (RCTMod.getInstance().getTrainerManager().getPlayerLevel(player) <= 0) return false;
        if (noOrigin) return true;
        if (spawnCountPl >= maxCountPl) return false;
        double d = maxCountPl > 1 ? Math.min(1.0, (double)spawnCountPl / (double)maxCountPl) : 1.0;
        if (!(globalChance - chanceRange * d >= (double)player.method_59922().method_43057())) return false;
        return true;
    }

    private void spawnFor(class_1657 player, String trainerId, class_2338 pos) {
        this.spawnFor(player, trainerId, pos, false, false);
    }

    private void spawnFor(class_1657 player, String trainerId, class_2338 pos, boolean setHome, boolean noOrigin) {
        IServerConfig config = RCTMod.getInstance().getServerConfig();
        class_1937 level = player.method_37908();
        TrainerMob mob = (TrainerMob)TrainerMob.getEntityType().method_5883(level);
        mob.method_33574(pos.method_46558().method_1031(0.0, -0.5, 0.0));
        mob.setTrainerId(trainerId);
        if (!noOrigin) {
            mob.setOriginPlayer(player.method_5667());
        }
        level.method_8649((class_1297)mob);
        this.register(mob);
        if (setHome) {
            mob.setHomePos(pos);
        }
        if (config.logSpawning()) {
            String trainer = RCTMod.getInstance().getTrainerManager().getData(trainerId).getTrainerTeam().getName();
            class_6880 biome = level.method_23753(mob.method_24515());
            class_5321 dim = level.method_27983();
            ModCommon.LOG.info(String.format("Spawned trainer '%s' (%s) at (%d, %d, %d), %s:%s", trainer, mob.getTrainerId(), mob.method_24515().method_10263(), mob.method_24515().method_10264(), mob.method_24515().method_10260(), dim.method_29177().method_12832(), biome.method_40228().map(t -> t.comp_327().method_12832()).reduce("", (t1, t2) -> t1 + " " + t2)));
        }
    }

    private class_2338 nextPos(class_1657 player) {
        IServerConfig config = RCTMod.getInstance().getServerConfig();
        class_1937 level = player.method_37908();
        class_5819 rng = player.method_59922();
        int d = config.maxHorizontalDistanceToPlayers() - config.minHorizontalDistanceToPlayers();
        int dx = (config.minHorizontalDistanceToPlayers() + Math.abs(rng.method_43054()) % d) * (rng.method_43056() ? -1 : 1);
        int dz = (config.minHorizontalDistanceToPlayers() + Math.abs(rng.method_43054()) % d) * (rng.method_43056() ? -1 : 1);
        int dy = rng.method_43056() ? config.maxVerticalDistanceToPlayers() : -config.maxVerticalDistanceToPlayers();
        int x = player.method_31477() + dx;
        int z = player.method_31479() + dz;
        int y = player.method_31478();
        int yEnd = dy > 0 ? -(dy + 1) : -(dy - 1);
        int yAdd = dy > 0 ? -1 : 1;
        int prevState = -1;
        int validCount = 0;
        for (int i = dy; i != yEnd; i += yAdd) {
            class_2338 pos = new class_2338(x, y + i, z);
            class_2680 bs = level.method_8320(pos);
            if (bs.method_27852(class_2246.field_10477)) {
                validCount = dy < 0 ? (prevState == 3 ? 1 : 0) : (prevState == 0 ? ++validCount : 0);
                prevState = 2;
            } else if (bs.method_26206((class_1922)level, pos, class_2350.field_11036)) {
                validCount = dy < 0 ? 1 : (prevState == 0 || prevState == 1 ? ++validCount : 0);
                prevState = 3;
            } else if (bs.method_26215()) {
                if (dy < 0) {
                    if (validCount > 0) {
                        ++validCount;
                    }
                } else {
                    validCount = Math.min(2, validCount + 1);
                }
                prevState = 0;
            } else {
                prevState = -1;
                validCount = 0;
            }
            if (validCount <= 2) continue;
            return dy < 0 ? pos.method_10074() : pos.method_10084();
        }
        return null;
    }

    private SpawnCandidate nextSpawnCandidate(class_1657 player, class_2338 pos) {
        ArrayList<SpawnCandidate> candidates;
        block2: {
            Set tags;
            block3: {
                boolean dimensionWhitelisted;
                candidates = new ArrayList<SpawnCandidate>();
                class_1937 level = player.method_37908();
                tags = level.method_23753(pos).method_40228().map(t -> t.comp_327().method_12836() + ":" + t.comp_327().method_12832()).collect(Collectors.toSet());
                level.method_23753(pos).method_40228().map(t -> t.comp_327().method_12832()).forEach(t -> tags.add(t));
                IServerConfig config = RCTMod.getInstance().getServerConfig();
                boolean dimensionBlacklisted = config.dimensionBlacklist().contains(level.method_27983().method_29177().toString());
                boolean bl = dimensionWhitelisted = config.dimensionWhitelist().isEmpty() || config.dimensionWhitelist().contains(level.method_27983().method_29177().toString());
                if (dimensionBlacklisted || !dimensionWhitelisted) break block2;
                if (!config.biomeTagBlacklist().stream().noneMatch(tags::contains)) break block2;
                if (config.biomeTagWhitelist().isEmpty()) break block3;
                if (!config.biomeTagWhitelist().stream().anyMatch(tags::contains)) break block2;
            }
            RCTMod.getInstance().getTrainerManager().getAllData().filter(e -> {
                if (!this.isUnique(((TrainerMobData)e.getValue()).getTrainerTeam().getIdentity())) return false;
                if (!((TrainerMobData)e.getValue()).getBiomeTagBlacklist().stream().noneMatch(tags::contains)) return false;
                if (((TrainerMobData)e.getValue()).getBiomeTagWhitelist().isEmpty()) return true;
                if (!((TrainerMobData)e.getValue()).getBiomeTagWhitelist().stream().anyMatch(tags::contains)) return false;
                return true;
            }).forEach(e -> {
                double weight = this.computeWeight(player, (String)e.getKey(), (TrainerMobData)e.getValue());
                if (weight > 0.0) {
                    candidates.add(new SpawnCandidate(this, (String)e.getKey(), weight));
                }
            });
        }
        return candidates.size() > 0 ? this.selectRandom(player.method_59922(), candidates) : null;
    }

    private SpawnCandidate selectRandom(class_5819 rng, List<SpawnCandidate> candidates) {
        int i;
        Double totalWeight = candidates.stream().map(c -> c.weight).reduce(0.0, (a, b) -> a + b);
        double r = rng.method_43058() * totalWeight;
        for (i = 0; i < candidates.size() - 1 && !((r -= candidates.get((int)i).weight) <= 0.0); ++i) {
        }
        return candidates.get(i);
    }

    private double computeChance(class_1657 player, String trainerId, TrainerMobData mobTr) {
        PlayerState ps = PlayerState.get(player);
        IServerConfig config = RCTMod.getInstance().getServerConfig();
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        int playerLevel = tm.getPlayerLevel(player);
        int reqLevelCap = mobTr.getRequiredLevelCap();
        int levelCap = ps.getLevelCap();
        double chance = 0.42;
        if (!ps.isKeyTrainer(trainerId)) {
            chance /= (double)NON_KEY_TRAINER_SPAWN_CHANCE_DIV;
        }
        double e = 1.0 - (double)Math.min(config.maxLevelDiff(), Math.abs(Math.min(playerLevel, levelCap) - reqLevelCap)) / (double)config.maxLevelDiff();
        return chance * e * e;
    }

    private double computeWeight(class_1657 player, String trainerId, TrainerMobData mobTr) {
        int diff;
        PlayerState ps = PlayerState.get(player);
        if (!ps.canBattle(trainerId)) {
            return 0.0;
        }
        IServerConfig config = RCTMod.getInstance().getServerConfig();
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        int playerLevel = tm.getPlayerLevel(player);
        int reqLevelCap = mobTr.getRequiredLevelCap();
        int levelCap = ps.getLevelCap();
        float keyTrainerFactor = 1.0f;
        boolean isKey = ps.isKeyTrainer(trainerId);
        if (isKey) {
            float a = (float)(10 - Math.min(9, levelCap / 10)) / 2.0f;
            float b = (float)Math.max(0, reqLevelCap - playerLevel) * a + 1.0f;
            keyTrainerFactor = KEY_TRAINER_SPAWN_WEIGHT_FACTOR / b;
        }
        return (diff = Math.abs(Math.min(playerLevel, levelCap) - reqLevelCap)) > config.maxLevelDiff() ? 0.0 : (double)((float)(config.maxLevelDiff() + 1 - diff) * mobTr.getSpawnWeightFactor() * keyTrainerFactor);
    }

    private class SpawnCandidate {
        public final String id;
        public final double weight;

        public SpawnCandidate(TrainerSpawner trainerSpawner, String id, double weight) {
            this.id = id;
            this.weight = weight;
        }
    }
}

