/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.config;

import com.gitlab.srcmc.rctmod.api.config.IServerConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ServerConfig
implements IServerConfig {
    private final ModConfigSpec.ConfigValue<Double> globalSpawnChanceValue;
    private final ModConfigSpec.ConfigValue<Double> globalSpawnChanceMinimumValue;
    private final ModConfigSpec.ConfigValue<Integer> spawnIntervalTicksValue;
    private final ModConfigSpec.ConfigValue<Integer> spawnIntervalTicksMaximumValue;
    private final ModConfigSpec.ConfigValue<Integer> maxHorizontalDistanceToPlayersValue;
    private final ModConfigSpec.ConfigValue<Integer> minHorizontalDistanceToPlayersValue;
    private final ModConfigSpec.ConfigValue<Integer> maxVerticalDistanceToPlayersValue;
    private final ModConfigSpec.ConfigValue<Integer> maxTrainersPerPlayerValue;
    private final ModConfigSpec.ConfigValue<Integer> maxTrainersTotalValue;
    private final ModConfigSpec.ConfigValue<Integer> maxLevelDiffValue;
    private final ModConfigSpec.ConfigValue<List<? extends String>> dimensionBlacklistValue;
    private final ModConfigSpec.ConfigValue<List<? extends String>> dimensionWhitelistValue;
    private final ModConfigSpec.ConfigValue<List<? extends String>> biomeTagBlacklistValue;
    private final ModConfigSpec.ConfigValue<List<? extends String>> biomeTagWhitelistValue;
    private final ModConfigSpec.ConfigValue<List<? extends String>> trainerSpawnerItemsValue;
    private double globalSpawnChanceCached;
    private double globalSpawnChanceMinimumCached;
    private int spawnIntervalTicksCached;
    private int spawnIntervalTicksMaximumCached;
    private int maxHorizontalDistanceToPlayersCached;
    private int minHorizontalDistanceToPlayersCached;
    private int maxVerticalDistanceToPlayersCached;
    private int maxTrainersPerPlayerCached;
    private int maxTrainersTotalCached;
    private int maxLevelDiffCached;
    private List<? extends String> dimensionBlacklistCached;
    private List<? extends String> dimensionWhitelistCached;
    private List<? extends String> biomeTagBlacklistCached;
    private List<? extends String> biomeTagWhitelistCached;
    private Map<String, List<String>> trainerSpawnerItemsParsed;
    private Map<String, Set<class_1792>> trainerIdToSpawnerItems;
    private final ModConfigSpec.ConfigValue<Integer> initialLevelCapValue;
    private final ModConfigSpec.ConfigValue<Integer> additiveLevelCapRequirementValue;
    private final ModConfigSpec.ConfigValue<Boolean> allowOverLevelingValue;
    private int initialLevelCapCached;
    private int additiveLevelCapRequirementCached;
    private boolean allowOverLevelingCached;
    private final ModConfigSpec.ConfigValue<Boolean> logSpawningValue;
    private boolean logSpawningCached;
    private final ModConfigSpec spec;

    public ServerConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.push("Spawning");
        this.globalSpawnChanceValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "A global factor that determines if a spawn attempt for a trainer is made."}).defineInRange("globalSpawnChance", IServerConfig.super.globalSpawnChance(), 0.0, 1.0);
        this.globalSpawnChanceMinimumValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "The chance for a trainer to spawn will shrink towards this value based of how many", "trainers are already spawned in for a player. For example if a player has 0 trainers", "spawned for them the chance will be as configured by globalSpawnChance if a player", "has barely filled up their spawn cap (maxTrainersPerPlayer), i.e. only one more free", "spot is left, the chance for the last trainer will be as configured by globalSpawnChanceMinimum.", "Set to any value equal to or above globalSpawnChance to disable (e.g. 1.0)."}).defineInRange("globalSpawnChanceMinimum", IServerConfig.super.globalSpawnChanceMinimum(), 0.0, 1.0);
        this.spawnIntervalTicksValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "The interval in ticks at which a spawn attempt is made per player."}).defineInRange("spawnIntervalTicks", IServerConfig.super.spawnIntervalTicks(), 1, 0x7FFFFFFE);
        this.spawnIntervalTicksMaximumValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "The spawn interval ticks will grow towards this value based of how many trainers are already", "spawned in for a player. For example if a player has 0 trainers spawned for them the spawn", "interval ticks will be as configured by spawnIntervalTicks, if a player has barely filled up their", "spawn cap (maxTrainersPerPlayer), i.e. only one more free spot is left, the spawn interval for the", "last trainer will be as configured by spawnIntervalTicksMaximum. Set to any value equal to or below", "spawnIntervalTicks to disable (e.g. 0)."}).defineInRange("spawnIntervalTicksMaximum", IServerConfig.super.spawnIntervalTicksMaximum(), 0, 0x7FFFFFFE);
        this.maxHorizontalDistanceToPlayersValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "The max horizontal distance a trainer can spawn from players."}).defineInRange("maxHorizontalDistanceToPlayers", IServerConfig.super.maxHorizontalDistanceToPlayers(), 1, 0x7FFFFFFE);
        this.minHorizontalDistanceToPlayersValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "The min horizontal distance a trainer can spawn from players."}).defineInRange("minHorizontalDistanceToPlayers", IServerConfig.super.minHorizontalDistanceToPlayers(), 1, 0x7FFFFFFE);
        this.maxVerticalDistanceToPlayersValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "The max vertical distance a trainer can spawn from players."}).defineInRange("maxVerticalDistanceToPlayers", IServerConfig.super.maxVerticalDistanceToPlayers(), 1, 0x7FFFFFFE);
        this.maxTrainersPerPlayerValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "Spawn cap of trainers per player."}).defineInRange("maxTrainersPerPlayer", IServerConfig.super.maxTrainersPerPlayer(), 0, 0x7FFFFFFE);
        this.maxTrainersTotalValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "Total trainer spawn cap. This value may be increased for servers with higher expected", "player numbers (> 4), for example (|players| + 1)*maxTrainersPerPlayer."}).defineInRange("maxTrainersTotal", IServerConfig.super.maxTrainersTotal(), 0, 0x7FFFFFFE);
        this.maxLevelDiffValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "The maximum level difference between the strongest pokemon in the team of a player and the strongest", "pokemon in the team of a trainer to spawn for that player. The spawn weight decreases with a higher", "level difference. Trainers with pokemon above the level cap of a player are excluded."}).defineInRange("maxLevelDiff", IServerConfig.super.maxLevelDiff(), 0, 100);
        this.dimensionBlacklistValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "A comma separated list of dimensions (e.g. [\"multiworld:spawn\", \"minecraft:the_end\"]).", "In these dimensions trainers will never spawn."}).defineList("dimensionBlacklist", IServerConfig.super.dimensionBlacklist(), String::new, element -> true);
        this.dimensionWhitelistValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "A comma separated list of dimensions (e.g. [\"multiworld:spawn\" , \"minecraft:the_end\"]).", "Trainers may only spawn in these dimensions (unless the list is empty)."}).defineList("dimensionWhitelist", IServerConfig.super.dimensionWhitelist(), String::new, element -> true);
        this.biomeTagBlacklistValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "A comma separated list of biome tags (e.g. [\"is_overworld\", \"is_forest\"]).", "A biome may not have any of the given tags attached to it, for a trainer to spawn in that biome.", "Trainers may also have additional tags defined by a data pack."}).defineList("biomeTagBlacklist", IServerConfig.super.biomeTagBlacklist(), String::new, element -> true);
        this.biomeTagWhitelistValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "A comma separated list of biome tags (e.g. [\"is_overworld\", \"is_forest\"]).", "A biome must have atleast one of the given tags attached to it, for a trainer to spawn in that", "biome (unless the list is empty). Trainers may also have additional tags defined by a data pack."}).defineList("biomeTagWhitelist", IServerConfig.super.biomeTagWhitelist(), String::new, element -> true);
        this.trainerSpawnerItemsValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "A list of items that can be used to configure a trainer spawner to spawn specific", "trainers. Every entry must define an item followed by a space seperated list of", "trainer ids (of which one will be randomly chosen to spawn)."}).defineList("trainerSpawnerItems", ServerConfig.trainerSpawnerItemList(IServerConfig.super.trainerSpawnerItems()), String::new, element -> true);
        builder.pop();
        builder.push("Players");
        this.initialLevelCapValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "Initial level cap of players. Pokemon will not gain any experience if at or above the level cap."}).defineInRange("initialLevelCap", IServerConfig.super.initialLevelCap(), 1, 100);
        this.additiveLevelCapRequirementValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "The required level cap for trainers is based of the strongest pokemon in their team.", "This value will be added to the derived level cap. Example: A trainer with a Pikachu at level 50", "has a level cap requirement of 50. If the additiveLevelCapRequirement is -10 the required level cap", "of that trainer becomes 40, if it is 10 the level cap requirement becomes 60."}).define("additiveLevelCapRequirement", (Object)IServerConfig.super.additiveLevelCapRequirement());
        this.allowOverLevelingValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "If enabled the level cap of a players will not prevent their pokemon from gaining experience and leveling up.", "Trainers will still refuse to battle players that carry pokemon above their level cap!"}).define("allowOverLeveling", IServerConfig.super.allowOverLeveling());
        builder.pop();
        builder.push("Debug");
        this.logSpawningValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "If enabled additional information are printed to the log whenever a trainer spawns or despawns."}).define("logSpawning", IServerConfig.super.logSpawning());
        this.spec = builder.build();
        this.trainerSpawnerItemsParsed = new HashMap<String, List<String>>();
        this.trainerIdToSpawnerItems = new HashMap<String, Set<class_1792>>();
    }

    @Override
    public void reload() {
        this.trainerSpawnerItemsParsed = new HashMap<String, List<String>>();
        this.trainerIdToSpawnerItems = new HashMap<String, Set<class_1792>>();
        for (String entry : (List)this.trainerSpawnerItemsValue.get()) {
            ServerConfig.parseTrainerSpawnerItem(this.trainerSpawnerItemsParsed, entry);
        }
        this.trainerSpawnerItemsParsed.forEach((itemKey, tids) -> {
            class_2960 itemRl = class_2960.method_60654((String)itemKey);
            if (class_7923.field_41178.method_10250(itemRl)) {
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemRl);
                tids.forEach(tid -> this.trainerIdToSpawnerItems.compute((String)tid, (k, v) -> {
                    if (v == null) {
                        v = new HashSet<class_1792>();
                    }
                    v.add(item);
                    return v;
                }));
            }
        });
        this.updateCache();
    }

    private void updateCache() {
        this.globalSpawnChanceCached = (Double)this.globalSpawnChanceValue.get();
        this.globalSpawnChanceMinimumCached = (Double)this.globalSpawnChanceMinimumValue.get();
        this.spawnIntervalTicksCached = (Integer)this.spawnIntervalTicksValue.get();
        this.spawnIntervalTicksMaximumCached = (Integer)this.spawnIntervalTicksMaximumValue.get();
        this.maxHorizontalDistanceToPlayersCached = (Integer)this.maxHorizontalDistanceToPlayersValue.get();
        this.minHorizontalDistanceToPlayersCached = (Integer)this.minHorizontalDistanceToPlayersValue.get();
        this.maxVerticalDistanceToPlayersCached = (Integer)this.maxVerticalDistanceToPlayersValue.get();
        this.maxTrainersPerPlayerCached = (Integer)this.maxTrainersPerPlayerValue.get();
        this.maxTrainersTotalCached = (Integer)this.maxTrainersTotalValue.get();
        this.maxLevelDiffCached = (Integer)this.maxLevelDiffValue.get();
        this.dimensionBlacklistCached = List.copyOf((Collection)this.dimensionBlacklistValue.get());
        this.dimensionWhitelistCached = List.copyOf((Collection)this.dimensionWhitelistValue.get());
        this.biomeTagBlacklistCached = List.copyOf((Collection)this.biomeTagBlacklistValue.get());
        this.biomeTagWhitelistCached = List.copyOf((Collection)this.biomeTagWhitelistValue.get());
        this.initialLevelCapCached = (Integer)this.initialLevelCapValue.get();
        this.additiveLevelCapRequirementCached = (Integer)this.additiveLevelCapRequirementValue.get();
        this.allowOverLevelingCached = (Boolean)this.allowOverLevelingValue.get();
        this.logSpawningCached = (Boolean)this.logSpawningValue.get();
    }

    @Override
    public ModConfigSpec getSpec() {
        return this.spec;
    }

    @Override
    public double globalSpawnChance() {
        return this.globalSpawnChanceCached;
    }

    @Override
    public double globalSpawnChanceMinimum() {
        return this.globalSpawnChanceMinimumCached;
    }

    @Override
    public int spawnIntervalTicks() {
        return this.spawnIntervalTicksCached;
    }

    @Override
    public int spawnIntervalTicksMaximum() {
        return this.spawnIntervalTicksMaximumCached;
    }

    @Override
    public int maxHorizontalDistanceToPlayers() {
        return this.maxHorizontalDistanceToPlayersCached;
    }

    @Override
    public int minHorizontalDistanceToPlayers() {
        return this.minHorizontalDistanceToPlayersCached;
    }

    @Override
    public int maxVerticalDistanceToPlayers() {
        return this.maxVerticalDistanceToPlayersCached;
    }

    @Override
    public int maxTrainersPerPlayer() {
        return this.maxTrainersPerPlayerCached;
    }

    @Override
    public int maxTrainersTotal() {
        return this.maxTrainersTotalCached;
    }

    @Override
    public int maxLevelDiff() {
        return this.maxLevelDiffCached;
    }

    @Override
    public List<? extends String> dimensionBlacklist() {
        return this.dimensionBlacklistCached;
    }

    @Override
    public List<? extends String> dimensionWhitelist() {
        return this.dimensionWhitelistCached;
    }

    @Override
    public List<? extends String> biomeTagBlacklist() {
        return this.biomeTagBlacklistCached;
    }

    @Override
    public List<? extends String> biomeTagWhitelist() {
        return this.biomeTagWhitelistCached;
    }

    @Override
    public Map<String, List<String>> trainerSpawnerItems() {
        return Collections.unmodifiableMap(this.trainerSpawnerItemsParsed);
    }

    @Override
    public Set<class_1792> spawnerItemsFor(String trainerId) {
        return Collections.unmodifiableSet(this.trainerIdToSpawnerItems.getOrDefault(trainerId, Set.of()));
    }

    @Override
    public int initialLevelCap() {
        return this.initialLevelCapCached;
    }

    @Override
    public int additiveLevelCapRequirement() {
        return this.additiveLevelCapRequirementCached;
    }

    @Override
    public boolean allowOverLeveling() {
        return this.allowOverLevelingCached;
    }

    @Override
    public boolean logSpawning() {
        return this.logSpawningCached;
    }

    public static void parseTrainerSpawnerItem(Map<String, List<String>> target, String trainerSpawnerItem) {
        String[] values = trainerSpawnerItem.split(" ");
        if (values.length > 1) {
            target.put(values[0], Arrays.stream(values).skip(1L).toList());
        }
    }

    public static List<String> trainerSpawnerItemList(Map<String, List<String>> trainerSpawnerItems) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : trainerSpawnerItems.entrySet()) {
            list.add(String.format("%s%s", entry.getKey(), entry.getValue().stream().reduce("", (a, b) -> a + " " + b)));
        }
        return list;
    }
}

