/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.world.blocks.entities;

import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.ModRegistries;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.service.TrainerSpawner;
import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4051;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class TrainerSpawnerBlockEntity
extends class_2586 {
    private static final int SPAWN_INTERVAL_TICKS = 80;
    private static final int SCAN_INTERVAL_TICKS = 200;
    private String renderItemKey;
    private double minPlayerDistance;
    private double maxPlayerDistance;
    private Timer spawnTimer = new Timer(this);
    private Timer scanTimer = new Timer(this);
    private class_1792 renderItem;
    private class_238 aabb;

    public TrainerSpawnerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)ModRegistries.BlockEntityTypes.TRAINER_SPAWNER.get(), blockPos, blockState);
        this.setPlayerDistanceThreshold((double)RCTMod.getInstance().getServerConfig().minHorizontalDistanceToPlayers() * 0.6666666666666666, (double)RCTMod.getInstance().getServerConfig().maxHorizontalDistanceToPlayers() * 0.6666666666666666);
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        class_2487 tag = super.method_16887(provider);
        this.method_11007(tag, provider);
        return tag;
    }

    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        if (this.renderItemKey != null) {
            tag.method_10582("renderItemKey", this.renderItemKey);
        }
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        if (tag.method_10545("renderItemKey")) {
            this.setRenderItemKey(tag.method_10558("renderItemKey"));
        } else {
            this.setRenderItemKey(null);
        }
    }

    public void setRenderItem(String renderItemKey) {
        this.setRenderItemKey(renderItemKey);
        this.spawnTimer.reset(this.field_11863.method_8510());
        this.scanTimer.reset(this.field_11863.method_8510());
        this.method_5431();
        if (!this.field_11863.field_9236) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
        }
    }

    public List<String> getTrainerIds() {
        return Collections.unmodifiableList(RCTMod.getInstance().getServerConfig().trainerSpawnerItems().getOrDefault(this.renderItemKey, List.of()));
    }

    public double getMinPlayerDistance() {
        return this.minPlayerDistance;
    }

    public double getMaxPlayerDistance() {
        return this.maxPlayerDistance;
    }

    public String getRenderItemKey() {
        return this.renderItemKey;
    }

    public class_1792 getRenderItem() {
        return this.renderItem;
    }

    protected void setPlayerDistanceThreshold(double min, double max) {
        this.minPlayerDistance = min;
        this.maxPlayerDistance = max;
        this.aabb = new class_238(this.method_11016()).method_1014(max);
    }

    protected void setRenderItemKey(String renderItemKey) {
        if (renderItemKey != null) {
            class_2960 rl = class_2960.method_60654((String)renderItemKey);
            if (!class_7923.field_41178.method_10250(rl)) {
                ModCommon.LOG.info("Invalid render item for Trainer Spawner: " + rl.toString());
                this.renderItem = null;
            } else {
                this.renderItem = (class_1792)class_7923.field_41178.method_10223(rl);
            }
        }
        this.renderItemKey = renderItemKey;
    }

    private void attemptSpawn(class_1937 level, class_2338 blockPos) {
        class_243 pos = blockPos.method_46558();
        class_1657 nearest = level.method_18463(class_4051.method_36626(), null, pos.field_1352, pos.field_1351, pos.field_1350);
        if (nearest == null || nearest.method_5707(pos) < Math.pow(this.minPlayerDistance, 2.0) / 2.0) {
            return;
        }
        TrainerSpawner spawner = RCTMod.getInstance().getTrainerSpawner();
        ArrayList<String> trainerIds = new ArrayList<String>(this.getTrainerIds());
        Collections.shuffle(trainerIds);
        for (class_1657 player : level.method_18464(class_4051.method_36626(), null, this.aabb)) {
            for (String trainerId : trainerIds) {
                if (!spawner.attemptSpawnFor(player, trainerId, this.method_11016().method_10084(), true, true, 1.0, 1.0)) continue;
                return;
            }
        }
    }

    private void scanForTrainerNearby(class_1937 level) {
        List<String> trainerIds = this.getTrainerIds();
        level.method_18466(TrainerMob.class, class_4051.method_36626(), null, this.aabb).stream().filter(t -> trainerIds.contains(t.getTrainerId())).forEach(t -> t.setHomePos(this.method_11016().method_10084()));
    }

    public static void serverTick(class_1937 level, class_2338 blockPos, class_2680 blockState, TrainerSpawnerBlockEntity be) {
        if (be.getRenderItemKey() != null) {
            if (be.spawnTimer.passed(level.method_8510()) >= 80L) {
                be.attemptSpawn(level, blockPos);
                be.spawnTimer.reset(level.method_8510());
            }
            if (be.scanTimer.passed(level.method_8510()) >= 200L) {
                be.scanForTrainerNearby(level);
                be.scanTimer.reset(level.method_8510());
            }
        }
    }

    public static void clientTick(class_1937 level, class_2338 blockPos, class_2680 blockState, TrainerSpawnerBlockEntity be) {
    }

    class Timer {
        private long prev;
        private long total;

        Timer(TrainerSpawnerBlockEntity this$0) {
        }

        public void reset(long now) {
            this.prev = now;
            this.total = 0L;
        }

        public long passed(long now) {
            this.total += now - this.prev;
            this.prev = now;
            return this.total;
        }
    }
}

