/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.world.loot.conditions;

import com.gitlab.srcmc.rctmod.ModRegistries;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_181;
import net.minecraft.class_3542;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_5342;

public record DefeatCountCondition(Comparator comparator, int count) implements class_5341
{
    private static Supplier<class_5342> TYPE = ModRegistries.LootItemConditions.DEFEAT_COUNT;
    public static final MapCodec<DefeatCountCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Comparator.CODEC.optionalFieldOf("comparator", (Object)Comparator.EQUAL).forGetter(DefeatCountCondition::comparator), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(DefeatCountCondition::count)).apply((Applicative)instance, DefeatCountCondition::new));

    public class_5342 method_29325() {
        return TYPE.get();
    }

    public boolean test(class_47 lootContext) {
        Object object;
        class_1657 player = (class_1657)lootContext.method_296(class_181.field_1233);
        if (player != null && (object = lootContext.method_296(class_181.field_1226)) instanceof TrainerMob) {
            TrainerMob mob = (TrainerMob)((Object)object);
            return this.comparator.test(RCTMod.getInstance().getTrainerManager().getBattleMemory(mob).getDefeatByCount(player), this.count);
        }
        return false;
    }

    public static enum Comparator implements class_3542
    {
        EQUAL("==", (a, b) -> a.equals(b)),
        LESS("<", (a, b) -> a < b),
        LESS_OR_EQUAL("<=", (a, b) -> a <= b),
        GREATER(">", (a, b) -> a > b),
        GREATER_OR_EQUAL(">=", (a, b) -> a >= b),
        MODULO("%", (a, b) -> a % b == 0);

        public static final Codec<Comparator> CODEC;
        private BiFunction<Integer, Integer, Boolean> testFunc;
        private String name;

        private Comparator(String name, BiFunction<Integer, Integer, Boolean> testFunc) {
            this.testFunc = testFunc;
            this.name = name;
        }

        public boolean test(int a, int b) {
            return this.testFunc.apply(a, b);
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(Comparator::values);
        }
    }
}

