/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.inventory;

import com.tom.storagemod.inventory.IInventoryAccess;
import com.tom.storagemod.inventory.InventoryImage;
import com.tom.storagemod.inventory.InventorySlot;
import com.tom.storagemod.inventory.StoredItemStack;
import com.tom.storagemod.inventory.filter.ItemPredicate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1937;

public class InventoryChangeTracker
implements IInventoryAccess.IInventoryChangeTracker,
IInventoryAccess.IChangeNotifier,
IInventoryAccess.IMultiThreadedTracker<InventoryImage, InventoryImage.InvState> {
    public static final InventoryChangeTracker NULL = new InventoryChangeTracker(null);
    private Storage<ItemVariant> storage;
    private long lastUpdate;
    private long lastVersion;
    private long lastChange;
    private Map<StorageView<ItemVariant>, StoredItemStack> lastItems = new HashMap<StorageView<ItemVariant>, StoredItemStack>();

    public InventoryChangeTracker(Storage<ItemVariant> itemHandler) {
        this.storage = itemHandler;
    }

    @Override
    public long getChangeTracker(class_1937 level) {
        long ver;
        Storage<ItemVariant> h = this.storage;
        if (h == null) {
            return 0L;
        }
        if (this.lastUpdate != level.method_8510() && (ver = h.getVersion()) != this.lastVersion) {
            boolean change = false;
            for (StorageView is : h) {
                change |= this.updateChange((StorageView<ItemVariant>)is);
            }
            if (change) {
                this.lastChange = System.nanoTime();
            }
            this.lastUpdate = level.method_8510();
            this.lastVersion = ver;
        }
        return this.lastChange;
    }

    protected boolean checkFilter(StorageView<ItemVariant> stack) {
        return this.checkFilter(new StoredItemStack(((ItemVariant)stack.getResource()).toStack(), stack.getAmount(), ((ItemVariant)stack.getResource()).hashCode()));
    }

    protected boolean checkFilter(StoredItemStack stack) {
        return true;
    }

    protected int getCount(StorageView<ItemVariant> is) {
        return (int)is.getAmount();
    }

    protected int getCount(InventoryImage.FabricStack is) {
        return (int)is.count();
    }

    private boolean updateChange(StorageView<ItemVariant> iv) {
        StorageView uv = iv.getUnderlyingView();
        StoredItemStack li = this.lastItems.get(uv);
        if (!iv.isResourceBlank() && this.checkFilter(iv)) {
            int cnt = this.getCount(iv);
            if (li == null || !class_1799.method_31577((class_1799)li.getStack(), (class_1799)((ItemVariant)iv.getResource()).toStack())) {
                this.lastItems.put((StorageView<ItemVariant>)uv, new StoredItemStack(((ItemVariant)iv.getResource()).toStack(), cnt, ((ItemVariant)iv.getResource()).hashCode()));
                return true;
            }
            if (li.getQuantity() != (long)cnt) {
                li.setCount(cnt);
                return true;
            }
        } else if (li != null) {
            this.lastItems.put((StorageView<ItemVariant>)uv, null);
            return true;
        }
        return false;
    }

    protected StorageView<ItemVariant> getSlotHandler(StorageView<ItemVariant> def) {
        return def;
    }

    protected Storage<ItemVariant> getSlotHandler(Storage<ItemVariant> def) {
        return def;
    }

    @Override
    public Stream<StoredItemStack> streamWrappedStacks(boolean parallel) {
        Storage<ItemVariant> h = this.storage;
        if (h == null) {
            return Stream.empty();
        }
        return this.lastItems.values().stream().filter(e -> e != null);
    }

    @Override
    public long countItems(StoredItemStack filter) {
        Storage<ItemVariant> h = this.storage;
        if (h == null) {
            return 0L;
        }
        long c = 0L;
        for (StoredItemStack is : this.lastItems.values()) {
            if (is == null || !is.equalItem(filter)) continue;
            c += is.getQuantity();
        }
        return c;
    }

    @Override
    public InventorySlot findSlot(ItemPredicate filter, boolean findEmpty) {
        return this.findSlot(filter, findEmpty, Collections.emptySet());
    }

    private InventorySlot findSlot(ItemPredicate filter, boolean findEmpty, Set<StorageView<ItemVariant>> seen) {
        Storage<ItemVariant> h = this.storage;
        if (h == null) {
            return null;
        }
        for (StorageView slot : h) {
            ItemVariant iv;
            if (slot.isResourceBlank()) {
                if (!findEmpty || seen.contains(slot.getUnderlyingView())) continue;
                return new InventorySlot(this.getSlotHandler(h), this.getSlotHandler((StorageView<ItemVariant>)slot), this, seen);
            }
            if (this.getCount((StorageView<ItemVariant>)slot) < 1 || seen.contains(slot.getUnderlyingView()) || !filter.test(new StoredItemStack((iv = (ItemVariant)slot.getResource()).toStack(), slot.getAmount(), slot.hashCode()))) continue;
            Transaction tr = Transaction.openOuter();
            try {
                if (slot.extract((Object)iv, 1L, (TransactionContext)tr) != 1L) continue;
                InventorySlot inventorySlot = new InventorySlot(this.getSlotHandler(h), this.getSlotHandler((StorageView<ItemVariant>)slot), this, seen);
                return inventorySlot;
            }
            finally {
                if (tr == null) continue;
                tr.close();
            }
        }
        return null;
    }

    @Override
    public InventorySlot findSlotAfter(InventorySlot slotIn, ItemPredicate filter, boolean findEmpty, boolean loop) {
        if (slotIn == null) {
            return this.findSlot(filter, findEmpty);
        }
        InventorySlot sl = this.findSlot(filter, findEmpty, slotIn.nextSlot());
        if (sl == null && loop) {
            return this.findSlot(filter, findEmpty);
        }
        return sl;
    }

    @Override
    public InventorySlot findSlotDest(StoredItemStack forStack) {
        return this.findSlotDest(forStack, Collections.emptySet());
    }

    private InventorySlot findSlotDest(StoredItemStack forStack, Set<StorageView<ItemVariant>> seen) {
        Storage<ItemVariant> h = this.storage;
        if (h == null) {
            return null;
        }
        if (!this.checkFilter(forStack)) {
            return null;
        }
        ItemVariant iv = ItemVariant.of((class_1799)forStack.getStack());
        try (Transaction tr = Transaction.openOuter();){
            long c = h.insert((Object)iv, forStack.getQuantity(), (TransactionContext)tr);
            if (c > 0L) {
                InventorySlot inventorySlot = new InventorySlot(this.getSlotHandler(h), null, this, seen);
                return inventorySlot;
            }
        }
        return null;
    }

    @Override
    public InventorySlot findSlotDestAfter(InventorySlot slotIn, StoredItemStack forStack, boolean loop) {
        if (slotIn == null) {
            return this.findSlotDest(forStack);
        }
        if (slotIn.getView() == null) {
            if (loop) {
                return this.findSlotDest(forStack);
            }
            return null;
        }
        InventorySlot sl = this.findSlotDest(forStack, slotIn.nextSlot());
        if (sl == null && loop) {
            return this.findSlotDest(forStack);
        }
        return sl;
    }

    @Override
    public void onSlotChanged(InventorySlot slot) {
        if (slot.getView() != null && this.updateChange(slot.getView())) {
            this.lastChange = System.nanoTime();
        }
    }

    @Override
    public InventoryImage prepForOffThread(class_1937 level) {
        if (this.lastUpdate == level.method_8510()) {
            return null;
        }
        Storage<ItemVariant> h = this.storage;
        if (h == null) {
            return null;
        }
        long ver = h.getVersion();
        if (ver == this.lastVersion) {
            return null;
        }
        InventoryImage im = new InventoryImage(ver);
        for (StorageView is : h) {
            im.addStack((StorageView<ItemVariant>)is);
        }
        return im;
    }

    @Override
    public InventoryImage.InvState processOffThread(InventoryImage array) {
        boolean change = false;
        List<InventoryImage.FabricStack> st = array.getStacks();
        HashMap<StorageView<ItemVariant>, StoredItemStack> mod = new HashMap<StorageView<ItemVariant>, StoredItemStack>();
        for (int i = 0; i < st.size(); ++i) {
            InventoryImage.FabricStack s = st.get(i);
            change |= this.updateChangeM(s, mod);
        }
        if (change) {
            return new InventoryImage.InvState(System.nanoTime(), array.getVersion(), mod);
        }
        return new InventoryImage.InvState(this.lastChange, this.lastVersion, Collections.emptyMap());
    }

    private boolean updateChangeM(InventoryImage.FabricStack st, Map<StorageView<ItemVariant>, StoredItemStack> mod) {
        class_1799 is;
        StorageView<ItemVariant> uv = st.uv();
        StorageView<ItemVariant> iv = st.view();
        StoredItemStack li = this.lastItems.get(uv);
        if (!st.item().isBlank() && this.checkFilter(new StoredItemStack(is = st.item().toStack(), st.count(), st.item().hashCode()))) {
            int cnt = this.getCount(iv);
            if (li == null || !class_1799.method_31577((class_1799)li.getStack(), (class_1799)is)) {
                mod.put(uv, new StoredItemStack(is, cnt, st.item().hashCode()));
                return true;
            }
            if (li.getQuantity() != (long)cnt) {
                li.setCount(cnt);
                return true;
            }
            return false;
        }
        if (li != null) {
            mod.put(uv, null);
            return true;
        }
        return false;
    }

    @Override
    public long finishOffThreadProcess(class_1937 level, InventoryImage.InvState ct) {
        if (ct == null) {
            return this.lastChange;
        }
        this.lastChange = ct.change();
        this.lastVersion = ct.version();
        this.lastUpdate = level.method_8510();
        this.lastItems.putAll(ct.mod());
        return this.lastChange;
    }

    public void refresh(Storage<ItemVariant> h) {
        this.storage = h;
    }
}

